/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.http;

import io.gatling.core.Predef;
import io.gatling.core.action.builder.ActionBuilder;
import io.gatling.core.body.Body;
import io.gatling.http.request.builder.HttpRequestBuilder;
import io.gatling.http.response.Response;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Bodies;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.http.BodyPart;
import io.gatling.javaapi.http.RequestActionBuilder;
import io.gatling.javaapi.http.internal.HttpChecks;
import io.gatling.javaapi.http.internal.ScalaHttpRequestActionBuilderConditions;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class HttpRequestActionBuilder
extends RequestActionBuilder<HttpRequestActionBuilder, HttpRequestBuilder> {
    public HttpRequestActionBuilder(HttpRequestBuilder httpRequestBuilder) {
        super(httpRequestBuilder);
    }

    @Override
    protected HttpRequestActionBuilder make(Function<HttpRequestBuilder, HttpRequestBuilder> function) {
        return new HttpRequestActionBuilder(function.apply((HttpRequestBuilder)this.wrapped));
    }

    public ActionBuilder asScala() {
        return (ActionBuilder)this.wrapped;
    }

    @Nonnull
    public HttpRequestActionBuilder check(CheckBuilder ... checkBuilderArray) {
        return this.check(Arrays.asList(checkBuilderArray));
    }

    @Nonnull
    public HttpRequestActionBuilder check(@Nonnull List<CheckBuilder> list) {
        return new HttpRequestActionBuilder(((HttpRequestBuilder)this.wrapped).check(HttpChecks.toScalaChecks(list)));
    }

    @Nonnull
    public UntypedCondition checkIf(@Nonnull String string) {
        return new UntypedCondition(ScalaHttpRequestActionBuilderConditions.untyped((HttpRequestBuilder)this.wrapped, string));
    }

    @Nonnull
    public UntypedCondition checkIf(@Nonnull Function<Session, Boolean> function) {
        return new UntypedCondition(ScalaHttpRequestActionBuilderConditions.untyped((HttpRequestBuilder)this.wrapped, function));
    }

    public TypedCondition checkIf(BiFunction<Response, Session, Boolean> biFunction) {
        return new TypedCondition(ScalaHttpRequestActionBuilderConditions.typed((HttpRequestBuilder)this.wrapped, biFunction));
    }

    @Nonnull
    public HttpRequestActionBuilder ignoreProtocolChecks() {
        return this.make(HttpRequestBuilder::ignoreProtocolChecks);
    }

    @Nonnull
    public HttpRequestActionBuilder silent() {
        return this.make(HttpRequestBuilder::silent);
    }

    @Nonnull
    public HttpRequestActionBuilder notSilent() {
        return this.make(HttpRequestBuilder::notSilent);
    }

    @Nonnull
    public HttpRequestActionBuilder disableFollowRedirect() {
        return this.make(HttpRequestBuilder::disableFollowRedirect);
    }

    @Nonnull
    public HttpRequestActionBuilder transformResponse(@Nonnull BiFunction<Response, Session, Response> biFunction) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.transformResponse(Expressions.javaBiFunctionToExpression((BiFunction)biFunction)));
    }

    @Nonnull
    public HttpRequestActionBuilder body(io.gatling.javaapi.core.Body body) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.body(body.asScala()));
    }

    @Nonnull
    public HttpRequestActionBuilder processRequestBody(@Nonnull Function<io.gatling.javaapi.core.Body, ? extends io.gatling.javaapi.core.Body> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.processRequestBody(body -> ((io.gatling.javaapi.core.Body)function.apply(Bodies.toJavaBody((Body)body))).asScala()));
    }

    @Nonnull
    public HttpRequestActionBuilder bodyPart(@Nonnull BodyPart bodyPart) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.bodyPart(bodyPart.asScala()));
    }

    @Nonnull
    public HttpRequestActionBuilder bodyParts(BodyPart ... bodyPartArray) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.bodyParts(Converters.toScalaSeq(Arrays.stream(bodyPartArray).map(BodyPart::asScala).collect(Collectors.toList()))));
    }

    @Nonnull
    public HttpRequestActionBuilder bodyParts(@Nonnull List<BodyPart> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.bodyParts(Converters.toScalaSeq(list.stream().map(BodyPart::asScala).collect(Collectors.toList()))));
    }

    @Nonnull
    public HttpRequestActionBuilder resources(HttpRequestActionBuilder ... httpRequestActionBuilderArray) {
        return this.resources(Arrays.asList(httpRequestActionBuilderArray));
    }

    @Nonnull
    public HttpRequestActionBuilder resources(@Nonnull List<HttpRequestActionBuilder> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.resources(Converters.toScalaSeq(list.stream().map(httpRequestActionBuilder -> (HttpRequestBuilder)httpRequestActionBuilder.wrapped).collect(Collectors.toList()))));
    }

    @Nonnull
    public HttpRequestActionBuilder asMultipartForm() {
        return this.make(HttpRequestBuilder::asMultipartForm);
    }

    @Nonnull
    public HttpRequestActionBuilder asFormUrlEncoded() {
        return this.make(HttpRequestBuilder::asFormUrlEncoded);
    }

    @Nonnull
    public HttpRequestActionBuilder formParam(@Nonnull String string, @Nonnull String string2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.toStringExpression((String)string), Expressions.toAnyExpression((String)string2)));
    }

    @Nonnull
    public HttpRequestActionBuilder formParam(@Nonnull Function<Session, String> function, @Nonnull String string) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.javaFunctionToExpression((Function)function), Expressions.toAnyExpression((String)string)));
    }

    @Nonnull
    public HttpRequestActionBuilder formParam(@Nonnull String string, @Nonnull Object object) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.toStringExpression((String)string), Expressions.toStaticValueExpression((Object)object)));
    }

    @Nonnull
    public HttpRequestActionBuilder formParam(@Nonnull Function<Session, String> function, @Nonnull Object object) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.javaFunctionToExpression((Function)function), Expressions.toStaticValueExpression((Object)object)));
    }

    @Nonnull
    public HttpRequestActionBuilder formParam(@Nonnull String string, @Nonnull Function<Session, Object> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression((Function)function)));
    }

    @Nonnull
    public HttpRequestActionBuilder formParam(@Nonnull Function<Session, String> function, @Nonnull Function<Session, Object> function2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.javaFunctionToExpression((Function)function), Expressions.javaFunctionToExpression((Function)function2)));
    }

    @Nonnull
    public HttpRequestActionBuilder multivaluedFormParam(@Nonnull String string, @Nonnull List<Object> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.multivaluedFormParam(Expressions.toStringExpression((String)string), Expressions.toStaticValueExpression((Object)Converters.toScalaSeq((List)list))));
    }

    @Nonnull
    public HttpRequestActionBuilder multivaluedFormParam(@Nonnull String string, @Nonnull String string2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.multivaluedFormParam(Expressions.toStringExpression((String)string), Expressions.toSeqExpression((String)string2)));
    }

    @Nonnull
    public HttpRequestActionBuilder multivaluedFormParam(@Nonnull Function<Session, String> function, @Nonnull List<Object> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.multivaluedFormParam(Expressions.javaFunctionToExpression((Function)function), Expressions.toStaticValueExpression((Object)Converters.toScalaSeq((List)list))));
    }

    @Nonnull
    public HttpRequestActionBuilder multivaluedFormParam(@Nonnull String string, @Nonnull Function<Session, List<Object>> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.multivaluedFormParam(Expressions.toStringExpression((String)string), Expressions.javaListFunctionToExpression((Function)function)));
    }

    @Nonnull
    public HttpRequestActionBuilder multivaluedFormParam(@Nonnull Function<Session, String> function, @Nonnull Function<Session, List<Object>> function2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.multivaluedFormParam(Expressions.javaFunctionToExpression((Function)function), Expressions.javaListFunctionToExpression((Function)function2)));
    }

    @Nonnull
    public HttpRequestActionBuilder formParamSeq(@Nonnull List<Map.Entry<String, Object>> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParamSeq(Converters.toScalaTuple2Seq((List)list)));
    }

    @Nonnull
    public HttpRequestActionBuilder formParamSeq(@Nonnull Function<Session, List<Map.Entry<String, Object>>> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParamSeq(Expressions.javaPairListFunctionToTuple2SeqExpression((Function)function)));
    }

    @Nonnull
    public HttpRequestActionBuilder formParamMap(@Nonnull Map<String, Object> map) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParamMap(Converters.toScalaMap((Map)map)));
    }

    @Nonnull
    public HttpRequestActionBuilder formParamMap(@Nonnull Function<Session, Map<String, Object>> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParamMap(Expressions.javaMapFunctionToExpression((Function)function)));
    }

    @Nonnull
    public HttpRequestActionBuilder form(@Nonnull String string) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParamMap(Expressions.toMapExpression((String)string)));
    }

    @Nonnull
    public HttpRequestActionBuilder form(@Nonnull Function<Session, Map<String, Object>> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.form(Expressions.javaMapFunctionToExpression((Function)function)));
    }

    @Nonnull
    public HttpRequestActionBuilder formUpload(@Nonnull String string, @Nonnull String string2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formUpload(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2), Predef.rawFileBodies()));
    }

    @Nonnull
    public HttpRequestActionBuilder formUpload(@Nonnull Function<Session, String> function, @Nonnull String string) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formUpload(Expressions.javaFunctionToExpression((Function)function), Expressions.toStringExpression((String)string), Predef.rawFileBodies()));
    }

    @Nonnull
    public HttpRequestActionBuilder formUpload(@Nonnull String string, Function<Session, String> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formUpload(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression((Function)function), Predef.rawFileBodies()));
    }

    @Nonnull
    public HttpRequestActionBuilder formUpload(@Nonnull Function<Session, String> function, @Nonnull Function<Session, String> function2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formUpload(Expressions.javaFunctionToExpression((Function)function), Expressions.javaFunctionToExpression((Function)function2), Predef.rawFileBodies()));
    }

    @Nonnull
    public HttpRequestActionBuilder requestTimeout(int n) {
        return this.requestTimeout(Duration.ofSeconds(n));
    }

    @Nonnull
    public HttpRequestActionBuilder requestTimeout(@Nonnull Duration duration) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.requestTimeout(Converters.toScalaDuration((Duration)duration)));
    }

    public static final class TypedCondition {
        private final ScalaHttpRequestActionBuilderConditions.Typed wrapped;

        public TypedCondition(ScalaHttpRequestActionBuilderConditions.Typed typed) {
            this.wrapped = typed;
        }

        @Nonnull
        public HttpRequestActionBuilder then(CheckBuilder ... checkBuilderArray) {
            return this.then(Arrays.asList(checkBuilderArray));
        }

        @Nonnull
        public HttpRequestActionBuilder then(@Nonnull List<CheckBuilder> list) {
            return this.wrapped.then_(list);
        }
    }

    public static final class UntypedCondition {
        private final ScalaHttpRequestActionBuilderConditions.Untyped wrapped;

        public UntypedCondition(ScalaHttpRequestActionBuilderConditions.Untyped untyped) {
            this.wrapped = untyped;
        }

        @Nonnull
        public HttpRequestActionBuilder then(CheckBuilder ... checkBuilderArray) {
            return this.then(Arrays.asList(checkBuilderArray));
        }

        @Nonnull
        public HttpRequestActionBuilder then(@Nonnull List<CheckBuilder> list) {
            return this.wrapped.then_(list);
        }
    }
}

