/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine;

import akka.actor.ActorSystem;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Ssl$;
import io.gatling.commons.util.SystemProps$;
import io.gatling.core.CoreComponents;
import io.gatling.core.config.AhcConfiguration;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.http.client.HttpClient;
import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.impl.DefaultHttpClient;
import io.gatling.http.engine.EventLoopGroups;
import io.gatling.http.engine.HttpClientFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I3Q!\u0001\u0002\u0001\r)\u0011\u0001\u0004R3gCVdG\u000f\u0013;ua\u000ec\u0017.\u001a8u\r\u0006\u001cGo\u001c:z\u0015\t\u0019A!\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u000b\u0019\tA\u0001\u001b;ua*\u0011q\u0001C\u0001\bO\u0006$H.\u001b8h\u0015\u0005I\u0011AA5p'\u0015\u00011\"E\u000b\u0019!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0011!cE\u0007\u0002\u0005%\u0011AC\u0001\u0002\u0012\u0011R$\bo\u00117jK:$h)Y2u_JL\bC\u0001\n\u0017\u0013\t9\"AA\bFm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9t!\tI\u0002%D\u0001\u001b\u0015\tYB$\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\u001e=\u0005AA/\u001f9fg\u00064WMC\u0001 \u0003\r\u0019w.\\\u0005\u0003Ci\u0011Qb\u0015;sS\u000e$Hj\\4hS:<\u0007\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u001d\r|'/Z\"p[B|g.\u001a8ug\u000e\u0001\u0001C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0007\u0003\u0011\u0019wN]3\n\u0005):#AD\"pe\u0016\u001cu.\u001c9p]\u0016tGo\u001d\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00059z\u0003C\u0001\n\u0001\u0011\u0015\u00193\u00061\u0001&\u0011\u001d\t\u0004A1A\u0005\nI\nQbY8oM&<WO]1uS>tW#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005Y:\u0013AB2p]\u001aLw-\u0003\u00029k\t!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:DaA\u000f\u0001!\u0002\u0013\u0019\u0014AD2p]\u001aLw-\u001e:bi&|g\u000e\t\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0003%\t\u0007nY\"p]\u001aLw-F\u0001?!\t!t(\u0003\u0002Ak\t\u0001\u0012\t[2D_:4\u0017nZ;sCRLwN\u001c\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002 \u0002\u0015\u0005D7mQ8oM&<\u0007\u0005\u0003\u0004E\u0001\u0011\u0005a!R\u0001\u0010]\u0016<8\t\\5f]R\u001cuN\u001c4jOR\ta\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002J\t\u000511\r\\5f]RL!a\u0013%\u0003!!#H\u000f]\"mS\u0016tGoQ8oM&<\u0007\"B'\u0001\t\u0003r\u0015!\u00038fo\u000ec\u0017.\u001a8u+\u0005y\u0005CA$Q\u0013\t\t\u0006J\u0001\u0006IiR\u00048\t\\5f]R\u0004")
public class DefaultHttpClientFactory
implements HttpClientFactory,
EventLoopGroups,
StrictLogging {
    private final CoreComponents coreComponents;
    private final GatlingConfiguration configuration;
    private final AhcConfiguration ahcConfig;
    private final Logger logger;

    @Override
    public EventLoopGroup newEventLoopGroup(ActorSystem system, String poolName, boolean useNativeTransport) {
        return EventLoopGroups.newEventLoopGroup$(this, system, poolName, useNativeTransport);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private GatlingConfiguration configuration() {
        return this.configuration;
    }

    private AhcConfiguration ahcConfig() {
        return this.ahcConfig;
    }

    public HttpClientConfig newClientConfig() {
        List list = this.ahcConfig().sslEnabledProtocols();
        String[] stringArray = Nil$.MODULE$.equals(list) ? null : (String[])list.toArray(ClassTag$.MODULE$.apply(String.class));
        HttpClientConfig clientConfig = new HttpClientConfig().setConnectTimeout(this.ahcConfig().connectTimeout().toMillis()).setHandshakeTimeout(this.ahcConfig().handshakeTimeout().toMillis()).setChannelPoolIdleTimeout(this.ahcConfig().pooledConnectionIdleTimeout().toMillis()).setMaxRetry(this.ahcConfig().maxRetry()).setEnableSni(this.ahcConfig().enableSni()).setEnableHostnameVerification(this.ahcConfig().enableHostnameVerification()).setEnabledSslProtocols(stringArray).setFilterInsecureCipherSuites(this.ahcConfig().filterInsecureCipherSuites()).setWebSocketMaxFramePayloadLength(Integer.MAX_VALUE).setDefaultCharset(this.configuration().core().charset()).setUseOpenSsl(this.ahcConfig().useOpenSsl()).setUseNativeTransport(this.ahcConfig().useNativeTransport()).setSslSessionCacheSize(this.ahcConfig().sslSessionCacheSize()).setSslSessionTimeout(this.ahcConfig().sslSessionTimeout().toSeconds()).setDisableSslSessionResumption(this.ahcConfig().disableSslSessionResumption()).setTcpNoDelay(this.ahcConfig().tcpNoDelay()).setSoReuseAddress(this.ahcConfig().soReuseAddress()).setEnableZeroCopy(this.ahcConfig().enableZeroCopy()).setThreadPoolName("gatling-http");
        Object object = this.ahcConfig().sslEnabledCipherSuites().nonEmpty() ? clientConfig.setEnabledSslCipherSuites((String[])this.ahcConfig().sslEnabledCipherSuites().toArray(ClassTag$.MODULE$.apply(String.class))) : BoxedUnit.UNIT;
        KeyManagerFactory keyManagerFactory = (KeyManagerFactory)this.configuration().http().ssl().keyStore().map((Function1 & Serializable & scala.Serializable)config -> Ssl$.MODULE$.newKeyManagerFactory(config.storeType(), config.file(), config.password(), config.algorithm())).orNull(Predef$.MODULE$.$conforms());
        TrustManagerFactory trustManagerFactory = (TrustManagerFactory)this.configuration().http().ssl().trustStore().map((Function1 & Serializable & scala.Serializable)config -> Ssl$.MODULE$.newTrustManagerFactory(config.storeType(), config.file(), config.password(), config.algorithm())).orElse((Function0 & Serializable & scala.Serializable)() -> this.ahcConfig().useInsecureTrustManager() ? new Some((Object)InsecureTrustManagerFactory.INSTANCE) : None$.MODULE$).orNull(Predef$.MODULE$.$conforms());
        return clientConfig.setKeyManagerFactory(keyManagerFactory).setTrustManagerFactory(trustManagerFactory);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpClient newClient() {
        void var1_1;
        DefaultHttpClient client = new DefaultHttpClient(this.newClientConfig());
        this.coreComponents.actorSystem().registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> client.close());
        return var1_1;
    }

    public DefaultHttpClientFactory(CoreComponents coreComponents) {
        this.coreComponents = coreComponents;
        EventLoopGroups.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        this.configuration = coreComponents.configuration();
        this.ahcConfig = this.configuration().http().ahc();
        SystemProps$.MODULE$.setSystemPropertyIfUndefined("io.netty.allocator.type", (Object)this.configuration().http().ahc().allocator());
        SystemProps$.MODULE$.setSystemPropertyIfUndefined("io.netty.maxThreadLocalCharBufferSize", (Object)BoxesRunTime.boxToInteger((int)this.configuration().http().ahc().maxThreadLocalCharBufferSize()));
    }
}

