/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import com.softwaremill.quicklens.package;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.util.NameGen;
import io.gatling.http.HeaderNames$;
import io.gatling.http.client.Request;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.engine.response.Crash;
import io.gatling.http.engine.response.NextExecutor;
import io.gatling.http.engine.response.Proceed;
import io.gatling.http.engine.response.ProcessorResult;
import io.gatling.http.engine.response.Redirect;
import io.gatling.http.engine.response.RedirectProcessor$;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.response.SessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBuilder;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001\u0002\u0007\u000e\u0001aA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!9\u0005A!A!\u0002\u0013A\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"\u0002.\u0001\t\u0003Y\u0006\"\u00024\u0001\t\u00139\u0007\"B7\u0001\t\u0013q\u0007\"B:\u0001\t\u0013!\bBB@\u0001\t\u0013\t\tA\u0001\rEK\u001a\fW\u000f\u001c;SKN\u0004xN\\:f!J|7-Z:t_JT!AD\b\u0002\u0011I,7\u000f]8og\u0016T!\u0001E\t\u0002\r\u0015tw-\u001b8f\u0015\t\u00112#\u0001\u0003iiR\u0004(B\u0001\u000b\u0016\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AF\u0001\u0003S>\u001c\u0001aE\u0003\u00013}\u0019S\u0006\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0005j\u0011!D\u0005\u0003E5\u0011\u0011CU3ta>t7/\u001a)s_\u000e,7o]8s!\t!3&D\u0001&\u0015\t1s%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002)S\u0005AA/\u001f9fg\u00064WMC\u0001+\u0003\r\u0019w.\\\u0005\u0003Y\u0015\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0007C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0011)H/\u001b7\u000b\u0005I\u001a\u0012\u0001B2pe\u0016L!\u0001N\u0018\u0003\u000f9\u000bW.Z$f]\u0006\u0011A\u000f\u001f\t\u0003oej\u0011\u0001\u000f\u0006\u0003k=I!A\u000f\u001d\u0003\r!#H\u000f\u001d+y\u0003A\u0019Xm]:j_:\u0004&o\\2fgN|'\u000f\u0005\u0002!{%\u0011a(\u0004\u0002\u0011'\u0016\u001c8/[8o!J|7-Z:t_J\fab\u001d;biN\u0004&o\\2fgN|'\u000f\u0005\u0002!\u0003&\u0011!)\u0004\u0002\u000f'R\fGo\u001d)s_\u000e,7o]8s\u00031qW\r\u001f;Fq\u0016\u001cW\u000f^8s!\t\u0001S)\u0003\u0002G\u001b\taa*\u001a=u\u000bb,7-\u001e;pe\u0006qA-\u001a4bk2$8\t[1sg\u0016$\bCA%Q\u001b\u0005Q%BA&M\u0003\u001d\u0019\u0007.\u0019:tKRT!!\u0014(\u0002\u00079LwNC\u0001P\u0003\u0011Q\u0017M^1\n\u0005ES%aB\"iCJ\u001cX\r^\u0001\u0007y%t\u0017\u000e\u001e \u0015\rQ+fk\u0016-Z!\t\u0001\u0003\u0001C\u00036\r\u0001\u0007a\u0007C\u0003<\r\u0001\u0007A\bC\u0003@\r\u0001\u0007\u0001\tC\u0003D\r\u0001\u0007A\tC\u0003H\r\u0001\u0007\u0001*\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016$\"\u0001X0\u0011\u0005ii\u0016B\u00010\u001c\u0005\u0011)f.\u001b;\t\u000b\u0001<\u0001\u0019A1\u0002\rI,7/\u001e7u!\t\u0011G-D\u0001d\u0015\tq\u0011#\u0003\u0002fG\nQ\u0001\n\u001e;q%\u0016\u001cX\u000f\u001c;\u0002\u001b!\fg\u000e\u001a7f\r\u0006LG.\u001e:f)\ta\u0006\u000eC\u0003j\u0011\u0001\u0007!.A\u0004gC&dWO]3\u0011\u0005\t\\\u0017B\u00017d\u0005-AE\u000f\u001e9GC&dWO]3\u0002\u001d!\fg\u000e\u001a7f%\u0016\u001c\bo\u001c8tKR\u0011Al\u001c\u0005\u0006\u001d%\u0001\r\u0001\u001d\t\u0003EFL!A]2\u0003\u0011I+7\u000f]8og\u0016\f\u0011\u0004[1oI2,'+Z:q_:\u001cX\r\u0016:b]N4wN]7feR\u0011Q/ \t\u0004mn\u0004X\"A<\u000b\u0005aL\u0018A\u0003<bY&$\u0017\r^5p]*\u0011!pE\u0001\bG>lWn\u001c8t\u0013\taxO\u0001\u0006WC2LG-\u0019;j_:DQA \u0006A\u0002A\f1B]1x%\u0016\u001c\bo\u001c8tK\u0006y\u0001.\u00198eY\u0016\u0014Vm\u001d9p]N,\u0007\u0007\u0006\u0003\u0002\u0004\u0005%\u0001c\u0001\u0011\u0002\u0006%\u0019\u0011qA\u0007\u0003\u001fA\u0013xnY3tg>\u0014(+Z:vYRDQA`\u0006A\u0002A\u0004")
public class DefaultResponseProcessor
implements ResponseProcessor,
StrictLogging,
NameGen {
    private final HttpTx tx;
    private final SessionProcessor sessionProcessor;
    private final StatsProcessor statsProcessor;
    private final NextExecutor nextExecutor;
    private final Charset defaultCharset;
    private final Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void onComplete(HttpResult result) {
        HttpResult httpResult = result;
        if (httpResult instanceof Response) {
            Response response = (Response)httpResult;
            this.handleResponse(response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (httpResult instanceof HttpFailure) {
            HttpFailure httpFailure = (HttpFailure)httpResult;
            this.handleFailure(httpFailure);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)httpResult);
        }
    }

    private void handleFailure(HttpFailure failure) {
        block8: {
            Session sessionWithUpdatedStats = this.sessionProcessor.updateSessionCrashed(this.tx.currentSession(), failure.startTimestamp(), failure.endTimestamp());
            try {
                try {
                    this.statsProcessor.reportStats(this.tx.fullRequestName(), this.tx.request().clientRequest(), sessionWithUpdatedStats, (Status)KO$.MODULE$, failure, (Option<String>)new Some((Object)failure.errorMessage()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable t = (Throwable)option.get();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(new StringBuilder(84).append("ResponseProcessor crashed while handling failure ").append(failure).append(" on session=").append(this.tx.currentSession()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break block8;
                    }
                    throw throwable;
                }
            }
            finally {
                this.nextExecutor.executeNextOnCrash(sessionWithUpdatedStats, failure.endTimestamp());
            }
        }
    }

    private void handleResponse(Response response) {
        Request clientRequest = this.tx.request().clientRequest();
        ProcessorResult processorResult = this.handleResponse0(response);
        if (processorResult instanceof Proceed) {
            Proceed proceed = (Proceed)processorResult;
            Session newSession = proceed.newSession();
            Option<String> errorMessage = proceed.error();
            KO$ status = errorMessage.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, newSession, (Status)status, response, errorMessage);
            this.nextExecutor.executeNext(newSession, (Status)status, response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (processorResult instanceof Redirect) {
            Redirect redirect = (Redirect)processorResult;
            HttpTx redirectTx = redirect.redirectTx();
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, redirectTx.currentSession(), (Status)OK$.MODULE$, response, (Option<String>)None$.MODULE$);
            this.nextExecutor.executeRedirect(redirectTx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (processorResult instanceof Crash) {
            Crash crash = (Crash)processorResult;
            String errorMessage = crash.error();
            Session newSession = this.sessionProcessor.updateSessionCrashed(this.tx.currentSession(), response.startTimestamp(), response.endTimestamp());
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, newSession, (Status)KO$.MODULE$, response, (Option<String>)new Some((Object)errorMessage));
            this.nextExecutor.executeNextOnCrash(newSession, response.endTimestamp());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)processorResult);
        }
    }

    private Validation<Response> handleResponseTransformer(Response rawResponse) {
        Validation validation;
        Option<Function2<Session, Response, Validation<Response>>> option = this.tx.request().requestConfig().responseTransformer();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function2 transformer = (Function2)some.value();
            validation = package$.MODULE$.safely((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(30).append("Response transformer crashed: ").append((String)x$1).toString(), (Function0 & Serializable & scala.Serializable)() -> (Validation)transformer.apply((Object)$this.tx.currentSession(), (Object)rawResponse));
        } else {
            validation = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)rawResponse));
        }
        return validation;
    }

    private ProcessorResult handleResponse0(Response rawResponse) {
        Crash crash;
        try {
            Crash crash2;
            Validation<Response> validation = this.handleResponseTransformer(rawResponse);
            if (validation instanceof Failure) {
                Failure failure = (Failure)validation;
                String errorMessage = failure.message();
                crash2 = new Crash(errorMessage);
            } else if (validation instanceof Success) {
                ProcessorResult processorResult;
                Success success = (Success)validation;
                Response response = (Response)success.value();
                if (HttpHelper$.MODULE$.isRedirect(response.status()) && this.tx.request().requestConfig().followRedirect()) {
                    if (this.tx.redirectCount() >= this.tx.request().requestConfig().maxRedirects()) {
                        processorResult = new Crash(new StringBuilder(27).append("Too many redirects, max is ").append(this.tx.request().requestConfig().maxRedirects()).toString());
                    } else {
                        Crash crash3;
                        Option<String> option = response.header(HeaderNames$.MODULE$.Location());
                        if (option instanceof Some) {
                            ProcessorResult processorResult2;
                            Some some = (Some)option;
                            String location = (String)some.value();
                            Uri redirectUri = HttpHelper$.MODULE$.resolveFromUri(this.tx.request().clientRequest().getUri(), location);
                            Session newSession = this.sessionProcessor.updatedRedirectSession(this.tx.currentSession(), response, redirectUri);
                            Validation<Request> validation2 = RedirectProcessor$.MODULE$.redirectRequest(this.tx.request().clientRequest(), newSession, response.status(), this.tx.request().requestConfig().httpProtocol(), redirectUri, this.defaultCharset);
                            if (validation2 instanceof Success) {
                                Success success2 = (Success)validation2;
                                Request redirectRequest = (Request)success2.value();
                                HttpTx fresh$macro$3 = this.tx;
                                HttpTx fresh$macro$6 = (HttpTx)new package.PathModify((Object)fresh$macro$3, (Function2 & Serializable & scala.Serializable)(fresh$macro$1, fresh$macro$2) -> fresh$macro$1.copy((Session)fresh$macro$2.apply((Object)fresh$macro$1.session()), fresh$macro$1.copy$default$2(), fresh$macro$1.copy$default$3(), fresh$macro$1.copy$default$4(), fresh$macro$1.copy$default$5(), fresh$macro$1.copy$default$6())).setTo((Object)newSession);
                                HttpTx fresh$macro$9 = (HttpTx)new package.PathModify((Object)fresh$macro$6, (Function2 & Serializable & scala.Serializable)(fresh$macro$4, fresh$macro$5) -> {
                                    Request x$1 = (Request)fresh$macro$5.apply((Object)fresh$macro$4.request().clientRequest());
                                    String x$2 = fresh$macro$4.request().copy$default$1();
                                    HttpRequestConfig x$3 = fresh$macro$4.request().copy$default$3();
                                    HttpRequest x$4 = fresh$macro$4.request().copy(x$2, x$1, x$3);
                                    Session x$5 = fresh$macro$4.copy$default$1();
                                    Function1<Request, ResponseBuilder> x$6 = fresh$macro$4.copy$default$3();
                                    Action x$7 = fresh$macro$4.copy$default$4();
                                    Option<ResourceTx> x$8 = fresh$macro$4.copy$default$5();
                                    int x$9 = fresh$macro$4.copy$default$6();
                                    return fresh$macro$4.copy(x$5, x$4, x$6, x$7, x$8, x$9);
                                }).setTo((Object)redirectRequest);
                                processorResult2 = new Redirect((HttpTx)new package.PathModify((Object)fresh$macro$9, (Function2 & Serializable & scala.Serializable)(fresh$macro$7, fresh$macro$8) -> {
                                    int x$10 = fresh$macro$8.apply$mcII$sp(fresh$macro$7.redirectCount());
                                    Session x$11 = fresh$macro$7.copy$default$1();
                                    HttpRequest x$12 = fresh$macro$7.copy$default$2();
                                    Function1<Request, ResponseBuilder> x$13 = fresh$macro$7.copy$default$3();
                                    Action x$14 = fresh$macro$7.copy$default$4();
                                    Option<ResourceTx> x$15 = fresh$macro$7.copy$default$5();
                                    return fresh$macro$7.copy(x$11, x$12, x$13, x$14, x$15, x$10);
                                }).using((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$5 -> x$5 + 1));
                            } else if (validation2 instanceof Failure) {
                                Failure failure = (Failure)validation2;
                                String message = failure.message();
                                processorResult2 = new Crash(message);
                            } else {
                                throw new MatchError(validation2);
                            }
                            crash3 = processorResult2;
                        } else {
                            crash3 = new Crash("Redirect status, yet no Location header");
                        }
                        processorResult = crash3;
                    }
                } else {
                    Tuple2<Session, Option<String>> tuple2 = this.sessionProcessor.updatedSession(this.tx.currentSession(), response);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Session newSession = (Session)tuple2._1();
                    Option errorMessage = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)newSession, (Object)errorMessage);
                    Tuple2 tuple23 = tuple22;
                    Session newSession2 = (Session)tuple23._1();
                    Option errorMessage2 = (Option)tuple23._2();
                    processorResult = new Proceed(newSession2, (Option<String>)errorMessage2);
                }
                crash2 = processorResult;
            } else {
                throw new MatchError(validation);
            }
            crash = crash2;
        }
        catch (Throwable throwable) {
            Throwable t;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                t = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(85).append("ResponseProcessor crashed while handling response ").append(rawResponse.status()).append(" on session=").append(this.tx.currentSession()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            Crash crash4 = new Crash(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
            crash = crash4;
        }
        return crash;
    }

    public DefaultResponseProcessor(HttpTx tx, SessionProcessor sessionProcessor, StatsProcessor statsProcessor, NextExecutor nextExecutor, Charset defaultCharset) {
        this.tx = tx;
        this.sessionProcessor = sessionProcessor;
        this.statsProcessor = statsProcessor;
        this.nextExecutor = nextExecutor;
        this.defaultCharset = defaultCharset;
        StrictLogging.$init$((StrictLogging)this);
        NameGen.$init$((NameGen)this);
    }
}

