/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.netty.util.NetUtil;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

public final class InetAddresses$
implements LazyLogging {
    public static final InetAddresses$ MODULE$ = new InetAddresses$();
    private static final List<InetAddress> AllLocalAddresses;
    private static final List<InetAddress> AllIpV4LocalAddresses;
    private static final List<InetAddress> AllIpV6LocalAddresses;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        AllLocalAddresses = CollectionConverters$.MODULE$.EnumerationHasAsScala(NetworkInterface.getNetworkInterfaces()).asScala().toList().flatMap((Function1 & Serializable)networkInterface -> CollectionConverters$.MODULE$.EnumerationHasAsScala(networkInterface.getInetAddresses()).asScala().withFilter((Function1 & Serializable)inetAddress -> BoxesRunTime.boxToBoolean((boolean)InetAddresses$.$anonfun$AllLocalAddresses$2(inetAddress))));
        AllIpV4LocalAddresses = MODULE$.AllLocalAddresses().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InetAddresses$.$anonfun$AllIpV4LocalAddresses$1(x$1)));
        AllIpV6LocalAddresses = NetUtil.isIpV4StackPreferred() ? Nil$.MODULE$ : MODULE$.AllLocalAddresses().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)InetAddresses$.$anonfun$AllIpV6LocalAddresses$1(x$2)));
    }

    private Logger logger$lzycompute() {
        InetAddresses$ inetAddresses$ = this;
        synchronized (inetAddresses$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private boolean isBindable(InetAddress localAddress) {
        boolean bl;
        block8: {
            InetSocketAddress socketAddress = new InetSocketAddress(localAddress, 0);
            try (Socket socket = new Socket();){
                try {
                    socket.bind(socketAddress);
                    bl = true;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable e = (Throwable)option.get();
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug("Address " + localAddress + " is not bindable", e);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        bl = false;
                        break block8;
                    }
                    throw throwable;
                }
            }
        }
        return bl;
    }

    private List<InetAddress> AllLocalAddresses() {
        return AllLocalAddresses;
    }

    public List<InetAddress> AllIpV4LocalAddresses() {
        return AllIpV4LocalAddresses;
    }

    public List<InetAddress> AllIpV6LocalAddresses() {
        return AllIpV6LocalAddresses;
    }

    public java.util.List<InetAddress> shuffleInetAddresses(java.util.List<InetAddress> originalAddresses, boolean isIpV4StackPreferred, boolean isIpV6AddressesPreferred) {
        if (originalAddresses.size() == 1) {
            return originalAddresses;
        }
        ObjectRef ipV4 = ObjectRef.create(null);
        ObjectRef ipV6 = ObjectRef.create(null);
        CollectionConverters$.MODULE$.ListHasAsScala(originalAddresses).asScala().foreach((Function1 & Serializable)inetAddress -> {
            if (inetAddress instanceof Inet4Address) {
                if ((java.util.List)ipV4$1.elem == null) {
                    ipV4$1.elem = new ArrayList(originalAddresses.size());
                }
                return BoxesRunTime.boxToBoolean((boolean)((java.util.List)ipV4$1.elem).add(inetAddress));
            }
            if (!isIpV4StackPreferred) {
                if ((java.util.List)ipV6$1.elem == null) {
                    ipV6$1.elem = new ArrayList(originalAddresses.size());
                }
                return BoxesRunTime.boxToBoolean((boolean)((java.util.List)ipV6$1.elem).add(inetAddress));
            }
            return BoxedUnit.UNIT;
        });
        java.util.List higher = isIpV6AddressesPreferred ? (java.util.List)ipV6.elem : (java.util.List)ipV4.elem;
        java.util.List lower = isIpV6AddressesPreferred ? (java.util.List)ipV4.elem : (java.util.List)ipV6.elem;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (higher != null) {
            Object object;
            this.shuffle(higher, random);
            if (lower != null) {
                this.shuffle(lower, random);
                object = BoxesRunTime.boxToBoolean((boolean)higher.addAll(lower));
            } else {
                object = BoxedUnit.UNIT;
            }
            return higher;
        }
        this.shuffle(lower, random);
        return lower;
    }

    private void shuffle(java.util.List<InetAddress> list, ThreadLocalRandom random) {
        if (list.size() > 1) {
            Collections.shuffle(list, random);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$AllLocalAddresses$2(InetAddress inetAddress) {
        return !inetAddress.isLoopbackAddress() && !inetAddress.isLinkLocalAddress() && !inetAddress.isMulticastAddress() && MODULE$.isBindable(inetAddress);
    }

    public static final /* synthetic */ boolean $anonfun$AllIpV4LocalAddresses$1(InetAddress x$1) {
        return x$1 instanceof Inet4Address;
    }

    public static final /* synthetic */ boolean $anonfun$AllIpV6LocalAddresses$1(InetAddress x$2) {
        return x$2 instanceof Inet6Address;
    }

    private InetAddresses$() {
    }
}

