/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.ElBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.util.Resource;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Http2PriorKnowledge;
import io.gatling.http.client.Param;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.gatling.http.client.body.stringchunks.StringChunksRequestBodyBuilder;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.HttpParam;
import io.gatling.http.request.builder.HttpRequestExpressionBuilder$;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.package$;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\teu!B\u0011#\u0011\u0003ic!B\u0018#\u0011\u0003\u0001\u0004\"B\u001c\u0002\t\u0003A\u0004bB\u001d\u0002\u0005\u0004%IA\u000f\u0005\u0007=\u0006\u0001\u000b\u0011B\u001e\t\u000b\u0019\fA\u0011B4\u0007\u000b=\u0012\u0003!!\u0007\t\u0015\u0005\u0005bA!A!\u0002\u0013\t\u0019\u0003\u0003\u0006\u0002*\u0019\u0011\t\u0011)A\u0005\u0003WA!\"!\r\u0007\u0005\u0003\u0005\u000b\u0011BA\u001a\u0011)\tyD\u0002B\u0001B\u0003%\u0011\u0011\t\u0005\u000b\u0003\u001b2!\u0011!Q\u0001\n\u0005=\u0003BB\u001c\u0007\t\u0003\tY\u0006C\u0004\u0002j\u0019!\t&a\u001b\t\u000f\u0005mf\u0001\"\u0003\u0002>\"9\u0011q\u001e\u0004\u0005\n\u0005E\bb\u0002B\u0005\r\u0011%!1\u0002\u0005\n\u000571!\u0019!C\u0005\u0005;A\u0001Ba\u000b\u0007A\u0003%!q\u0004\u0005\n\u0005[1!\u0019!C\u0005\u0005_A\u0001Ba\u000e\u0007A\u0003%!\u0011\u0007\u0005\n\u0005s1!\u0019!C\u0005\u0005_A\u0001Ba\u000f\u0007A\u0003%!\u0011\u0007\u0005\b\u0005{1A\u0011\u0002B \u0011%\u0011yE\u0002b\u0001\n\u0013\u0011y\u0003\u0003\u0005\u0003R\u0019\u0001\u000b\u0011\u0002B\u0019\u0011\u001d\u0011\u0019F\u0002C\u0005\u0005+B\u0011B!\u0019\u0007\u0005\u0004%IAa\u0019\t\u0011\t-d\u0001)A\u0005\u0005KBqA!\u001c\u0007\t#\u0012y\u0007C\u0004\u0003t\u0019!\tF!\u001e\t\u000f\t\u0015e\u0001\"\u0003\u0003\b\"9!1\u0013\u0004\u0005B\tU\u0015\u0001\b%uiB\u0014V-];fgR,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM\u001d\u0006\u0003G\u0011\nqAY;jY\u0012,'O\u0003\u0002&M\u00059!/Z9vKN$(BA\u0014)\u0003\u0011AG\u000f\u001e9\u000b\u0005%R\u0013aB4bi2Lgn\u001a\u0006\u0002W\u0005\u0011\u0011n\\\u0002\u0001!\tq\u0013!D\u0001#\u0005qAE\u000f\u001e9SKF,Xm\u001d;FqB\u0014Xm]:j_:\u0014U/\u001b7eKJ\u001c\"!A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ&A\rc_\u0012L\b+\u0019:ugR{W*\u001e7uSB\f'\u000f^:[KJ|W#A\u001e\u0011\u0007q\n5)D\u0001>\u0015\tqt(\u0001\u0006wC2LG-\u0019;j_:T!\u0001\u0011\u0015\u0002\u000f\r|W.\\8og&\u0011!)\u0010\u0002\u000b-\u0006d\u0017\u000eZ1uS>t\u0007c\u0001#M\u001f:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u00112\na\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0005-\u001b\u0014a\u00029bG.\fw-Z\u0005\u0003\u001b:\u0013A\u0001T5ti*\u00111j\r\u0019\u0003!r\u00032!\u0015-[\u001b\u0005\u0011&BA*U\u0003%iW\u000f\u001c;ja\u0006\u0014HO\u0003\u0002V-\u0006!!m\u001c3z\u0015\t9f%\u0001\u0004dY&,g\u000e^\u0005\u00033J\u0013A\u0001U1siB\u00111\f\u0018\u0007\u0001\t%iF!!A\u0001\u0002\u000b\u0005qLA\u0002`IE\n!DY8esB\u000b'\u000f^:U_6+H\u000e^5qCJ$8OW3s_\u0002\n\"\u0001Y2\u0011\u0005I\n\u0017B\u000124\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\r3\n\u0005\u0015\u001c$aA!os\u0006)\"m\u001c3z!\u0006\u0014Ho\u001d+p\u001bVdG/\u001b9beR\u001cHc\u00015pmB\u0019A(Q5\u0011\u0007\u0011c%\u000e\r\u0002l[B\u0019\u0011\u000b\u00177\u0011\u0005mkG!\u00038\u0006\u0003\u0003\u0005\tQ!\u0001`\u0005\ryFE\r\u0005\u0006a\u0016\u0001\r!]\u0001\nE>$\u0017\u0010U1siN\u00042\u0001\u0012's!\t\u0019H/D\u0001%\u0013\t)HE\u0001\u0005C_\u0012L\b+\u0019:u\u0011\u00159X\u00011\u0001y\u0003\u001d\u0019Xm]:j_:\u0004\"!_?\u000e\u0003iT!a^>\u000b\u0005qD\u0013\u0001B2pe\u0016L!A >\u0003\u000fM+7o]5p]\":Q!!\u0001\u0002\u0012\u0005M\u0001\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0005Y\u0006twM\u0003\u0002\u0002\f\u0005!!.\u0019<b\u0013\u0011\ty!!\u0002\u0003!M+\b\u000f\u001d:fgN<\u0016M\u001d8j]\u001e\u001c\u0018!\u0002<bYV,GFAA\u000bC\t\t9\"\u0001\u0011pe\u001ets/\u0019:ue\u0016lwN^3s]]\f'\u000f^:/\u0019&\u001cH/\u00119qK:$7c\u0001\u0004\u0002\u001cA\u0019a&!\b\n\u0007\u0005}!E\u0001\rSKF,Xm\u001d;FqB\u0014Xm]:j_:\u0014U/\u001b7eKJ\f\u0001cY8n[>t\u0017\t\u001e;sS\n,H/Z:\u0011\u00079\n)#C\u0002\u0002(\t\u0012\u0001cQ8n[>t\u0017\t\u001e;sS\n,H/Z:\u0002\u001d!$H\u000f]!uiJL'-\u001e;fgB\u0019a&!\f\n\u0007\u0005=\"E\u0001\bIiR\u0004\u0018\t\u001e;sS\n,H/Z:\u0002\u0015!$H\u000f]\"bG\",7\u000f\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tIDJ\u0001\u0006G\u0006\u001c\u0007.Z\u0005\u0005\u0003{\t9D\u0001\u0006IiR\u00048)Y2iKN\fA\u0002\u001b;uaB\u0013x\u000e^8d_2\u0004B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f2\u0013\u0001\u00039s_R|7m\u001c7\n\t\u0005-\u0013Q\t\u0002\r\u0011R$\b\u000f\u0015:pi>\u001cw\u000e\\\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016|\u0003\u0019\u0019wN\u001c4jO&!\u0011\u0011LA*\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]Ra\u0011QLA0\u0003C\n\u0019'!\u001a\u0002hA\u0011aF\u0002\u0005\b\u0003Ca\u0001\u0019AA\u0012\u0011\u001d\tI\u0003\u0004a\u0001\u0003WAq!!\r\r\u0001\u0004\t\u0019\u0004C\u0004\u0002@1\u0001\r!!\u0011\t\u000f\u00055C\u00021\u0001\u0002P\u000592m\u001c8gS\u001e,(/\u001a%fC\u0012,'o\u001d\"vS2$\u0018J\u001c\u000b\u0007\u0003[\n)+!+\u0011\u0011\u0005=\u0014qOA?\u0003\u0007sA!!\u001d\u0002tA\u0011aiM\u0005\u0004\u0003k\u001a\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002z\u0005m$aA'ba*\u0019\u0011QO\u001a\u0011\t\u0005\r\u0011qP\u0005\u0005\u0003\u0003\u000b)A\u0001\u0007DQ\u0006\u00148+Z9vK:\u001cW\r\u0005\u0004\u0002\u0006\u0006e\u0015q\u0014\b\u0005\u0003\u000f\u000b9J\u0004\u0003\u0002\n\u0006Ue\u0002BAF\u0003'sA!!$\u0002\u0012:\u0019a)a$\n\u0003-J!!\u000b\u0016\n\u0005qD\u0013BA<|\u0013\tY%0\u0003\u0003\u0002\u001c\u0006u%AC#yaJ,7o]5p]*\u00111J\u001f\t\u0005\u0003_\n\t+\u0003\u0003\u0002$\u0006m$AB*ue&tw\rC\u0004\u0002(6\u0001\r!!\u001c\u0002\u0015I\fw\u000fS3bI\u0016\u00148\u000fC\u0004\u0002,6\u0001\r!!,\u0002\u001d!,\u0017\rZ3sg\n+\u0018\u000e\u001c;J]B!\u0011qVA[\u001d\rq\u0013\u0011W\u0005\u0004\u0003g\u0013\u0013\u0001E\"p[6|g.\u0011;ue&\u0014W\u000f^3t\u0013\u0011\t9,!/\u0003\u001d!+\u0017\rZ3sg\n+\u0018\u000e\u001c;J]*\u0019\u00111\u0017\u0012\u0002I5,'oZ3G_Jl\u0007+\u0019:b[N\fe\u000e\u001a$pe6Le\u000e^8QCJ\fWN\u0013'jgR$\u0002\"a0\u0002T\u0006}\u0017Q\u001e\t\u0005y\u0005\u000b\t\r\u0005\u0004\u0002D\u0006%\u00171Z\u0007\u0003\u0003\u000bTA!a2\u0002\n\u0005!Q\u000f^5m\u0013\ri\u0015Q\u0019\t\u0005\u0003\u001b\fy-D\u0001W\u0013\r\t\tN\u0016\u0002\u0006!\u0006\u0014\u0018-\u001c\u0005\b\u0003+t\u0001\u0019AAl\u0003\u0019\u0001\u0018M]1ngB!A\tTAm!\rq\u00131\\\u0005\u0004\u0003;\u0014#!\u0003%uiB\u0004\u0016M]1n\u0011\u001d\t\tO\u0004a\u0001\u0003G\f\u0011\"\\1zE\u00164uN]7\u0011\u000bI\n)/!;\n\u0007\u0005\u001d8G\u0001\u0004PaRLwN\u001c\t\u0007\u0003\u000b\u000bI*a;\u0011\u000f\u0005=\u0014qOAPG\")qO\u0004a\u0001q\u0006Q2m\u001c8gS\u001e,(/Z'vYRL\u0007/\u0019:u\r>\u0014X\u000eR1uCR1\u00111_A\u007f\u0003\u007f\u0004D!!>\u0002zB!A(QA|!\rY\u0016\u0011 \u0003\u000b\u0003w|\u0011\u0011!A\u0001\u0006\u0003y&aA0%g!)qo\u0004a\u0001q\"9!\u0011A\bA\u0002\t\r\u0011A\u0004:fcV,7\u000f\u001e\"vS2$WM\u001d\t\u0005\u0003\u001b\u0014)!C\u0002\u0003\bY\u0013aBU3rk\u0016\u001cHOQ;jY\u0012,'/A\fd_:4\u0017nZ;sK\u001a{'/\\+sY\u0016s7m\u001c3fIR1!Q\u0002B\f\u00053\u0001DAa\u0004\u0003\u0014A!A(\u0011B\t!\rY&1\u0003\u0003\u000b\u0005+\u0001\u0012\u0011!A\u0001\u0006\u0003y&aA0%i!)q\u000f\u0005a\u0001q\"9!\u0011\u0001\tA\u0002\t\r\u0011!I7bs\n,'+Z9vKN$(i\u001c3z\u0005VLG\u000eZ3s\u000bb\u0004(/Z:tS>tWC\u0001B\u0010!\u0015\u0011\u0014Q\u001dB\u0011!\u0019\t))!'\u0003$A!!Q\u0005B\u0014\u001b\u0005!\u0016b\u0001B\u0015)\n\u0011\"+Z9vKN$(i\u001c3z\u0005VLG\u000eZ3s\u0003\tj\u0017-\u001f2f%\u0016\fX/Z:u\u0005>$\u0017PQ;jY\u0012,'/\u0012=qe\u0016\u001c8/[8oA\u0005A\u0001.Y:QCJ$8/\u0006\u0002\u00032A\u0019!Ga\r\n\u0007\tU2GA\u0004C_>dW-\u00198\u0002\u0013!\f7\u000fU1siN\u0004\u0013a\u00025bg\u001a{'/\\\u0001\tQ\u0006\u001chi\u001c:nA\u0005i1m\u001c8gS\u001e,(/\u001a\"pIf$bA!\u0011\u0003L\t5\u0003\u0007\u0002B\"\u0005\u000f\u0002B\u0001P!\u0003FA\u00191La\u0012\u0005\u0015\t%s#!A\u0001\u0002\u000b\u0005qLA\u0002`IUBQa^\fA\u0002aDqA!\u0001\u0018\u0001\u0004\u0011\u0019!A\u0006f]\u0006\u0014G.\u001a%uiB\u0014\u0014\u0001D3oC\ndW\r\u0013;uaJ\u0002\u0013aF2p]\u001aLw-\u001e:f!JLwN]&o_^dW\rZ4f)\u0019\u00119F!\u0018\u0003`A\u0019!G!\u0017\n\u0007\tm3G\u0001\u0003V]&$\b\"B<\u001b\u0001\u0004A\bb\u0002B\u00015\u0001\u0007!1A\u0001\u000fe\u0016\fX/Z:u)&lWm\\;u+\t\u0011)\u0007E\u00023\u0005OJ1A!\u001b4\u0005\u0011auN\\4\u0002\u001fI,\u0017/^3tiRKW.Z8vi\u0002\nqcY8oM&<WO]3SKF,Xm\u001d;US6,w.\u001e;\u0015\t\t]#\u0011\u000f\u0005\b\u0005\u0003i\u0002\u0019\u0001B\u0002\u0003e\u0019wN\u001c4jOV\u0014X\r\u0015:pi>\u001cw\u000e\\*qK\u000eLg-[2\u0015\r\t]$\u0011\u0011BBa\u0011\u0011IH! \u0011\tq\n%1\u0010\t\u00047\nuDA\u0003B@=\u0005\u0005\t\u0011!B\u0001?\n\u0019q\f\n\u001c\t\u000b]t\u0002\u0019\u0001=\t\u000f\t\u0005a\u00041\u0001\u0003\u0004\u000592m\u001c8gS\u001e,(/Z\"bG\"Lgn\u001a%fC\u0012,'o\u001d\u000b\u0007\u0005/\u0012IIa#\t\u000b]|\u0002\u0019\u0001=\t\r\u0015z\u0002\u0019\u0001BG!\u0011\tiMa$\n\u0007\tEeKA\u0004SKF,Xm\u001d;\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0005\t]\u0005CBAC\u00033\u0013i\t")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final HttpAttributes httpAttributes;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final GatlingConfiguration configuration;
    private final Option<Function1<Session, Validation<RequestBodyBuilder>>> maybeRequestBodyBuilderExpression;
    private final boolean hasParts;
    private final boolean hasForm;
    private final boolean enableHttp2;
    private final long requestTimeout;

    @Override
    public Map<CharSequence, Function1<Session, Validation<String>>> configureHeadersBuiltIn(Map<CharSequence, Function1<Session, Validation<String>>> rawHeaders, CommonAttributes.HeadersBuiltIn headersBuiltIn) {
        return headersBuiltIn.patch(rawHeaders, this.httpAttributes.body().nonEmpty() || this.httpAttributes.bodyParts().nonEmpty());
    }

    private Validation<java.util.List<Param>> mergeFormParamsAndFormIntoParamJList(List<HttpParam> params, Option<Function1<Session, Validation<Map<String, Object>>>> maybeForm, Session session) {
        Validation<java.util.List<Param>> formParams = package$.MODULE$.resolveParamJList(params, session);
        Option<Function1<Session, Validation<Map<String, Object>>>> option = maybeForm;
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 form = (Function1)some.value();
            return formParams.flatMap((Function1 & Serializable)resolvedFormParams -> ((Validation)form.apply((Object)session)).map((Function1 & Serializable)resolvedForm -> {
                Map formParamsByName = CollectionConverters$.MODULE$.ListHasAsScala(resolvedFormParams).asScala().groupBy((Function1 & Serializable)x$1 -> x$1.getName());
                Map formFieldsByName = (Map)resolvedForm.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        Object value2 = tuple2._2();
                        Object object = value2;
                        if (object instanceof scala.collection.immutable.Seq) {
                            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)object;
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), seq.map((Function1 & Serializable)value -> new Param(key, value.toString())));
                        }
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new .colon.colon((Object)new Param(key, object.toString()), (List)Nil$.MODULE$));
                    }
                    throw new MatchError((Object)tuple2);
                });
                java.util.List javaParams = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((MapOps)formFieldsByName.$plus$plus((IterableOnce)formParamsByName)).values().flatten(Predef$.MODULE$.$conforms())).toSeq()).asJava();
                return javaParams;
            }));
        }
        return formParams;
    }

    private Validation<?> configureMultipartFormData(Session session, RequestBuilder requestBuilder) {
        return this.mergeFormParamsAndFormIntoParamJList(this.httpAttributes.formParams(), this.httpAttributes.form(), session).flatMap((Function1 & Serializable)params -> {
            Buffer stringParts = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params).asScala().map((Function1 & Serializable)param -> new StringPart(param.getName(), param.getValue(), this.charset(), null, null, null, null, null));
            return HttpRequestExpressionBuilder$.MODULE$.io$gatling$http$request$builder$HttpRequestExpressionBuilder$$bodyPartsToMultiparts($this.httpAttributes.bodyParts(), session).map((Function1 & Serializable)parts -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new MultipartFormDataRequestBodyBuilder(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)stringParts.$plus$plus((IterableOnce)parts)).asJava())));
        });
    }

    private Validation<?> configureFormUrlEncoded(Session session, RequestBuilder requestBuilder) {
        return this.mergeFormParamsAndFormIntoParamJList(this.httpAttributes.formParams(), this.httpAttributes.form(), session).map((Function1 & Serializable)params -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new FormUrlEncodedRequestBodyBuilder(params)));
    }

    private Option<Function1<Session, Validation<RequestBodyBuilder>>> maybeRequestBodyBuilderExpression() {
        return this.maybeRequestBodyBuilderExpression;
    }

    private boolean hasParts() {
        return this.hasParts;
    }

    private boolean hasForm() {
        return this.hasForm;
    }

    private Validation<?> configureBody(Session session, RequestBuilder requestBuilder) {
        Option<Function1<Session, Validation<RequestBodyBuilder>>> option = this.maybeRequestBodyBuilderExpression();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 requestBodyBuilderExpression = (Function1)some.value();
            return ((Validation)requestBodyBuilderExpression.apply((Object)session)).map((Function1 & Serializable)x$1 -> requestBuilder.setBodyBuilder(x$1));
        }
        if (this.hasParts() || this.hasForm() && HttpHelper$.MODULE$.isMultipartFormData(requestBuilder.getContentType())) {
            return this.configureMultipartFormData(session, requestBuilder);
        }
        if (this.hasForm()) {
            return this.configureFormUrlEncoded(session, requestBuilder);
        }
        return Validation$.MODULE$.unit();
    }

    private boolean enableHttp2() {
        return this.enableHttp2;
    }

    private void configurePriorKnowledge(Session session, RequestBuilder requestBuilder) {
        if (this.enableHttp2()) {
            Option<Http2PriorKnowledge> http2PriorKnowledge = Http2PriorKnowledgeSupport$.MODULE$.getHttp2PriorKnowledge(session, Remote$.MODULE$.apply(requestBuilder.getUri()));
            requestBuilder.setHttp2Enabled(true).setHttp2PriorKnowledge((Http2PriorKnowledge)http2PriorKnowledge.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
    }

    private long requestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public void configureRequestTimeout(RequestBuilder requestBuilder) {
        requestBuilder.setRequestTimeout(this.requestTimeout());
    }

    @Override
    public Validation<?> configureProtocolSpecific(Session session, RequestBuilder requestBuilder) {
        return this.configureBody(session, requestBuilder).map((Function1 & Serializable)x$11 -> {
            Object object = x$11;
            this.configurePriorKnowledge(session, requestBuilder);
            return BoxedUnit.UNIT;
        });
    }

    private void configureCachingHeaders(Session session, Request request) {
        this.httpCaches.contentCacheEntry(session, request).foreach((Function1 & Serializable)x0$1 -> {
            HttpRequestExpressionBuilder.$anonfun$configureCachingHeaders$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Function1<Session, Validation<Request>> build() {
        Function1<Session, Validation<Request>> exp = super.build();
        if (this.httpProtocol.requestPart().cache()) {
            return (Function1 & Serializable)session -> ((Validation)exp.apply(session)).map((Function1 & Serializable)request -> {
                this.configureCachingHeaders((Session)session, (Request)request);
                return request;
            });
        }
        return exp;
    }

    public static final /* synthetic */ void $anonfun$configureCachingHeaders$1(Request request$1, ContentCacheEntry x0$1) {
        ContentCacheEntry contentCacheEntry = x0$1;
        if (contentCacheEntry != null) {
            Option<String> etag = contentCacheEntry.etag();
            Option<String> lastModified = contentCacheEntry.lastModified();
            etag.foreach((Function1 & Serializable)x$12 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_NONE_MATCH, x$12));
            lastModified.foreach((Function1 & Serializable)x$13 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, x$13));
            return;
        }
        throw new MatchError((Object)contentCacheEntry);
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpCaches httpCaches, HttpProtocol httpProtocol, GatlingConfiguration configuration) {
        this.httpAttributes = httpAttributes;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.configuration = configuration;
        super(commonAttributes, httpCaches, httpProtocol, configuration);
        Predef$.MODULE$.require(httpAttributes.body().isEmpty() || httpAttributes.bodyParts().isEmpty(), (Function0 & Serializable)() -> "Can't have both a body and body parts!");
        this.maybeRequestBodyBuilderExpression = httpAttributes.body().map((Function1 & Serializable)x0$1 -> {
            Body body = x0$1;
            if (body instanceof StringBody) {
                StringBody stringBody = (StringBody)body;
                Function1 string = stringBody.string();
                return (Function1 & Serializable)x$3 -> ((Validation)string.apply(x$3)).map((Function1 & Serializable)x$4 -> new StringRequestBodyBuilder(x$4));
            }
            if (body instanceof RawFileBody) {
                RawFileBody rawFileBody = (RawFileBody)body;
                Function1 resourceWithCachedBytes = rawFileBody.resourceAndCachedBytes();
                return (Function1 & Serializable)x$5 -> ((Validation)resourceWithCachedBytes.apply(x$5)).map((Function1 & Serializable)x0$2 -> {
                    ResourceAndCachedBytes resourceAndCachedBytes = x0$2;
                    if (resourceAndCachedBytes != null) {
                        Resource resource = resourceAndCachedBytes.resource();
                        Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                        Option option = cachedBytes;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            byte[] bytes = (byte[])some.value();
                            return new ByteArrayRequestBodyBuilder(bytes, resource.name());
                        }
                        return new FileRequestBodyBuilder(resource.file());
                    }
                    throw new MatchError((Object)resourceAndCachedBytes);
                });
            }
            if (body instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)body;
                Function1 bytes = byteArrayBody.bytes();
                return (Function1 & Serializable)x$6 -> ((Validation)bytes.apply(x$6)).map((Function1 & Serializable)x$7 -> new ByteArrayRequestBodyBuilder(x$7, null));
            }
            if (body instanceof ElBody) {
                ElBody elBody = (ElBody)body;
                return (Function1 & Serializable)x$8 -> ((Validation)elBody.asStringWithCachedBytes().apply(x$8)).map((Function1 & Serializable)chunks -> new StringChunksRequestBodyBuilder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)chunks).asJava()));
            }
            if (body instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)body;
                Function1 is = inputStreamBody.is();
                return (Function1 & Serializable)x$9 -> ((Validation)is.apply(x$9)).map((Function1 & Serializable)x$10 -> new InputStreamRequestBodyBuilder(x$10));
            }
            throw new MatchError((Object)body);
        });
        this.hasParts = httpAttributes.bodyParts().nonEmpty();
        this.hasForm = httpAttributes.formParams().nonEmpty() || httpAttributes.form().nonEmpty();
        this.enableHttp2 = httpProtocol.enginePart().enableHttp2();
        this.requestTimeout = ((FiniteDuration)httpAttributes.requestTimeout().getOrElse((Function0 & Serializable)() -> $this.configuration.http().requestTimeout())).toMillis();
    }
}

