/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cookie;

import io.gatling.http.client.uri.Uri;
import io.gatling.http.cookie.CookieJar;
import io.gatling.http.cookie.CookieKey;
import io.gatling.http.cookie.StoredCookie;
import io.netty.handler.codec.http.cookie.Cookie;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CookieJar$
implements Serializable {
    public static final CookieJar$ MODULE$ = new CookieJar$();
    private static final CookieJar Empty = new CookieJar((Map<CookieKey, StoredCookie>)Predef$.MODULE$.Map().empty());
    private static final Pattern Ipv4LoopbackRegex = Pattern.compile("127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    public CookieJar Empty() {
        return Empty;
    }

    public String io$gatling$http$cookie$CookieJar$$requestDomain(Uri requestUri) {
        return requestUri.getHost().toLowerCase(Locale.ROOT);
    }

    public Tuple2<String, Object> io$gatling$http$cookie$CookieJar$$cookieDomain(Option<String> cookieDomain, String requestDomain) {
        Option<String> option = cookieDomain;
        if (option instanceof Some) {
            Some some = (Some)option;
            String dom = (String)some.value();
            return new Tuple2((Object)(dom.charAt(0) == '.' ? dom.substring(1) : dom).toLowerCase(Locale.ROOT), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return new Tuple2((Object)requestDomain, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public String io$gatling$http$cookie$CookieJar$$cookiePath(Option<String> rawCookiePath, String requestPath) {
        Some some;
        String path;
        Option<String> option = rawCookiePath;
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(path = (String)(some = (Some)option).value())) && path.charAt(0) == '/') {
            return path;
        }
        return Uri.getLastDirectoryPath((String)requestPath);
    }

    public boolean io$gatling$http$cookie$CookieJar$$hasExpired(Cookie c) {
        long maxAge = c.maxAge();
        return maxAge != Long.MIN_VALUE && maxAge <= 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean io$gatling$http$cookie$CookieJar$$domainsMatch(String cookieDomain, String requestDomain, boolean hostOnly) {
        if (hostOnly) {
            String string = requestDomain;
            String string2 = cookieDomain;
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
        }
        String string = requestDomain;
        String string3 = cookieDomain;
        if (string == null) {
            if (string3 == null) return true;
        } else if (string.equals(string3)) return true;
        if (!requestDomain.endsWith("." + cookieDomain)) return false;
        return true;
    }

    public boolean io$gatling$http$cookie$CookieJar$$pathsMatch(String cookiePath, String requestPath) {
        String string = cookiePath;
        String string2 = requestPath;
        return !(string == null ? string2 != null : !string.equals(string2)) || requestPath.startsWith(cookiePath) && (StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(cookiePath)) == '/' || requestPath.charAt(cookiePath.length()) == '/');
    }

    public CookieJar apply(Uri uri, List<Cookie> cookies, long nowMillis) {
        return this.Empty().add(uri, cookies, nowMillis);
    }

    private Pattern Ipv4LoopbackRegex() {
        return Ipv4LoopbackRegex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean io$gatling$http$cookie$CookieJar$$isLocalhost(String host) {
        if (host == null) return false;
        String string = host;
        String string2 = "localhost";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = host;
        String string4 = "localhost.";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (host.endsWith(".localhost")) return true;
        if (host.endsWith(".localhost.")) return true;
        String string5 = host;
        String string6 = "[::1]";
        if (string5 == null) {
            if (string6 == null) return true;
        } else if (string5.equals(string6)) return true;
        String string7 = host;
        String string8 = "[0000:0000:0000:0000:0000:0000:0000:0001]";
        if (string7 == null) {
            if (string8 == null) return true;
        } else if (string7.equals(string8)) return true;
        if (!this.Ipv4LoopbackRegex().matcher(host).matches()) return false;
        return true;
    }

    public CookieJar apply(Map<CookieKey, StoredCookie> store) {
        return new CookieJar(store);
    }

    public Option<Map<CookieKey, StoredCookie>> unapply(CookieJar x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some(x$0.store());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CookieJar$.class);
    }

    private CookieJar$() {
    }
}

