/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.CoreComponents;
import io.gatling.core.session.Session;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.cache.InferredPageResources;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.fetch.ConcurrentResource;
import io.gatling.http.fetch.CssParser$;
import io.gatling.http.fetch.DefaultResourceAggregator;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.fetch.ResourceAggregator;
import io.gatling.http.fetch.ResourceFetcher$;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestDef;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005x!B\t\u0013\u0011\u0013Yb!B\u000f\u0013\u0011\u0013q\u0002\"B\u0018\u0002\t\u0003\u0001\u0004\"B\u0019\u0002\t\u0013\u0011\u0004\"B)\u0002\t\u0013\u0011f!B\u000f\u0013\u0005Qy\bBCA\u0001\u000b\t\u0005\t\u0015!\u0003\u0002\u0004!A1-\u0002B\u0001B\u0003%A\r\u0003\u0005l\u000b\t\u0005\t\u0015!\u0003m\u0011)\tY!\u0002B\u0001B\u0003%\u0011Q\u0002\u0005\u0007_\u0015!\t!!\b\t\u000f\u0005%R\u0001\"\u0003\u0002,!9\u0011QJ\u0003\u0005\u0002\u0005=\u0003bBAL\u000b\u0011%\u0011\u0011\u0014\u0005\b\u0003O+A\u0011BAU\u0011\u001d\ty,\u0002C\u0001\u0003\u0003Dq!!2\u0006\t\u0003\t9-A\bSKN|WO]2f\r\u0016$8\r[3s\u0015\t\u0019B#A\u0003gKR\u001c\u0007N\u0003\u0002\u0016-\u0005!\u0001\u000e\u001e;q\u0015\t9\u0002$A\u0004hCRd\u0017N\\4\u000b\u0003e\t!![8\u0004\u0001A\u0011A$A\u0007\u0002%\ty!+Z:pkJ\u001cWMR3uG\",'oE\u0002\u0002?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tQ3&\u0001\u0005usB,7/\u00194f\u0015\u0005a\u0013aA2p[&\u0011af\n\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Y\u0012\u0001F1qa2L(+Z:pkJ\u001cWMR5mi\u0016\u00148\u000fF\u00024\u0005\u0012\u00032\u0001\u000e\u001f@\u001d\t)$H\u0004\u00027s5\tqG\u0003\u000295\u00051AH]8pizJ\u0011AI\u0005\u0003w\u0005\nq\u0001]1dW\u0006<W-\u0003\u0002>}\t!A*[:u\u0015\tY\u0014\u0005\u0005\u0002\u001d\u0001&\u0011\u0011I\u0005\u0002\u0013\u0007>t7-\u001e:sK:$(+Z:pkJ\u001cW\rC\u0003D\u0007\u0001\u00071'A\u0005sKN|WO]2fg\")Qi\u0001a\u0001\r\u00069a-\u001b7uKJ\u001c\bc\u0001\u0011H\u0013&\u0011\u0001*\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005){U\"A&\u000b\u00051k\u0015A\u00024jYR,'O\u0003\u0002O-\u0005!1m\u001c:f\u0013\t\u00016JA\u0004GS2$XM]:\u0002'I,7o\\;sG\u0016\u001cHk\u001c*fcV,7\u000f^:\u0015\u000fMS6L\u00196soB\u0019A\u0007\u0010+\u0011\u0005UCV\"\u0001,\u000b\u0005]#\u0012a\u0002:fcV,7\u000f^\u0005\u00033Z\u00131\u0002\u0013;uaJ+\u0017/^3ti\")1\t\u0002a\u0001g!)A\f\u0002a\u0001;\u000691/Z:tS>t\u0007C\u00010a\u001b\u0005y&B\u0001/N\u0013\t\twLA\u0004TKN\u001c\u0018n\u001c8\t\u000b\r$\u0001\u0019\u00013\u0002\u0015!$H\u000f]\"bG\",7\u000f\u0005\u0002fQ6\taM\u0003\u0002h)\u0005)1-Y2iK&\u0011\u0011N\u001a\u0002\u000b\u0011R$\boQ1dQ\u0016\u001c\b\"B6\u0005\u0001\u0004a\u0017\u0001\u00045uiB\u0004&o\u001c;pG>d\u0007CA7q\u001b\u0005q'BA8\u0015\u0003!\u0001(o\u001c;pG>d\u0017BA9o\u00051AE\u000f\u001e9Qe>$xnY8m\u0011\u0015\u0019H\u00011\u0001u\u0003%!\bN]8ui2,G\r\u0005\u0002!k&\u0011a/\t\u0002\b\u0005>|G.Z1o\u0011\u0015AH\u00011\u0001z\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011!0`\u0007\u0002w*\u0011A0T\u0001\u0007G>tg-[4\n\u0005y\\(\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|gnE\u0002\u0006?\u0015\nabY8sK\u000e{W\u000e]8oK:$8\u000f\u0005\u0003\u0002\u0006\u0005\u001dQ\"A'\n\u0007\u0005%QJ\u0001\bD_J,7i\\7q_:,g\u000e^:\u0002\u001d!$H\u000f\u001d+y\u000bb,7-\u001e;peB!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011A\u0001;y\u0015\r\t9\u0002F\u0001\u0007K:<\u0017N\\3\n\t\u0005m\u0011\u0011\u0003\u0002\u000f\u0011R$\b\u000f\u0016=Fq\u0016\u001cW\u000f^8s))\ty\"!\t\u0002$\u0005\u0015\u0012q\u0005\t\u00039\u0015Aq!!\u0001\u000b\u0001\u0004\t\u0019\u0001C\u0003d\u0015\u0001\u0007A\rC\u0003l\u0015\u0001\u0007A\u000eC\u0004\u0002\f)\u0001\r!!\u0004\u0002%%tg-\u001a:QC\u001e,'+Z:pkJ\u001cWm\u001d\u000b\n'\u00065\u00121HA%\u0003\u0017BaaV\u0006A\u0002\u0005=\u0002\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005UB#\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003s\t\u0019DA\u0004SKF,Xm\u001d;\t\u000f\u0005u2\u00021\u0001\u0002@\u0005A!/Z:q_:\u001cX\r\u0005\u0003\u0002B\u0005\u0015SBAA\"\u0015\r\ti\u0004F\u0005\u0005\u0003\u000f\n\u0019E\u0001\u0005SKN\u0004xN\\:f\u0011\u0015a6\u00021\u0001^\u0011\u0015\u00198\u00021\u0001u\u0003)\u00197o\u001d$fi\u000eDW\r\u001a\u000b\u000e'\u0006E\u0013qLA=\u0003\u001f\u000b\u0019*!&\t\u000f\u0005MC\u00021\u0001\u0002V\u0005\u0019QO]5\u0011\t\u0005]\u00131L\u0007\u0003\u00033RA!a\u0015\u00024%!\u0011QLA-\u0005\r)&/\u001b\u0005\b\u0003Cb\u0001\u0019AA2\u00039\u0011Xm\u001d9p]N,7\u000b^1ukN\u0004B!!\u001a\u0002v5\u0011\u0011q\r\u0006\u0004+\u0005%$\u0002BA6\u0003[\nQaY8eK\u000eTA!a\u001c\u0002r\u00059\u0001.\u00198eY\u0016\u0014(bAA:1\u0005)a.\u001a;us&!\u0011qOA4\u0005IAE\u000f\u001e9SKN\u0004xN\\:f'R\fG/^:\t\u000f\u0005mD\u00021\u0001\u0002~\u00059R.Y=cK2\u000b7\u000f^'pI&4\u0017.\u001a3Pe\u0016#\u0018m\u001a\t\u0005A\u001d\u000by\b\u0005\u0003\u0002\u0002\u0006%e\u0002BAB\u0003\u000b\u0003\"AN\u0011\n\u0007\u0005\u001d\u0015%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\u000biI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000f\u000b\u0003bBAI\u0019\u0001\u0007\u0011qP\u0001\bG>tG/\u001a8u\u0011\u0015aF\u00021\u0001^\u0011\u0015\u0019H\u00021\u0001u\u0003Y\u0011W/\u001b7e\u000bb\u0004H.[2jiJ+7o\\;sG\u0016\u001cH#B*\u0002\u001c\u0006\u0015\u0006BB\"\u000e\u0001\u0004\ti\n\u0005\u00035y\u0005}\u0005cA+\u0002\"&\u0019\u00111\u0015,\u0003\u001d!#H\u000f\u001d*fcV,7\u000f\u001e#fM\")A,\u0004a\u0001;\u0006\u0011\"/Z:pkJ\u001cW-Q4he\u0016<\u0017\r^8s)\u0019\tY+a-\u0002<B!\u0001eRAW!\ra\u0012qV\u0005\u0004\u0003c\u0013\"A\u0005*fg>,(oY3BO\u001e\u0014XmZ1u_JDq!a\u0005\u000f\u0001\u0004\t)\f\u0005\u0003\u0002\u0010\u0005]\u0016\u0002BA]\u0003#\u0011a\u0001\u0013;uaRC\bBBA_\u001d\u0001\u00071+A\tj]\u001a,'O]3e%\u0016\u001cx.\u001e:dKN\f!E\\3x%\u0016\u001cx.\u001e:dK\u0006;wM]3hCR|'OR8s\u0007\u0006\u001c\u0007.\u001a3QC\u001e,G\u0003BAV\u0003\u0007Dq!a\u0005\u0010\u0001\u0004\t),A\u0012oK^\u0014Vm]8ve\u000e,\u0017iZ4sK\u001e\fGo\u001c:G_J4U\r^2iK\u0012\u0004\u0016mZ3\u0015\u0011\u0005-\u0016\u0011ZAf\u0003\u001bDq!!\u0010\u0011\u0001\u0004\ty\u0004C\u0004\u0002\u0014A\u0001\r!!.\t\u000f\u0005=\u0007\u00031\u0001\u0002R\u000611\u000f^1ukN\u0004B!a5\u0002^6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.A\u0003ti\u0006$8OC\u0002\u0002\\Z\tqaY8n[>t7/\u0003\u0003\u0002`\u0006U'AB*uCR,8\u000f")
public final class ResourceFetcher
implements StrictLogging {
    private final CoreComponents coreComponents;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final HttpTxExecutor httpTxExecutor;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<HttpRequest> inferPageResources(Request request, Response response, Session session, boolean throttled) {
        Uri htmlDocumentUri = request.getUri();
        HttpResponseStatus httpResponseStatus = response.status();
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
        if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
            Option<String> option = response.lastModifiedOrEtag(this.httpProtocol);
            if (option instanceof Some) {
                Some some = (Some)option;
                String lastModifiedOrEtag = (String)some.value();
                return this.httpCaches.computeInferredResourcesIfAbsent(this.httpProtocol, htmlDocumentUri, lastModifiedOrEtag, (Function0<List<HttpRequest>>)(Function0 & Serializable)() -> this.inferredResourcesRequests$1(htmlDocumentUri, response, session, throttled));
            }
            return this.inferredResourcesRequests$1(htmlDocumentUri, response, session, throttled);
        }
        HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.NOT_MODIFIED;
        HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
        if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
            InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(this.httpProtocol, htmlDocumentUri);
            if (inferredPageResources == null) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Got a 304 for {} but could not find a cache entry, probably because capacity is exceeded?!", (Object)htmlDocumentUri);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return Nil$.MODULE$;
            }
            return inferredPageResources.requests();
        }
        return Nil$.MODULE$;
    }

    public List<HttpRequest> cssFetched(Uri uri, HttpResponseStatus responseStatus, Option<String> maybeLastModifiedOrEtag, String content, Session session, boolean throttled) {
        HttpResponseStatus httpResponseStatus = responseStatus;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
        if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
            Option<String> option = maybeLastModifiedOrEtag;
            if (option instanceof Some) {
                Some some = (Some)option;
                String lastModifiedOrEtag = (String)some.value();
                return this.httpCaches.computeInferredResourcesIfAbsent(this.httpProtocol, uri, lastModifiedOrEtag, (Function0<List<HttpRequest>>)(Function0 & Serializable)() -> {
                    $this.httpCaches.removeCssResources(uri);
                    return this.parseCssResources$1(content, uri, session, throttled);
                });
            }
            return this.parseCssResources$1(content, uri, session, throttled);
        }
        HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.NOT_MODIFIED;
        HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
        if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
            InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(this.httpProtocol, uri);
            if (inferredPageResources == null) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Got a 304 for {} but could not find cache entry. Cache max capacity reached?", (Object)uri);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return Nil$.MODULE$;
            }
            return inferredPageResources.requests();
        }
        return Nil$.MODULE$;
    }

    private List<HttpRequest> buildExplicitResources(List<HttpRequestDef> resources, Session session) {
        return resources.flatMap((Function1 & Serializable)resource -> {
            Validation<HttpRequest> validation = resource.build(session);
            if (validation instanceof Success) {
                HttpRequest httpRequest;
                Success success = (Success)validation;
                HttpRequest httpRequest2 = httpRequest = (HttpRequest)success.value();
                return Nil$.MODULE$.$colon$colon((Object)httpRequest2);
            }
            if (validation instanceof Failure) {
                Failure failure = (Failure)validation;
                String error = failure.message();
                Validation validation2 = (Validation)resource.requestName().apply((Object)session);
                if (validation2 instanceof Success) {
                    BoxedUnit boxedUnit;
                    Success success = (Success)validation2;
                    String requestName = (String)success.value();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Failed to build explicitResource {}: {}", new Object[]{requestName, error});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    $this.coreComponents.statsEngine().logRequestCrash(session.scenario(), session.groups(), requestName, error);
                } else if (validation2 instanceof Failure) {
                    Failure failure2 = (Failure)validation2;
                    String requestNameError = failure2.message();
                    String errorMessage = "Failed to build explicitResource name: " + requestNameError;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(errorMessage);
                    }
                } else {
                    throw new MatchError((Object)validation2);
                }
                return Nil$.MODULE$;
            }
            throw new MatchError(validation);
        });
    }

    private Option<ResourceAggregator> resourceAggregator(HttpTx tx, List<HttpRequest> inferredResources) {
        List<HttpRequest> list;
        List<HttpRequest> explicitResources = tx.request().requestConfig().explicitResources().nonEmpty() ? this.buildExplicitResources(tx.request().requestConfig().explicitResources(), tx.session()) : Nil$.MODULE$;
        List list2 = explicitResources.$colon$colon$colon(list = inferredResources);
        if (Nil$.MODULE$.equals(list2)) {
            return None$.MODULE$;
        }
        return new Some((Object)new DefaultResourceAggregator(tx, (List<HttpRequest>)list2, this.httpCaches, this, this.httpTxExecutor, this.coreComponents.clock()));
    }

    public Option<ResourceAggregator> newResourceAggregatorForCachedPage(HttpTx tx) {
        InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(tx.request().requestConfig().httpProtocol(), tx.request().clientRequest().getUri());
        List<HttpRequest> inferredResources = inferredPageResources == null ? Nil$.MODULE$ : inferredPageResources.requests();
        return this.resourceAggregator(tx, inferredResources);
    }

    public Option<ResourceAggregator> newResourceAggregatorForFetchedPage(Response response, HttpTx tx, Status status) {
        Status status2 = status;
        KO$ kO$ = KO$.MODULE$;
        if (!(status2 != null ? !status2.equals(kO$) : kO$ != null)) {
            return None$.MODULE$;
        }
        List<HttpRequest> inferredResources = this.httpProtocol.responsePart().inferHtmlResources() && HttpHelper$.MODULE$.isHtml(response.headers()) ? this.inferPageResources(tx.request().clientRequest(), response, tx.session(), tx.request().requestConfig().throttled()) : Nil$.MODULE$;
        return this.resourceAggregator(tx, inferredResources);
    }

    private final List inferredResourcesRequests$1(Uri htmlDocumentUri$1, Response response$1, Session session$2, boolean throttled$2) {
        List<ConcurrentResource> inferred = new HtmlParser().getEmbeddedResources(htmlDocumentUri$1, response$1.body().chars());
        List<ConcurrentResource> filtered = ResourceFetcher$.MODULE$.io$gatling$http$fetch$ResourceFetcher$$applyResourceFilters(inferred, this.httpProtocol.responsePart().htmlResourcesInferringFilters());
        return ResourceFetcher$.MODULE$.io$gatling$http$fetch$ResourceFetcher$$resourcesToRequests(filtered, session$2, this.httpCaches, this.httpProtocol, throttled$2, this.coreComponents.configuration());
    }

    private final List parseCssResources$1(String content$1, Uri uri$1, Session session$3, boolean throttled$3) {
        Function1 & Serializable computer = (Function1 & Serializable)x$2 -> CssParser$.MODULE$.extractResources((Uri)x$2, content$1);
        List<ConcurrentResource> inferred = this.httpCaches.computeCssResourcesIfAbsent(uri$1, (Function1<Uri, List<ConcurrentResource>>)computer);
        List<ConcurrentResource> filtered = ResourceFetcher$.MODULE$.io$gatling$http$fetch$ResourceFetcher$$applyResourceFilters(inferred, this.httpProtocol.responsePart().htmlResourcesInferringFilters());
        return ResourceFetcher$.MODULE$.io$gatling$http$fetch$ResourceFetcher$$resourcesToRequests(filtered, session$3, this.httpCaches, this.httpProtocol, throttled$3, this.coreComponents.configuration());
    }

    public ResourceFetcher(CoreComponents coreComponents, HttpCaches httpCaches, HttpProtocol httpProtocol, HttpTxExecutor httpTxExecutor) {
        this.coreComponents = coreComponents;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.httpTxExecutor = httpTxExecutor;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

