/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.sse.SseListener;
import io.gatling.http.action.sse.fsm.ServerSentEvent;
import io.gatling.http.action.sse.fsm.SseFsm;
import io.gatling.http.action.sse.fsm.SseStream$;
import io.gatling.http.action.sse.fsm.SseStreamState;
import io.gatling.http.action.sse.fsm.SseStreamState$Closed$;
import io.gatling.http.client.Request;
import io.gatling.http.client.impl.PrematureCloseException;
import io.gatling.http.engine.HttpEngine;
import io.gatling.http.util.SslContexts;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005}w!\u0002\u0014(\u0011\u0003!d!\u0002\u001c(\u0011\u00039\u0004\"\u0002 \u0002\t\u0003y\u0004b\u0002!\u0002\u0005\u0004%I!\u0011\u0005\u0007\u0015\u0006\u0001\u000b\u0011\u0002\"\t\u000f-\u000b!\u0019!C\u0005\u0019\"1\u0001+\u0001Q\u0001\n53AAN\u0014\u0003#\"AAl\u0002B\u0001B\u0003%Q\f\u0003\u0005f\u000f\t\u0005\t\u0015!\u0003g\u0011!awA!A!\u0002\u0013i\u0007\u0002\u0003=\b\u0005\u0003\u0005\u000b\u0011B=\t\u0015\u0005\rqA!A!\u0002\u0013\t)\u0001\u0003\u0006\u0002\f\u001d\u0011\t\u0011)A\u0005\u0003\u001bA!\"!\u0007\b\u0005\u0003\u0005\u000b\u0011BA\u000e\u0011)\t9c\u0002B\u0001B\u0003%\u0011\u0011\u0006\u0005\u0007}\u001d!\t!a\u000e\t\u0013\u0005-sA1A\u0005\n\u00055\u0003\u0002CA1\u000f\u0001\u0006I!a\u0014\t\u0017!:\u0001\u0019!a\u0001\n\u00039\u00131\r\u0005\r\u0003W:\u0001\u0019!a\u0001\n\u00039\u0013Q\u000e\u0005\f\u0003s:\u0001\u0019!A!B\u0013\t)\u0007C\u0006\u0002|\u001d\u0001\r\u00111A\u0005\n\u0005u\u0004bCAC\u000f\u0001\u0007\t\u0019!C\u0005\u0003\u000fC1\"a#\b\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0000!I\u0011QR\u0004A\u0002\u0013%\u0011q\u0012\u0005\n\u0003';\u0001\u0019!C\u0005\u0003+C\u0001\"!'\bA\u0003&\u0011\u0011\u0013\u0005\t\u00037;\u0001\u0019!C\u0005\u0019\"I\u0011QT\u0004A\u0002\u0013%\u0011q\u0014\u0005\b\u0003G;\u0001\u0015)\u0003N\u0011\u001d\t)k\u0002C\u0001\u0003OCq!!+\b\t\u0003\t9\u000bC\u0004\u0002,\u001e!\t!a*\t\u000f\u00055v\u0001\"\u0001\u0002(\"9\u0011qV\u0004\u0005\u0002\u0005E\u0006bBA_\u000f\u0011\u0005\u0011q\u0018\u0005\b\u0003\u0017<A\u0011BAg\u0003%\u00196/Z*ue\u0016\fWN\u0003\u0002)S\u0005\u0019am]7\u000b\u0005)Z\u0013aA:tK*\u0011A&L\u0001\u0007C\u000e$\u0018n\u001c8\u000b\u00059z\u0013\u0001\u00025uiBT!\u0001M\u0019\u0002\u000f\u001d\fG\u000f\\5oO*\t!'\u0001\u0002j_\u000e\u0001\u0001CA\u001b\u0002\u001b\u00059#!C*tKN#(/Z1n'\t\t\u0001\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\nQ\u0003T1ti\u00163XM\u001c;JI\"+\u0017\rZ3s\u001d\u0006lW-F\u0001C!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0003vi&d'BA$2\u0003\u0015qW\r\u001e;z\u0013\tIEIA\u0006Bg\u000eL\u0017n\u0015;sS:<\u0017A\u0006'bgR,e/\u001a8u\u0013\u0012DU-\u00193fe:\u000bW.\u001a\u0011\u00023\u0011+g-Y;miJ+GO]=EK2\f\u00170\u00138NS2d\u0017n]\u000b\u0002\u001bB\u0011\u0011HT\u0005\u0003\u001fj\u00121!\u00138u\u0003i!UMZ1vYR\u0014V\r\u001e:z\t\u0016d\u0017-_%o\u001b&dG.[:!'\r9\u0001H\u0015\t\u0003'jk\u0011\u0001\u0016\u0006\u0003+Z\u000bAb]2bY\u0006dwnZ4j]\u001eT!a\u0016-\u0002\u0011QL\b/Z:bM\u0016T\u0011!W\u0001\u0004G>l\u0017BA.U\u00055\u0019FO]5di2{wmZ5oO\u0006yqN]5hS:\fGnU3tg&|g\u000e\u0005\u0002_G6\tqL\u0003\u0002aC\u000691/Z:tS>t'B\u000120\u0003\u0011\u0019wN]3\n\u0005\u0011|&aB*fgNLwN\\\u0001\u000fG>tg.Z2u%\u0016\fX/Z:u!\t9'.D\u0001i\u0015\tIW&\u0001\u0004dY&,g\u000e^\u0005\u0003W\"\u0014qAU3rk\u0016\u001cH/A\td_:tWm\u0019;BGRLwN\u001c(b[\u0016\u0004\"A\\;\u000f\u0005=\u001c\bC\u00019;\u001b\u0005\t(B\u0001:4\u0003\u0019a$o\\8u}%\u0011AOO\u0001\u0007!J,G-\u001a4\n\u0005Y<(AB*ue&twM\u0003\u0002uu\u0005yQo]3s'Nd7i\u001c8uKb$8\u000fE\u0002:urL!a\u001f\u001e\u0003\r=\u0003H/[8o!\tix0D\u0001\u007f\u0015\t)U&C\u0002\u0002\u0002y\u00141bU:m\u0007>tG/\u001a=ug\u0006\u00012\u000f[1sK\u000e{gN\\3di&|gn\u001d\t\u0004s\u0005\u001d\u0011bAA\u0005u\t9!i\\8mK\u0006t\u0017A\u00035uiB,enZ5oKB!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u00145\na!\u001a8hS:,\u0017\u0002BA\f\u0003#\u0011!\u0002\u0013;ua\u0016sw-\u001b8f\u0003-\u0019H/\u0019;t\u000b:<\u0017N\\3\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\tb\u0003\u0015\u0019H/\u0019;t\u0013\u0011\t)#a\b\u0003\u0017M#\u0018\r^:F]\u001eLg.Z\u0001\u0006G2|7m\u001b\t\u0005\u0003W\t\u0019$\u0004\u0002\u0002.)\u0019Q)a\f\u000b\u0007\u0005Er&A\u0004d_6lwN\\:\n\t\u0005U\u0012Q\u0006\u0002\u0006\u00072|7m\u001b\u000b\u0013\u0003s\tY$!\u0010\u0002@\u0005\u0005\u00131IA#\u0003\u000f\nI\u0005\u0005\u00026\u000f!)A\f\u0005a\u0001;\")Q\r\u0005a\u0001M\")A\u000e\u0005a\u0001[\")\u0001\u0010\u0005a\u0001s\"9\u00111\u0001\tA\u0002\u0005\u0015\u0001bBA\u0006!\u0001\u0007\u0011Q\u0002\u0005\b\u00033\u0001\u0002\u0019AA\u000e\u0011\u001d\t9\u0003\u0005a\u0001\u0003S\taa\u001a:pkB\u001cXCAA(!\u0015\t\t&a\u0017n\u001d\u0011\t\u0019&a\u0016\u000f\u0007A\f)&C\u0001<\u0013\r\tIFO\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti&a\u0018\u0003\t1K7\u000f\u001e\u0006\u0004\u00033R\u0014aB4s_V\u00048\u000fI\u000b\u0003\u0003K\u00022!NA4\u0013\r\tIg\n\u0002\u0007'N,gi]7\u0002\u000f\u0019\u001cXn\u0018\u0013fcR!\u0011qNA;!\rI\u0014\u0011O\u0005\u0004\u0003gR$\u0001B+oSRD\u0011\"a\u001e\u0015\u0003\u0003\u0005\r!!\u001a\u0002\u0007a$\u0013'\u0001\u0003gg6\u0004\u0013!B:uCR,WCAA@!\r)\u0014\u0011Q\u0005\u0004\u0003\u0007;#AD*tKN#(/Z1n'R\fG/Z\u0001\ngR\fG/Z0%KF$B!a\u001c\u0002\n\"I\u0011qO\f\u0002\u0002\u0003\u0007\u0011qP\u0001\u0007gR\fG/\u001a\u0011\u0002\u00171\f7\u000f^#wK:$\u0018\nZ\u000b\u0003\u0003#\u00032!\u000f>n\u0003=a\u0017m\u001d;Fm\u0016tG/\u00133`I\u0015\fH\u0003BA8\u0003/C\u0011\"a\u001e\u001b\u0003\u0003\u0005\r!!%\u0002\u00191\f7\u000f^#wK:$\u0018\n\u001a\u0011\u0002%I,GO]=EK2\f\u00170\u00138NS2d\u0017n]\u0001\u0017e\u0016$(/\u001f#fY\u0006L\u0018J\\'jY2L7o\u0018\u0013fcR!\u0011qNAQ\u0011!\t9(HA\u0001\u0002\u0004i\u0015a\u0005:fiJLH)\u001a7bs&sW*\u001b7mSN\u0004\u0013aB2p]:,7\r\u001e\u000b\u0003\u0003_\n\u0011bY8o]\u0016\u001cG/\u001a3\u0002\u0017\u0015tGm\u00144TiJ,\u0017-\\\u0001\u0010G2|7/\u001a$s_6\u001cE.[3oi\u0006)1M]1tQR!\u0011qNAZ\u0011\u001d\t)l\ta\u0001\u0003o\u000b\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\u0005E\u0013\u0011X\u0005\u0005\u0003w\u000byFA\u0005UQJ|w/\u00192mK\u0006iQM^3oiJ+7-Z5wK\u0012$B!a\u001c\u0002B\"9\u00111\u0019\u0013A\u0002\u0005\u0015\u0017!B3wK:$\bcA\u001b\u0002H&\u0019\u0011\u0011Z\u0014\u0003\u001fM+'O^3s'\u0016tG/\u0012<f]R\fA\"\u001b7mK\u001e\fGn\u0015;bi\u0016$b!a\u001c\u0002P\u0006m\u0007bBAiK\u0001\u0007\u00111[\u0001\tY&\u001cH/\u001a8feB!\u0011Q[Al\u001b\u0005I\u0013bAAmS\tY1k]3MSN$XM\\3s\u0011\u0019\ti.\na\u0001[\u00069Q.Z:tC\u001e,\u0007")
public final class SseStream
implements StrictLogging {
    private final Session originalSession;
    private final Request connectRequest;
    private final Option<SslContexts> userSslContexts;
    private final boolean shareConnections;
    private final HttpEngine httpEngine;
    private final List<String> groups;
    private SseFsm fsm;
    private SseStreamState state;
    private Option<String> lastEventId;
    private int retryDelayInMillis;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<String> groups() {
        return this.groups;
    }

    public SseFsm fsm() {
        return this.fsm;
    }

    public void fsm_$eq(SseFsm x$1) {
        this.fsm = x$1;
    }

    private SseStreamState state() {
        return this.state;
    }

    private void state_$eq(SseStreamState x$1) {
        this.state = x$1;
    }

    private Option<String> lastEventId() {
        return this.lastEventId;
    }

    private void lastEventId_$eq(Option<String> x$1) {
        this.lastEventId = x$1;
    }

    private int retryDelayInMillis() {
        return this.retryDelayInMillis;
    }

    private void retryDelayInMillis_$eq(int x$1) {
        this.retryDelayInMillis = x$1;
    }

    public void connect() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("(re-)connecting stream");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SseListener listener = new SseListener(this);
        this.state_$eq(new SseStreamState.Connecting(listener));
        this.lastEventId().foreach((Function1 & Serializable)lastEventId -> $this.connectRequest.getHeaders().set((CharSequence)SseStream$.MODULE$.io$gatling$http$action$sse$fsm$SseStream$$LastEventIdHeaderName(), lastEventId));
        this.httpEngine.executeRequest(this.connectRequest, this.originalSession.userId(), this.shareConnections, this.originalSession.eventLoop(), listener, this.userSslContexts);
    }

    public void connected() {
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof SseStreamState.Connecting) {
            BoxedUnit boxedUnit;
            SseStreamState.Connecting connecting = (SseStreamState.Connecting)sseStreamState;
            SseListener listener = connecting.listener();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Stream connected while in state Connecting. Processing.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.state_$eq(new SseStreamState.Connected(listener));
            this.fsm().onSseStreamConnected();
            return;
        }
        if (sseStreamState instanceof SseStreamState.Connected) {
            SseStreamState.Connected connected = (SseStreamState.Connected)sseStreamState;
            SseListener listener = connected.listener();
            this.illegalState(listener, "Invalid state: stream was connected while state was Connected. Please report.");
            return;
        }
        if (sseStreamState instanceof SseStreamState.Closing) {
            BoxedUnit boxedUnit;
            SseStreamState.Closing closing = (SseStreamState.Closing)sseStreamState;
            SseListener listener = closing.listener();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Stream connected while state was Closing. Closing.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            listener.closeChannel();
            this.fsm().onSseStreamClosed();
            this.state_$eq(SseStreamState$Closed$.MODULE$);
            return;
        }
        if (SseStreamState$Closed$.MODULE$.equals(sseStreamState)) {
            this.illegalState(null, "Invalid state: stream was connected while state was Closed. Please report.");
            return;
        }
        throw new MatchError((Object)sseStreamState);
    }

    public void endOfStream() {
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof SseStreamState.Connecting) {
            SseStreamState.Connecting connecting = (SseStreamState.Connecting)sseStreamState;
            SseListener listener = connecting.listener();
            this.illegalState(listener, "Invalid state: server ended the stream while state was Connecting. Please report.");
            return;
        }
        if (sseStreamState instanceof SseStreamState.Connected) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("End of stream reached while in state Connected.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.state_$eq(SseStreamState$Closed$.MODULE$);
            this.fsm().onSseEndOfStream();
            return;
        }
        if (sseStreamState instanceof SseStreamState.Closing) {
            this.state_$eq(SseStreamState$Closed$.MODULE$);
            return;
        }
        if (SseStreamState$Closed$.MODULE$.equals(sseStreamState)) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("End of stream reached while in state Closed.");
                return;
            }
            return;
        }
        throw new MatchError((Object)sseStreamState);
    }

    public void closeFromClient() {
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof SseStreamState.Connecting) {
            SseStreamState.Connecting connecting = (SseStreamState.Connecting)sseStreamState;
            SseListener listener = connecting.listener();
            listener.closeChannel();
            this.state_$eq(new SseStreamState.Closing(listener));
            this.fsm().onSseStreamClosed();
            return;
        }
        if (sseStreamState instanceof SseStreamState.Connected) {
            SseStreamState.Connected connected = (SseStreamState.Connected)sseStreamState;
            SseListener listener = connected.listener();
            listener.closeChannel();
            this.state_$eq(new SseStreamState.Closing(listener));
            this.fsm().onSseStreamClosed();
            return;
        }
        if (sseStreamState instanceof SseStreamState.Closing) {
            SseStreamState.Closing closing = (SseStreamState.Closing)sseStreamState;
            SseListener listener = closing.listener();
            this.illegalState(listener, "Invalid state: client closed the stream while state was Closing. Please report.");
            return;
        }
        if (SseStreamState$Closed$.MODULE$.equals(sseStreamState)) {
            return;
        }
        throw new MatchError((Object)sseStreamState);
    }

    public void crash(Throwable throwable) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Sse stream crashed", throwable);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            String errorMessage = Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable));
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Sse stream crashed: {}", (Object)errorMessage);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof SseStreamState.Connecting) {
            this.state_$eq(SseStreamState$Closed$.MODULE$);
            this.fsm().onSseStreamCrashed(throwable);
            return;
        }
        if (sseStreamState instanceof SseStreamState.Connected) {
            Throwable throwable2 = throwable;
            PrematureCloseException prematureCloseException = PrematureCloseException.INSTANCE;
            if (!(throwable2 != null ? !throwable2.equals(prematureCloseException) : prematureCloseException != null)) {
                this.originalSession.eventLoop().schedule(() -> this.connect(), (long)this.retryDelayInMillis(), TimeUnit.MILLISECONDS);
                return;
            }
            this.state_$eq(SseStreamState$Closed$.MODULE$);
            this.fsm().onSseStreamCrashed(throwable);
            return;
        }
        if (sseStreamState instanceof SseStreamState.Closing) {
            this.state_$eq(SseStreamState$Closed$.MODULE$);
            return;
        }
        if (SseStreamState$Closed$.MODULE$.equals(sseStreamState)) {
            return;
        }
        throw new MatchError((Object)sseStreamState);
    }

    public void eventReceived(ServerSentEvent event) {
        if (event.id().isDefined()) {
            this.lastEventId_$eq(event.id());
        }
        event.retry().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> this.retryDelayInMillis_$eq(x$3));
        SseStreamState sseStreamState = this.state();
        if (sseStreamState instanceof SseStreamState.Connected) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Received SSE event {} while in Open state. Propagating.", (Object)event);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.fsm().onSseReceived(event);
            return;
        }
        if (sseStreamState instanceof SseStreamState.Connecting) {
            SseStreamState.Connecting connecting = (SseStreamState.Connecting)sseStreamState;
            SseListener listener = connecting.listener();
            this.illegalState(listener, "Invalid state: received SSE " + event + " while state was Connecting. Please report.");
            return;
        }
        if (sseStreamState instanceof SseStreamState.Closing) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Received SSE event {} while in ProcessingClientCloseRequest state. Ignoring.", (Object)event);
                return;
            }
            return;
        }
        this.illegalState(null, "Invalid state: received SSE " + event + " while state was Close. Please report.");
    }

    private void illegalState(SseListener listener, String message) {
        this.fsm().onSseStreamCrashed(new IllegalStateException(message));
        if (listener != null) {
            listener.closeChannel();
        }
        this.state_$eq(SseStreamState$Closed$.MODULE$);
    }

    public SseStream(Session originalSession, Request connectRequest, String connectActionName, Option<SslContexts> userSslContexts, boolean shareConnections, HttpEngine httpEngine, StatsEngine statsEngine, Clock clock) {
        this.originalSession = originalSession;
        this.connectRequest = connectRequest;
        this.userSslContexts = userSslContexts;
        this.shareConnections = shareConnections;
        this.httpEngine = httpEngine;
        StrictLogging.$init$((StrictLogging)this);
        this.groups = originalSession.groups();
        this.lastEventId = None$.MODULE$;
        this.retryDelayInMillis = SseStream$.MODULE$.io$gatling$http$action$sse$fsm$SseStream$$DefaultRetryDelayInMillis();
        Statics.releaseFence();
    }
}

