/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.CoreComponents;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.filter.Filters;
import io.gatling.core.session.Session;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.cache.InferredPageResources;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.fetch.ConcurrentResource;
import io.gatling.http.fetch.CssParser$;
import io.gatling.http.fetch.DefaultResourceAggregator;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.fetch.ResourceAggregator;
import io.gatling.http.fetch.ResourceFetcher$;
import io.gatling.http.fetch.UserAgent$;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestDef;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005xAB\t\u0013\u0011\u0003!\"D\u0002\u0004\u001d%!\u0005A#\b\u0005\u0006]\u0005!\t\u0001\r\u0005\u0006c\u0005!\tA\r\u0005\u0006#\u0006!\tA\u0015\u0004\u00069I\u0001Ac \u0005\u000b\u0003\u0003)!\u0011!Q\u0001\n\u0005\r\u0001\u0002C2\u0006\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011-,!\u0011!Q\u0001\n1D!\"a\u0003\u0006\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011\u0019qS\u0001\"\u0001\u0002\u001e!9\u0011\u0011F\u0003\u0005\n\u0005-\u0002bBA'\u000b\u0011\u0005\u0011q\n\u0005\b\u0003/+A\u0011BAM\u0011\u001d\t9+\u0002C\u0005\u0003SCq!a0\u0006\t\u0003\t\t\rC\u0004\u0002F\u0016!\t!a2\u0002\u001fI+7o\\;sG\u00164U\r^2iKJT!a\u0005\u000b\u0002\u000b\u0019,Go\u00195\u000b\u0005U1\u0012\u0001\u00025uiBT!a\u0006\r\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011$\u0001\u0002j_B\u00111$A\u0007\u0002%\ty!+Z:pkJ\u001cWMR3uG\",'oE\u0002\u0002=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013-\u001b\u00051#BA\u0014)\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tI#&\u0001\u0005usB,7/\u00194f\u0015\u0005Y\u0013aA2p[&\u0011QF\n\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012AG\u0001\u0015CB\u0004H.\u001f*fg>,(oY3GS2$XM]:\u0015\u0007M\u0012E\tE\u00025y}r!!\u000e\u001e\u000f\u0005YJT\"A\u001c\u000b\u0005az\u0013A\u0002\u001fs_>$h(C\u0001\"\u0013\tY\u0004%A\u0004qC\u000e\\\u0017mZ3\n\u0005ur$\u0001\u0002'jgRT!a\u000f\u0011\u0011\u0005m\u0001\u0015BA!\u0013\u0005I\u0019uN\\2veJ,g\u000e\u001e*fg>,(oY3\t\u000b\r\u001b\u0001\u0019A\u001a\u0002\u0013I,7o\\;sG\u0016\u001c\b\"B#\u0004\u0001\u00041\u0015a\u00024jYR,'o\u001d\t\u0004?\u001dK\u0015B\u0001%!\u0005\u0019y\u0005\u000f^5p]B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\u0007M&dG/\u001a:\u000b\u000593\u0012\u0001B2pe\u0016L!\u0001U&\u0003\u000f\u0019KG\u000e^3sg\u0006\u0019\"/Z:pkJ\u001cWm\u001d+p%\u0016\fX/Z:ugR91KW.cUJ<\bc\u0001\u001b=)B\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bF\u0001\be\u0016\fX/Z:u\u0013\tIfKA\u0006IiR\u0004(+Z9vKN$\b\"B\"\u0005\u0001\u0004\u0019\u0004\"\u0002/\u0005\u0001\u0004i\u0016aB:fgNLwN\u001c\t\u0003=\u0002l\u0011a\u0018\u0006\u000396K!!Y0\u0003\u000fM+7o]5p]\")1\r\u0002a\u0001I\u0006Q\u0001\u000e\u001e;q\u0007\u0006\u001c\u0007.Z:\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d$\u0012!B2bG\",\u0017BA5g\u0005)AE\u000f\u001e9DC\u000eDWm\u001d\u0005\u0006W\u0012\u0001\r\u0001\\\u0001\rQR$\b\u000f\u0015:pi>\u001cw\u000e\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0003_R\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003c:\u0014A\u0002\u0013;uaB\u0013x\u000e^8d_2DQa\u001d\u0003A\u0002Q\f\u0011\u0002\u001e5s_R$H.\u001a3\u0011\u0005})\u0018B\u0001<!\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u001f\u0003A\u0002e\fQbY8oM&<WO]1uS>t\u0007C\u0001>~\u001b\u0005Y(B\u0001?N\u0003\u0019\u0019wN\u001c4jO&\u0011ap\u001f\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0014\u0007\u0015qB%\u0001\bd_J,7i\\7q_:,g\u000e^:\u0011\t\u0005\u0015\u0011qA\u0007\u0002\u001b&\u0019\u0011\u0011B'\u0003\u001d\r{'/Z\"p[B|g.\u001a8ug\u0006q\u0001\u000e\u001e;q)b,\u00050Z2vi>\u0014\b\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0003ibT1!a\u0006\u0015\u0003\u0019)gnZ5oK&!\u00111DA\t\u00059AE\u000f\u001e9Uq\u0016CXmY;u_J$\"\"a\b\u0002\"\u0005\r\u0012QEA\u0014!\tYR\u0001C\u0004\u0002\u0002)\u0001\r!a\u0001\t\u000b\rT\u0001\u0019\u00013\t\u000b-T\u0001\u0019\u00017\t\u000f\u0005-!\u00021\u0001\u0002\u000e\u0005\u0011\u0012N\u001c4feB\u000bw-\u001a*fg>,(oY3t)%\u0019\u0016QFA\u001e\u0003\u0013\nY\u0005\u0003\u0004X\u0017\u0001\u0007\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u000b\u0002\r\rd\u0017.\u001a8u\u0013\u0011\tI$a\r\u0003\u000fI+\u0017/^3ti\"9\u0011QH\u0006A\u0002\u0005}\u0012\u0001\u0003:fgB|gn]3\u0011\t\u0005\u0005\u0013QI\u0007\u0003\u0003\u0007R1!!\u0010\u0015\u0013\u0011\t9%a\u0011\u0003\u0011I+7\u000f]8og\u0016DQ\u0001X\u0006A\u0002uCQa]\u0006A\u0002Q\f!bY:t\r\u0016$8\r[3e)5\u0019\u0016\u0011KA0\u0003s\ny)a%\u0002\u0016\"9\u00111\u000b\u0007A\u0002\u0005U\u0013aA;sSB!\u0011qKA.\u001b\t\tIF\u0003\u0003\u0002T\u0005M\u0012\u0002BA/\u00033\u00121!\u0016:j\u0011\u001d\t\t\u0007\u0004a\u0001\u0003G\naB]3ta>t7/Z*uCR,8\u000f\u0005\u0003\u0002f\u0005UTBAA4\u0015\r)\u0012\u0011\u000e\u0006\u0005\u0003W\ni'A\u0003d_\u0012,7M\u0003\u0003\u0002p\u0005E\u0014a\u00025b]\u0012dWM\u001d\u0006\u0004\u0003gB\u0012!\u00028fiRL\u0018\u0002BA<\u0003O\u0012!\u0003\u0013;uaJ+7\u000f]8og\u0016\u001cF/\u0019;vg\"9\u00111\u0010\u0007A\u0002\u0005u\u0014A\u00057bgRlu\u000eZ5gS\u0016$wJ]#uC\u001e\u0004BaH$\u0002\u0000A!\u0011\u0011QAE\u001d\u0011\t\u0019)!\"\u0011\u0005Y\u0002\u0013bAADA\u00051\u0001K]3eK\u001aLA!a#\u0002\u000e\n11\u000b\u001e:j]\u001eT1!a\"!\u0011\u001d\t\t\n\u0004a\u0001\u0003\u007f\nqaY8oi\u0016tG\u000fC\u0003]\u0019\u0001\u0007Q\fC\u0003t\u0019\u0001\u0007A/\u0001\fck&dG-\u0012=qY&\u001c\u0017\u000e\u001e*fg>,(oY3t)\u0015\u0019\u00161TAS\u0011\u0019\u0019U\u00021\u0001\u0002\u001eB!A\u0007PAP!\r)\u0016\u0011U\u0005\u0004\u0003G3&A\u0004%uiB\u0014V-];fgR$UM\u001a\u0005\u000696\u0001\r!X\u0001\u0013e\u0016\u001cx.\u001e:dK\u0006;wM]3hCR|'\u000f\u0006\u0004\u0002,\u0006M\u00161\u0018\t\u0005?\u001d\u000bi\u000bE\u0002\u001c\u0003_K1!!-\u0013\u0005I\u0011Vm]8ve\u000e,\u0017iZ4sK\u001e\fGo\u001c:\t\u000f\u0005Ma\u00021\u0001\u00026B!\u0011qBA\\\u0013\u0011\tI,!\u0005\u0003\r!#H\u000f\u001d+y\u0011\u0019\tiL\u0004a\u0001'\u0006\t\u0012N\u001c4feJ,GMU3t_V\u00148-Z:\u0002E9,wOU3t_V\u00148-Z!hOJ,w-\u0019;pe\u001a{'oQ1dQ\u0016$\u0007+Y4f)\u0011\tY+a1\t\u000f\u0005Mq\u00021\u0001\u00026\u0006\u0019c.Z<SKN|WO]2f\u0003\u001e<'/Z4bi>\u0014hi\u001c:GKR\u001c\u0007.\u001a3QC\u001e,G\u0003CAV\u0003\u0013\fY-!4\t\u000f\u0005u\u0002\u00031\u0001\u0002@!9\u00111\u0003\tA\u0002\u0005U\u0006bBAh!\u0001\u0007\u0011\u0011[\u0001\u0007gR\fG/^:\u0011\t\u0005M\u0017Q\\\u0007\u0003\u0003+TA!a6\u0002Z\u0006)1\u000f^1ug*\u0019\u00111\u001c\f\u0002\u000f\r|W.\\8og&!\u0011q\\Ak\u0005\u0019\u0019F/\u0019;vg\u0002")
public class ResourceFetcher
implements StrictLogging {
    private final CoreComponents coreComponents;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final HttpTxExecutor httpTxExecutor;
    private final Logger logger;

    public static List<HttpRequest> resourcesToRequests(List<ConcurrentResource> list, Session session, HttpCaches httpCaches, HttpProtocol httpProtocol, boolean bl, GatlingConfiguration gatlingConfiguration) {
        return ResourceFetcher$.MODULE$.resourcesToRequests(list, session, httpCaches, httpProtocol, bl, gatlingConfiguration);
    }

    public static List<ConcurrentResource> applyResourceFilters(List<ConcurrentResource> list, Option<Filters> option) {
        return ResourceFetcher$.MODULE$.applyResourceFilters(list, option);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<HttpRequest> inferPageResources(Request request, Response response, Session session, boolean throttled) {
        Nil$ nil$;
        Uri htmlDocumentUri = request.getUri();
        HttpResponseStatus httpResponseStatus = response.status();
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
        if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
            List<HttpRequest> list;
            Option<String> option = response.lastModifiedOrEtag(this.httpProtocol);
            if (option instanceof Some) {
                Some some = (Some)option;
                String newLastModifiedOrEtag = (String)some.value();
                list = this.httpCaches.computeInferredResourcesIfAbsent(this.httpProtocol, htmlDocumentUri, newLastModifiedOrEtag, (Function0<List<HttpRequest>>)(Function0 & Serializable & scala.Serializable)() -> this.inferredResourcesRequests$1(htmlDocumentUri, response, request, session, throttled));
            } else {
                list = this.inferredResourcesRequests$1(htmlDocumentUri, response, request, session, throttled);
            }
            nil$ = list;
        } else {
            HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.NOT_MODIFIED;
            HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
            if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
                Nil$ nil$2;
                InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(this.httpProtocol, htmlDocumentUri);
                if (inferredPageResources == null) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Got a 304 for {} but could find cache entry?!", new Object[]{htmlDocumentUri});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    nil$2 = Nil$.MODULE$;
                } else {
                    nil$2 = inferredPageResources.requests();
                }
                nil$ = nil$2;
            } else {
                nil$ = Nil$.MODULE$;
            }
        }
        return nil$;
    }

    public List<HttpRequest> cssFetched(Uri uri, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content, Session session, boolean throttled) {
        Nil$ nil$;
        HttpResponseStatus httpResponseStatus = responseStatus;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
        if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
            List<HttpRequest> list;
            Option<String> option = lastModifiedOrEtag;
            if (option instanceof Some) {
                Some some = (Some)option;
                String newLastModifiedOrEtag = (String)some.value();
                list = this.httpCaches.computeInferredResourcesIfAbsent(this.httpProtocol, uri, newLastModifiedOrEtag, (Function0<List<HttpRequest>>)(Function0 & Serializable & scala.Serializable)() -> {
                    $this.httpCaches.removeCssResources(uri);
                    return this.parseCssResources$1(content, uri, session, throttled);
                });
            } else {
                list = this.parseCssResources$1(content, uri, session, throttled);
            }
            nil$ = list;
        } else {
            HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.NOT_MODIFIED;
            HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
            if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
                Nil$ nil$2;
                InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(this.httpProtocol, uri);
                if (inferredPageResources == null) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Got a 304 for {} but could find cache entry?!", new Object[]{uri});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    nil$2 = Nil$.MODULE$;
                } else {
                    nil$2 = inferredPageResources.requests();
                }
                nil$ = nil$2;
            } else {
                nil$ = Nil$.MODULE$;
            }
        }
        return nil$;
    }

    private List<HttpRequest> buildExplicitResources(List<HttpRequestDef> resources, Session session) {
        return (List)resources.flatMap((Function1 & Serializable & scala.Serializable)resource -> {
            Iterable iterable;
            Validation validation = (Validation)resource.requestName().apply((Object)session);
            if (validation instanceof Success) {
                Iterable iterable2;
                Success success = (Success)validation;
                String requestName = (String)success.value();
                Validation<HttpRequest> validation2 = resource.build(requestName, session);
                if (validation2 instanceof Success) {
                    Success success2 = (Success)validation2;
                    HttpRequest httpRequest = (HttpRequest)success2.value();
                    iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)httpRequest));
                } else if (validation2 instanceof Failure) {
                    Failure failure = (Failure)validation2;
                    String m = failure.message();
                    $this.coreComponents.statsEngine().reportUnbuildableRequest(session, requestName, m);
                    iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    throw new MatchError(validation2);
                }
                iterable = iterable2;
            } else if (validation instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)validation;
                String m = failure.message();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(47).append("Could build request name for explicitResource: ").append(m).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                throw new MatchError((Object)validation);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom());
    }

    private Option<ResourceAggregator> resourceAggregator(HttpTx tx, List<HttpRequest> inferredResources) {
        List<HttpRequest> list;
        List<HttpRequest> explicitResources = tx.request().requestConfig().explicitResources().nonEmpty() ? this.buildExplicitResources(tx.request().requestConfig().explicitResources(), tx.session()) : Nil$.MODULE$;
        List list2 = explicitResources.$colon$colon$colon(list = inferredResources);
        Object object = Nil$.MODULE$.equals(list2) ? None$.MODULE$ : new Some((Object)new DefaultResourceAggregator(tx, (Seq<HttpRequest>)list2, this.httpCaches, this, this.httpTxExecutor, this.coreComponents.clock(), this.coreComponents.configuration()));
        return object;
    }

    public Option<ResourceAggregator> newResourceAggregatorForCachedPage(HttpTx tx) {
        InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(tx.request().requestConfig().httpProtocol(), tx.request().clientRequest().getUri());
        List<HttpRequest> list = inferredPageResources == null ? Nil$.MODULE$ : inferredPageResources.requests();
        List<HttpRequest> inferredResources = list;
        return this.resourceAggregator(tx, inferredResources);
    }

    public Option<ResourceAggregator> newResourceAggregatorForFetchedPage(Response response, HttpTx tx, Status status) {
        Option<ResourceAggregator> option;
        Status status2 = status;
        KO$ kO$ = KO$.MODULE$;
        if (!(status2 != null ? !status2.equals(kO$) : kO$ != null)) {
            option = None$.MODULE$;
        } else {
            List<HttpRequest> inferredResources = this.httpProtocol.responsePart().inferHtmlResources() && HttpHelper$.MODULE$.isHtml(response.headers()) ? this.inferPageResources(tx.request().clientRequest(), response, tx.session(), tx.request().requestConfig().throttled()) : Nil$.MODULE$;
            option = this.resourceAggregator(tx, inferredResources);
        }
        return option;
    }

    private final List inferredResourcesRequests$1(Uri htmlDocumentUri$1, Response response$1, Request request$1, Session session$2, boolean throttled$2) {
        List<ConcurrentResource> inferred = new HtmlParser().getEmbeddedResources(htmlDocumentUri$1, response$1.body().chars(), UserAgent$.MODULE$.getAgent(request$1));
        List<ConcurrentResource> filtered = ResourceFetcher$.MODULE$.applyResourceFilters(inferred, this.httpProtocol.responsePart().htmlResourcesInferringFilters());
        return ResourceFetcher$.MODULE$.resourcesToRequests(filtered, session$2, this.httpCaches, this.httpProtocol, throttled$2, this.coreComponents.configuration());
    }

    private final List parseCssResources$1(String content$1, Uri uri$1, Session session$3, boolean throttled$3) {
        Function1 & Serializable & scala.Serializable computer = (Function1 & Serializable & scala.Serializable)x$2 -> CssParser$.MODULE$.extractResources((Uri)x$2, content$1);
        List<ConcurrentResource> inferred = this.httpCaches.computeCssResourcesIfAbsent(uri$1, (Function1<Uri, List<ConcurrentResource>>)computer);
        List<ConcurrentResource> filtered = ResourceFetcher$.MODULE$.applyResourceFilters(inferred, this.httpProtocol.responsePart().htmlResourcesInferringFilters());
        return ResourceFetcher$.MODULE$.resourcesToRequests(filtered, session$3, this.httpCaches, this.httpProtocol, throttled$3, this.coreComponents.configuration());
    }

    public ResourceFetcher(CoreComponents coreComponents, HttpCaches httpCaches, HttpProtocol httpProtocol, HttpTxExecutor httpTxExecutor) {
        this.coreComponents = coreComponents;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.httpTxExecutor = httpTxExecutor;
        StrictLogging.$init$((StrictLogging)this);
    }
}

