/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.response;

import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import io.gatling.commons.util.Maps;
import io.gatling.commons.util.Maps$;
import io.gatling.commons.util.StringHelper$;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.http.HeaderNames$;
import io.gatling.http.client.Request;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBody;
import io.gatling.http.response.ResponseBody$;
import io.gatling.http.response.ResponseBuilder$;
import io.gatling.http.util.HttpHelper$;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t}r!B\u00181\u0011\u0003Id!B\u001e1\u0011\u0003a\u0004\"B'\u0002\t\u0003q\u0005\"B(\u0002\t\u0003\u0001f\u0001B\u001e1\u0001QD\u0001\"\u0018\u0003\u0003\u0002\u0003\u0006I!\u001e\u0005\tw\u0012\u0011\t\u0011)A\u0005y\"Q\u0011Q\u0005\u0003\u0003\u0002\u0003\u0006I!a\n\t\u0015\u00055BA!A!\u0002\u0013\t9\u0003\u0003\u0006\u00020\u0011\u0011\t\u0011)A\u0005\u0003cA\u0001\"\u0019\u0003\u0003\u0002\u0003\u0006IA\u0019\u0005\u0007\u001b\u0012!\t!!\u0011\t\u0017\u0005EC\u00011AA\u0002\u0013\u0005\u00111\u000b\u0005\f\u0003+\"\u0001\u0019!a\u0001\n\u0003\t9\u0006C\u0006\u0002d\u0011\u0001\r\u0011!Q!\n\u0005\u001d\u0002bCA3\t\u0001\u0007\t\u0019!C\u0001\u0003OB1\"a\u001c\u0005\u0001\u0004\u0005\r\u0011\"\u0001\u0002r!Y\u0011Q\u000f\u0003A\u0002\u0003\u0005\u000b\u0015BA5\u0011-\t9\b\u0002a\u0001\u0002\u0004%\t!a\u001a\t\u0017\u0005eD\u00011AA\u0002\u0013\u0005\u00111\u0010\u0005\f\u0003\u007f\"\u0001\u0019!A!B\u0013\tI\u0007C\u0006\u0002\u0002\u0012\u0001\r\u00111A\u0005\n\u0005M\u0003bCAB\t\u0001\u0007\t\u0019!C\u0005\u0003\u000bC1\"!#\u0005\u0001\u0004\u0005\t\u0015)\u0003\u0002(!I\u00111\u0012\u0003A\u0002\u0013%\u0011Q\u0012\u0005\n\u0003W#\u0001\u0019!C\u0005\u0003[C\u0001\"!-\u0005A\u0003&\u0011q\u0012\u0005\n\u0003g#\u0001\u0019!C\u0005\u0003kC\u0011\"!0\u0005\u0001\u0004%I!a0\t\u0011\u0005\rG\u0001)Q\u0005\u0003oC\u0011\"!2\u0005\u0001\u0004%I!!.\t\u0013\u0005\u001dG\u00011A\u0005\n\u0005%\u0007\u0002CAg\t\u0001\u0006K!a.\t\u0013\u0005=G\u00011A\u0005\n\u0005E\u0007\"CAx\t\u0001\u0007I\u0011BAy\u0011!\t)\u0010\u0002Q!\n\u0005M\u0007bBA|\t\u0011\u0005\u0011\u0011 \u0005\b\u0003w$A\u0011AA}\u0011\u001d\ti\u0010\u0002C\u0001\u0003\u007fDq!!@\u0005\t\u0003\u0011\u0019\u0001C\u0004\u0003\n\u0011!\tAa\u0003\t\u000f\u0005uH\u0001\"\u0001\u0003\u0010!9!Q\u0003\u0003\u0005\n\t]\u0001b\u0002B\r\t\u0011\u0005!1\u0004\u0005\b\u0005G!A\u0011\u0001B\u0013\u0011\u001d\u0011\u0019\u0003\u0002C\u0005\u0005oAqA!\u0010\u0005\t\u0003\tI0A\bSKN\u0004xN\\:f\u0005VLG\u000eZ3s\u0015\t\t$'\u0001\u0005sKN\u0004xN\\:f\u0015\t\u0019D'\u0001\u0003iiR\u0004(BA\u001b7\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011aN\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002;\u00035\t\u0001GA\bSKN\u0004xN\\:f\u0005VLG\u000eZ3s'\r\tQh\u0011\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015\u0001D:dC2\fGn\\4hS:<'B\u0001%J\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001&\u0002\u0007\r|W.\u0003\u0002M\u000b\ni1\u000b\u001e:jGRdunZ4j]\u001e\fa\u0001P5oSRtD#A\u001d\u000239,wOU3ta>t7/\u001a\"vS2$WM\u001d$bGR|'/\u001f\u000b\u0005#b\u0003'\u000e\u0005\u0002S+:\u0011!hU\u0005\u0003)B\nq\u0001]1dW\u0006<W-\u0003\u0002W/\n1\"+Z:q_:\u001cXMQ;jY\u0012,'OR1di>\u0014\u0018P\u0003\u0002Ua!)\u0011l\u0001a\u00015\u0006i!/Z9vKN$8i\u001c8gS\u001e\u0004\"a\u00170\u000e\u0003qS!!\u0018\u001a\u0002\u000fI,\u0017/^3ti&\u0011q\f\u0018\u0002\u0012\u0011R$\bOU3rk\u0016\u001cHoQ8oM&<\u0007\"B1\u0004\u0001\u0004\u0011\u0017!B2m_\u000e\\\u0007CA2i\u001b\u0005!'BA3g\u0003\u0011)H/\u001b7\u000b\u0005\u001d$\u0014aB2p[6|gn]\u0005\u0003S\u0012\u0014Qa\u00117pG.DQa[\u0002A\u00021\fQbY8oM&<WO]1uS>t\u0007CA7s\u001b\u0005q'BA8q\u0003\u0019\u0019wN\u001c4jO*\u0011\u0011\u000fN\u0001\u0005G>\u0014X-\u0003\u0002t]\n!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:\u001c\"\u0001B\u001f\u0011\u0005YLX\"A<\u000b\u0005a\u0014\u0014AB2mS\u0016tG/\u0003\u0002{o\n9!+Z9vKN$\u0018a\u00023jO\u0016\u001cHo\u001d\t\b{\u0006%\u0011qBA\u000b\u001d\rq\u0018Q\u0001\t\u0003\u007f~j!!!\u0001\u000b\u0007\u0005\r\u0001(\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000fy\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!aA'ba*\u0019\u0011qA \u0011\u0007u\f\t\"\u0003\u0003\u0002\u0014\u00055!AB*ue&tw\r\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0011M,7-\u001e:jifT!!a\b\u0002\t)\fg/Y\u0005\u0005\u0003G\tIBA\u0007NKN\u001c\u0018mZ3ES\u001e,7\u000f^\u0001\u000fgR|'/\u001a\"pIf\u0004\u0016M\u001d;t!\rq\u0014\u0011F\u0005\u0004\u0003Wy$a\u0002\"p_2,\u0017M\\\u0001\u0013S:4WM\u001d%u[2\u0014Vm]8ve\u000e,7/\u0001\beK\u001a\fW\u000f\u001c;DQ\u0006\u00148/\u001a;\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u000591\r[1sg\u0016$(\u0002BA\u001e\u0003;\t1A\\5p\u0013\u0011\ty$!\u000e\u0003\u000f\rC\u0017M]:fiRq\u00111IA#\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0003C\u0001\u001e\u0005\u0011\u0015i6\u00021\u0001v\u0011\u0015Y8\u00021\u0001}\u0011\u001d\t)c\u0003a\u0001\u0003OAq!!\f\f\u0001\u0004\t9\u0003C\u0004\u00020-\u0001\r!!\r\t\u000b\u0005\\\u0001\u0019\u00012\u0002\u001dM$xN]3Ii6dwJ]\"tgV\u0011\u0011qE\u0001\u0013gR|'/\u001a%u[2|%oQ:t?\u0012*\u0017\u000f\u0006\u0003\u0002Z\u0005}\u0003c\u0001 \u0002\\%\u0019\u0011QL \u0003\tUs\u0017\u000e\u001e\u0005\n\u0003Cj\u0011\u0011!a\u0001\u0003O\t1\u0001\u001f\u00132\u0003=\u0019Ho\u001c:f\u0011RlGn\u0014:DgN\u0004\u0013AD:uCJ$H+[7fgR\fW\u000e]\u000b\u0003\u0003S\u00022APA6\u0013\r\tig\u0010\u0002\u0005\u0019>tw-\u0001\nti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BA-\u0003gB\u0011\"!\u0019\u0011\u0003\u0003\u0005\r!!\u001b\u0002\u001fM$\u0018M\u001d;US6,7\u000f^1na\u0002\nA\"\u001a8e)&lWm\u001d;b[B\f\u0001#\u001a8e)&lWm\u001d;b[B|F%Z9\u0015\t\u0005e\u0013Q\u0010\u0005\n\u0003C\u001a\u0012\u0011!a\u0001\u0003S\nQ\"\u001a8e)&lWm\u001d;b[B\u0004\u0013aB5t\u0011R$\bOM\u0001\fSNDE\u000f\u001e93?\u0012*\u0017\u000f\u0006\u0003\u0002Z\u0005\u001d\u0005\"CA1-\u0005\u0005\t\u0019AA\u0014\u0003!I7\u000f\u0013;uaJ\u0002\u0013AB:uCR,8/\u0006\u0002\u0002\u0010B)a(!%\u0002\u0016&\u0019\u00111S \u0003\r=\u0003H/[8o!\u0011\t9*a*\u000e\u0005\u0005e%bA\u001a\u0002\u001c*!\u0011QTAP\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\t\t+a)\u0002\u000f!\fg\u000e\u001a7fe*\u0019\u0011Q\u0015\u001c\u0002\u000b9,G\u000f^=\n\t\u0005%\u0016\u0011\u0014\u0002\u0013\u0011R$\bOU3ta>t7/Z*uCR,8/\u0001\u0006ti\u0006$Xo]0%KF$B!!\u0017\u00020\"I\u0011\u0011M\r\u0002\u0002\u0003\u0007\u0011qR\u0001\bgR\fG/^:!\u0003I9\u0018N]3SKF,Xm\u001d;IK\u0006$WM]:\u0016\u0005\u0005]\u0006\u0003BAL\u0003sKA!a/\u0002\u001a\nY\u0001\n\u001e;q\u0011\u0016\fG-\u001a:t\u0003Y9\u0018N]3SKF,Xm\u001d;IK\u0006$WM]:`I\u0015\fH\u0003BA-\u0003\u0003D\u0011\"!\u0019\u001d\u0003\u0003\u0005\r!a.\u0002']L'/\u001a*fcV,7\u000f\u001e%fC\u0012,'o\u001d\u0011\u0002\u000f!,\u0017\rZ3sg\u0006Y\u0001.Z1eKJ\u001cx\fJ3r)\u0011\tI&a3\t\u0013\u0005\u0005t$!AA\u0002\u0005]\u0016\u0001\u00035fC\u0012,'o\u001d\u0011\u0002\r\rDWO\\6t+\t\t\u0019\u000e\u0005\u0004\u0002V\u0006u\u00171\u001d\b\u0005\u0003/\fYND\u0002\u0000\u00033L\u0011\u0001Q\u0005\u0003)~JA!a8\u0002b\n!A*[:u\u0015\t!v\b\u0005\u0003\u0002f\u0006-XBAAt\u0015\u0011\tI/a)\u0002\r\t,hMZ3s\u0013\u0011\ti/a:\u0003\u000f\tKH/\u001a\"vM\u0006Q1\r[;oWN|F%Z9\u0015\t\u0005e\u00131\u001f\u0005\n\u0003C\u0012\u0013\u0011!a\u0001\u0003'\fqa\u00195v].\u001c\b%\u0001\u000bva\u0012\fG/Z*uCJ$H+[7fgR\fW\u000e\u001d\u000b\u0003\u00033\n!#\u001e9eCR,WI\u001c3US6,7\u000f^1na\u0006Q\u0011mY2v[Vd\u0017\r^3\u0015\t\u0005e#\u0011\u0001\u0005\b\u0003g3\u0003\u0019AA\\)\u0019\tIF!\u0002\u0003\b!9\u00111R\u0014A\u0002\u0005U\u0005bBAcO\u0001\u0007\u0011qW\u0001\tg\u0016$\b\n\u001e;qeQ!\u0011\u0011\fB\u0007\u0011\u001d\t\t\t\u000ba\u0001\u0003O!B!!\u0017\u0003\u0012!9!1C\u0015A\u0002\u0005\r\u0018a\u00022zi\u0016\u0014UOZ\u0001\u000fe\u0016\u001cx\u000e\u001c<f\u0007\"\f'o]3u+\t\t\t$A\u0007ck&dGMU3ta>t7/Z\u000b\u0003\u0005;\u00012A\u000fB\u0010\u0013\r\u0011\t\u0003\r\u0002\u000b\u0011R$\bOU3tk2$\u0018\u0001\u00042vS2$g)Y5mkJ,G\u0003\u0002B\u0014\u0005[\u00012A\u000fB\u0015\u0013\r\u0011Y\u0003\r\u0002\f\u0011R$\bOR1jYV\u0014X\rC\u0004\u000301\u0002\rA!\r\u0002\u0003Q\u0004B!!6\u00034%!!QGAq\u0005%!\u0006N]8xC\ndW\r\u0006\u0003\u0003(\te\u0002b\u0002B\u001e[\u0001\u0007\u0011qB\u0001\rKJ\u0014xN]'fgN\fw-Z\u0001\u000ee\u0016dW-Y:f\u0007\",hn[:")
public class ResponseBuilder {
    private final Request request;
    private final Map<String, MessageDigest> digests;
    private final boolean storeBodyParts;
    private final boolean inferHtmlResources;
    private final Charset defaultCharset;
    private final Clock clock;
    private boolean storeHtmlOrCss;
    private long startTimestamp;
    private long endTimestamp;
    private boolean isHttp2;
    private Option<HttpResponseStatus> status;
    private HttpHeaders wireRequestHeaders;
    private HttpHeaders headers;
    private List<ByteBuf> chunks;

    public static Function1<Request, ResponseBuilder> newResponseBuilderFactory(HttpRequestConfig httpRequestConfig, Clock clock, GatlingConfiguration gatlingConfiguration) {
        return ResponseBuilder$.MODULE$.newResponseBuilderFactory(httpRequestConfig, clock, gatlingConfiguration);
    }

    public boolean storeHtmlOrCss() {
        return this.storeHtmlOrCss;
    }

    public void storeHtmlOrCss_$eq(boolean x$1) {
        this.storeHtmlOrCss = x$1;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public void startTimestamp_$eq(long x$1) {
        this.startTimestamp = x$1;
    }

    public long endTimestamp() {
        return this.endTimestamp;
    }

    public void endTimestamp_$eq(long x$1) {
        this.endTimestamp = x$1;
    }

    private boolean isHttp2() {
        return this.isHttp2;
    }

    private void isHttp2_$eq(boolean x$1) {
        this.isHttp2 = x$1;
    }

    private Option<HttpResponseStatus> status() {
        return this.status;
    }

    private void status_$eq(Option<HttpResponseStatus> x$1) {
        this.status = x$1;
    }

    private HttpHeaders wireRequestHeaders() {
        return this.wireRequestHeaders;
    }

    private void wireRequestHeaders_$eq(HttpHeaders x$1) {
        this.wireRequestHeaders = x$1;
    }

    private HttpHeaders headers() {
        return this.headers;
    }

    private void headers_$eq(HttpHeaders x$1) {
        this.headers = x$1;
    }

    private List<ByteBuf> chunks() {
        return this.chunks;
    }

    private void chunks_$eq(List<ByteBuf> x$1) {
        this.chunks = x$1;
    }

    public void updateStartTimestamp() {
        this.startTimestamp_$eq(this.clock.nowMillis());
    }

    public void updateEndTimestamp() {
        this.endTimestamp_$eq(this.clock.nowMillis());
    }

    public void accumulate(HttpHeaders wireRequestHeaders) {
        this.wireRequestHeaders_$eq(wireRequestHeaders);
    }

    public void accumulate(HttpResponseStatus status, HttpHeaders headers) {
        this.updateEndTimestamp();
        this.status_$eq((Option<HttpResponseStatus>)new Some((Object)status));
        if (this.headers() == EmptyHttpHeaders.INSTANCE) {
            this.headers_$eq(headers);
            this.storeHtmlOrCss_$eq(this.inferHtmlResources && (HttpHelper$.MODULE$.isHtml(headers) || HttpHelper$.MODULE$.isCss(headers)));
        } else {
            this.headers().add(headers);
        }
    }

    public void setHttp2(boolean isHttp2) {
        this.isHttp2_$eq(isHttp2);
    }

    public void accumulate(ByteBuf byteBuf) {
        block2: {
            this.updateEndTimestamp();
            if (!byteBuf.isReadable()) break block2;
            if (this.storeBodyParts || this.storeHtmlOrCss()) {
                ByteBuf byteBuf2 = byteBuf.retain();
                this.chunks_$eq((List<ByteBuf>)this.chunks().$colon$colon((Object)byteBuf2));
            }
            if (this.digests.nonEmpty()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])byteBuf.nioBuffers())).foreach((Function1 & Serializable & scala.Serializable)nioBuffer -> {
                    ResponseBuilder.$anonfun$accumulate$1(this, nioBuffer);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private Charset resolveCharset() {
        return (Charset)Option$.MODULE$.apply((Object)this.headers().get(HeaderNames$.MODULE$.ContentType())).flatMap((Function1 & Serializable & scala.Serializable)contentType -> HttpHelper$.MODULE$.extractCharsetFromContentType((String)contentType)).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.defaultCharset);
    }

    public HttpResult buildResponse() {
        HttpFailure httpFailure;
        Option<HttpResponseStatus> option = this.status();
        if (option instanceof Some) {
            Product product;
            Some some = (Some)option;
            HttpResponseStatus s = (HttpResponseStatus)some.value();
            try {
                this.endTimestamp_$eq(package$.MODULE$.max(this.endTimestamp(), this.startTimestamp()));
                Map checksums = Maps.PimpedMap$.MODULE$.forceMapValues$extension(Maps$.MODULE$.PimpedMap(this.digests), (Function1 & Serializable & scala.Serializable)md -> StringHelper$.MODULE$.bytes2Hex(md.digest()));
                int contentLength = BoxesRunTime.unboxToInt((Object)Collections.PimpedTraversableOnce$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedTraversableOnce(this.chunks()), (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.readableBytes()), (Numeric)Numeric.IntIsIntegral$.MODULE$));
                Charset resolvedCharset = this.resolveCharset();
                List chunksOrderedByArrival = this.chunks().reverse();
                ResponseBody body = ResponseBody$.MODULE$.apply((Seq<ByteBuf>)chunksOrderedByArrival, resolvedCharset);
                product = new Response(this.request, this.wireRequestHeaders(), s, this.headers(), body, (Map<String, String>)checksums, contentLength, resolvedCharset, this.startTimestamp(), this.endTimestamp(), this.isHttp2());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option2.get();
                HttpFailure httpFailure2 = this.buildFailure(t);
                product = httpFailure2;
            }
            httpFailure = product;
        } else {
            httpFailure = this.buildFailure("How come we're trying to build a response with no status?!");
        }
        return httpFailure;
    }

    public HttpFailure buildFailure(Throwable t) {
        return this.buildFailure(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
    }

    private HttpFailure buildFailure(String errorMessage) {
        return new HttpFailure(this.request, this.wireRequestHeaders(), this.startTimestamp(), this.endTimestamp(), errorMessage);
    }

    public void releaseChunks() {
        this.chunks().foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.release()));
        this.chunks_$eq((List<ByteBuf>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$accumulate$1(ResponseBuilder $this, ByteBuffer nioBuffer) {
        $this.digests.values().foreach((Function1 & Serializable & scala.Serializable)digest -> {
            digest.update(nioBuffer.duplicate());
            return BoxedUnit.UNIT;
        });
    }

    public ResponseBuilder(Request request, Map<String, MessageDigest> digests, boolean storeBodyParts, boolean inferHtmlResources, Charset defaultCharset, Clock clock) {
        this.request = request;
        this.digests = digests;
        this.storeBodyParts = storeBodyParts;
        this.inferHtmlResources = inferHtmlResources;
        this.defaultCharset = defaultCharset;
        this.clock = clock;
        this.status = None$.MODULE$;
        this.wireRequestHeaders = EmptyHttpHeaders.INSTANCE;
        this.headers = EmptyHttpHeaders.INSTANCE;
        this.chunks = Nil$.MODULE$;
    }
}

