/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.HttpConfiguration;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory$;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dsA\u0002\f\u0018\u0011\u0003IrD\u0002\u0004\"/!\u0005\u0011D\t\u0005\u0006S\u0005!\ta\u000b\u0005\bY\u0005\u0011\r\u0011\"\u0003.\u0011\u00191\u0014\u0001)A\u0005]!9q'\u0001b\u0001\n\u0013A\u0004BB\"\u0002A\u0003%\u0011HB\u0003\"/\u0001YB\t\u0003\u0005P\u000f\t\u0005\t\u0015!\u0003Q\u0011\u0015Is\u0001\"\u0001Y\u0011\u001dYvA1A\u0005\nqCa\u0001Y\u0004!\u0002\u0013i\u0006bB1\b\u0005\u0004%IA\u0019\u0005\u0007c\u001e\u0001\u000b\u0011B2\t\u000fI<!\u0019!C\u0005g\"1\u0011p\u0002Q\u0001\nQDqA_\u0004C\u0002\u0013%1\u0010\u0003\u0004\u0000\u000f\u0001\u0006I\u0001 \u0005\t\u0003\u00039!\u0019!C\u0005w\"9\u00111A\u0004!\u0002\u0013a\bbBA\u0003\u000f\u0011\u0005\u0011q\u0001\u0005\b\u0003_9A\u0011BA\u0019\u0003I\u00196\u000f\\\"p]R,\u0007\u0010^:GC\u000e$xN]=\u000b\u0005aI\u0012\u0001B;uS2T!AG\u000e\u0002\t!$H\u000f\u001d\u0006\u00039u\tqaZ1uY&twMC\u0001\u001f\u0003\tIw\u000e\u0005\u0002!\u00035\tqC\u0001\nTg2\u001cuN\u001c;fqR\u001ch)Y2u_JL8CA\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001 \u0003Y!UMZ1vYR\u001c6\u000f\\*fGV\u0014XMU1oI>lW#\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\r'\u0016\u001cWO]3SC:$w.\\\u0001\u0018\t\u00164\u0017-\u001e7u'Nd7+Z2ve\u0016\u0014\u0016M\u001c3p[\u0002\n1!\u00119o+\u0005I\u0004C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003\r\u00198\u000f\u001c\u0006\u0003}}\nq\u0001[1oI2,'O\u0003\u0002A;\u0005)a.\u001a;us&\u0011!i\u000f\u0002\u001a\u0003B\u0004H.[2bi&|g\u000e\u0015:pi>\u001cw\u000e\\\"p]\u001aLw-\u0001\u0003Ba:\u00043cA\u0004$\u000bB\u0011a)T\u0007\u0002\u000f*\u0011\u0001*S\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u0015.\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0019\u0006\u00191m\\7\n\u00059;%!D*ue&\u001cG\u000fT8hO&tw-\u0001\u0006iiR\u00048i\u001c8gS\u001e\u0004\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\r\r|gNZ5h\u0015\t)6$\u0001\u0003d_J,\u0017BA,S\u0005EAE\u000f\u001e9D_:4\u0017nZ;sCRLwN\u001c\u000b\u00033j\u0003\"\u0001I\u0004\t\u000b=K\u0001\u0019\u0001)\u00021M\u001cHnU3tg&|g\u000eV5nK>,HoU3d_:$7/F\u0001^!\t!c,\u0003\u0002`K\t!Aj\u001c8h\u0003e\u00198\u000f\\*fgNLwN\u001c+j[\u0016|W\u000f^*fG>tGm\u001d\u0011\u0002!\u0015t\u0017M\u00197fIB\u0013x\u000e^8d_2\u001cX#A2\u0011\u0007\u0011\"g-\u0003\u0002fK\t)\u0011I\u001d:bsB\u0011qM\u001c\b\u0003Q2\u0004\"![\u0013\u000e\u0003)T!a\u001b\u0016\u0002\rq\u0012xn\u001c;?\u0013\tiW%\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA7&\u0003E)g.\u00192mK\u0012\u0004&o\u001c;pG>d7\u000fI\u0001\u0014K:\f'\r\\3e\u0007&\u0004\b.\u001a:Tk&$Xm]\u000b\u0002iB\u0019Qo\u001e4\u000e\u0003YT!\u0001\u0007\u001a\n\u0005a4(\u0001\u0002'jgR\fA#\u001a8bE2,GmQ5qQ\u0016\u00148+^5uKN\u0004\u0013AC;tK>\u0003XM\\*tYV\tA\u0010\u0005\u0002%{&\u0011a0\n\u0002\b\u0005>|G.Z1o\u0003-)8/Z(qK:\u001c6\u000f\u001c\u0011\u0002)U\u001cXm\u00149f]N\u001bHNR5oC2L'0\u001a:t\u0003U)8/Z(qK:\u001c6\u000f\u001c$j]\u0006d\u0017N_3sg\u0002\naB\\3x'Nd7i\u001c8uKb$8\u000f\u0006\u0004\u0002\n\u0005=\u00111\u0003\t\u0004A\u0005-\u0011bAA\u0007/\tY1k\u001d7D_:$X\r\u001f;t\u0011\u0019\t\t\u0002\u0006a\u0001y\u0006a\u0001\u000e\u001e;qe\u0015s\u0017M\u00197fI\"9\u0011Q\u0003\u000bA\u0002\u0005]\u0011\u0001\u00079feV\u001bXM]&fs6\u000bg.Y4fe\u001a\u000b7\r^8ssB)A%!\u0007\u0002\u001e%\u0019\u00111D\u0013\u0003\r=\u0003H/[8o!\u0011\ty\"a\u000b\u000e\u0005\u0005\u0005\"b\u0001\u001f\u0002$)!\u0011QEA\u0014\u0003\rqW\r\u001e\u0006\u0003\u0003S\tQA[1wCbLA!!\f\u0002\"\t\t2*Z=NC:\fw-\u001a:GC\u000e$xN]=\u0002!9,wO\u00133l'Nd7i\u001c8uKb$HCBA\u001a\u0003s\t\u0019\u0005E\u0002;\u0003kI1!a\u000e<\u0005)\u00196\u000f\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003w)\u0002\u0019AA\u001f\u00035QGm[*tY\u000e{g\u000e^3yiB!\u0011qDA \u0013\u0011\t\t%!\t\u0003\u0015M\u001bFjQ8oi\u0016DH\u000f\u0003\u0004\u0002FU\u0001\r!O\u0001\u0004CBt\u0007")
public class SslContextsFactory
implements StrictLogging {
    private final HttpConfiguration httpConfig;
    private final long sslSessionTimeoutSeconds;
    private final String[] enabledProtocols;
    private final List<String> enabledCipherSuites;
    private final boolean useOpenSsl;
    private final boolean useOpenSslFinalizers;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private long sslSessionTimeoutSeconds() {
        return this.sslSessionTimeoutSeconds;
    }

    private String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    private List<String> enabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    private boolean useOpenSsl() {
        return this.useOpenSsl;
    }

    private boolean useOpenSslFinalizers() {
        return this.useOpenSslFinalizers;
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        SslContexts sslContexts;
        Option kmf = perUserKeyManagerFactory.orElse((Function0 & Serializable & scala.Serializable)() -> $this.httpConfig.ssl().keyManagerFactory());
        Option tmf = this.httpConfig.ssl().trustManagerFactory().orElse((Function0 & Serializable & scala.Serializable)() -> $this.httpConfig.advanced().useInsecureTrustManager() ? new Some((Object)InsecureTrustManagerFactory.INSTANCE) : None$.MODULE$);
        if (this.useOpenSsl()) {
            SslProvider provider = this.useOpenSslFinalizers() ? SslProvider.OPENSSL : SslProvider.OPENSSL_REFCNT;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(provider);
            Object object = this.httpConfig.advanced().sslSessionCacheSize() > 0 ? sslContextBuilder.sessionCacheSize((long)this.httpConfig.advanced().sslSessionCacheSize()) : BoxedUnit.UNIT;
            Object object2 = this.httpConfig.advanced().sslSessionTimeout().$greater((Object)Duration$.MODULE$.Zero()) ? sslContextBuilder.sessionTimeout(this.sslSessionTimeoutSeconds()) : BoxedUnit.UNIT;
            Object object3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())).nonEmpty() ? sslContextBuilder.protocols(this.enabledProtocols()) : BoxedUnit.UNIT;
            SslContextBuilder sslContextBuilder2 = this.httpConfig.advanced().sslEnabledCipherSuites().nonEmpty() ? sslContextBuilder.ciphers(this.enabledCipherSuites()) : sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
            kmf.foreach((Function1 & Serializable & scala.Serializable)x$1 -> sslContextBuilder.keyManager(x$1));
            tmf.foreach((Function1 & Serializable & scala.Serializable)x$1 -> sslContextBuilder.trustManager(x$1));
            SslContext sslContext = sslContextBuilder.build();
            None$ alpnSslContext = http2Enabled ? new Some((Object)sslContextBuilder.applicationProtocolConfig(SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn()).build()) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        } else {
            SSLContext jdkSslContext = SSLContext.getInstance("TLS");
            jdkSslContext.init((KeyManager[])kmf.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKeyManagers()).orNull(Predef$.MODULE$.$conforms()), (TrustManager[])tmf.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getTrustManagers()).orNull(Predef$.MODULE$.$conforms()), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultSslSecureRandom());
            SslContext sslContext = this.newJdkSslContext(jdkSslContext, null);
            None$ alpnSslContext = http2Enabled ? new Some((Object)this.newJdkSslContext(jdkSslContext, SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn())) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        }
        return sslContexts;
    }

    private SslContext newJdkSslContext(SSLContext jdkSslContext, ApplicationProtocolConfig apn) {
        return new JdkSslContext(jdkSslContext, true, this.enabledCipherSuites().isEmpty() ? null : this.enabledCipherSuites(), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, apn, ClientAuth.NONE, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())).nonEmpty() ? this.enabledProtocols() : null, false);
    }

    /*
     * WARNING - void declaration
     */
    public SslContextsFactory(HttpConfiguration httpConfig) {
        boolean bl;
        this.httpConfig = httpConfig;
        StrictLogging.$init$((StrictLogging)this);
        this.sslSessionTimeoutSeconds = httpConfig.advanced().sslSessionTimeout().toSeconds();
        this.enabledProtocols = (String[])httpConfig.advanced().sslEnabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class));
        this.enabledCipherSuites = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)httpConfig.advanced().sslEnabledCipherSuites()).asJava();
        if (httpConfig.advanced().useOpenSsl()) {
            void var2_2;
            BoxedUnit boxedUnit;
            boolean available = OpenSsl.isAvailable();
            if (!available) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenSSL is enabled in the Gatling configuration but it's not available on your architecture.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = var2_2;
        } else {
            bl = false;
        }
        this.useOpenSsl = bl;
        this.useOpenSslFinalizers = httpConfig.advanced().useOpenSslFinalizers();
    }
}

