/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.sse.fsm.NextSseState;
import io.gatling.http.action.sse.fsm.NextSseState$;
import io.gatling.http.action.sse.fsm.SseConnectingState$;
import io.gatling.http.action.sse.fsm.SseCrashedState;
import io.gatling.http.action.sse.fsm.SseFsm;
import io.gatling.http.action.sse.fsm.SseIdleState;
import io.gatling.http.action.sse.fsm.SsePerformingCheckState;
import io.gatling.http.action.sse.fsm.SseState;
import io.gatling.http.check.sse.SseMessageCheck;
import io.gatling.http.check.sse.SseMessageCheckSequence;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u<QAD\b\t\u0002q1QAH\b\t\u0002}AQAJ\u0001\u0005\u0002\u001dBq\u0001K\u0001C\u0002\u0013%\u0011\u0006\u0003\u00046\u0003\u0001\u0006IA\u000b\u0005\u0006m\u0005!\ta\u000e\u0004\u0005==\u0001q\n\u0003\u0005\u0011\r\t\u0005\t\u0015!\u0003=\u0011!\u0001eA!A!\u0002\u0013\t\u0005\u0002C%\u0007\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011u3!\u0011!Q\u0001\nyCQA\n\u0004\u0005\u0002\u0005DQa\u001a\u0004\u0005B!DQa\u001b\u0004\u0005B1\f!cU:f\u0007>tg.Z2uS:<7\u000b^1uK*\u0011\u0001#E\u0001\u0004MNl'B\u0001\n\u0014\u0003\r\u00198/\u001a\u0006\u0003)U\ta!Y2uS>t'B\u0001\f\u0018\u0003\u0011AG\u000f\u001e9\u000b\u0005aI\u0012aB4bi2Lgn\u001a\u0006\u00025\u0005\u0011\u0011n\\\u0002\u0001!\ti\u0012!D\u0001\u0010\u0005I\u00196/Z\"p]:,7\r^5oON#\u0018\r^3\u0014\u0005\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00029\u0005Y2k]3D_:tWm\u0019;Tk\u000e\u001cWm]:Ti\u0006$Xo]\"pI\u0016,\u0012A\u000b\t\u0004C-j\u0013B\u0001\u0017#\u0005\u0011\u0019v.\\3\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014\u0001\u00027b]\u001eT\u0011AM\u0001\u0005U\u00064\u0018-\u0003\u00025_\t11\u000b\u001e:j]\u001e\fAdU:f\u0007>tg.Z2u'V\u001c7-Z:t'R\fG/^:D_\u0012,\u0007%\u0001\bh_R|7i\u001c8oK\u000e$\u0018N\\4\u0015\taZt\b\u0013\t\u0003;eJ!AO\b\u0003\u00199+\u0007\u0010^*tKN#\u0018\r^3\t\u000bA)\u0001\u0019\u0001\u001f\u0011\u0005ui\u0014B\u0001 \u0010\u0005\u0019\u00196/\u001a$t[\")\u0001)\u0002a\u0001\u0003\u000691/Z:tS>t\u0007C\u0001\"G\u001b\u0005\u0019%B\u0001!E\u0015\t)u#\u0001\u0003d_J,\u0017BA$D\u0005\u001d\u0019Vm]:j_:DQ!S\u0003A\u0002)\u000bAA\\3yiB\u00111*T\u0007\u0002\u0019*\u0011A\u0003R\u0005\u0003\u001d2\u0013a!Q2uS>t7c\u0001\u0004Q'B\u0011Q$U\u0005\u0003%>\u0011\u0001bU:f'R\fG/\u001a\t\u0003)nk\u0011!\u0016\u0006\u0003-^\u000bAb]2bY\u0006dwnZ4j]\u001eT!\u0001W-\u0002\u0011QL\b/Z:bM\u0016T\u0011AW\u0001\u0004G>l\u0017B\u0001/V\u00055\u0019FO]5di2{wmZ5oO\u0006a1m\u001c8oK\u000e$8\u000b^1siB\u0011\u0011eX\u0005\u0003A\n\u0012A\u0001T8oOR)!m\u00193fMB\u0011QD\u0002\u0005\u0006!-\u0001\r\u0001\u0010\u0005\u0006\u0001.\u0001\r!\u0011\u0005\u0006\u0013.\u0001\rA\u0013\u0005\u0006;.\u0001\rAX\u0001\u0015_:\u001c6/Z*ue\u0016\fWnQ8o]\u0016\u001cG/\u001a3\u0015\u0005aJ\u0007\"\u00026\r\u0001\u0004q\u0016AC2p]:,7\r^#oI\u0006\u0011rN\\*tKN#(/Z1n\u0007J\f7\u000f[3e)\rATn\u001f\u0005\u0006]6\u0001\ra\\\u0001\u0002iB\u0011\u0001\u000f\u001f\b\u0003cZt!A];\u000e\u0003MT!\u0001^\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013BA<#\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001f>\u0003\u0013QC'o\\<bE2,'BA<#\u0011\u0015aX\u00021\u0001_\u0003%!\u0018.\\3ti\u0006l\u0007\u000f")
public class SseConnectingState
extends SseState
implements StrictLogging {
    private final SseFsm fsm;
    private final Session session;
    private final Action next;
    private final long connectStart;
    private final Logger logger;

    public static NextSseState gotoConnecting(SseFsm sseFsm, Session session, Action action) {
        return SseConnectingState$.MODULE$.gotoConnecting(sseFsm, session, action);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NextSseState onSseStreamConnected(long connectEnd) {
        BoxedUnit boxedUnit;
        Session sessionWithGroupTimings = this.logResponse(this.session, this.fsm.connectActionName(), this.connectStart, connectEnd, (Status)OK$.MODULE$, (Option<String>)SseConnectingState$.MODULE$.io$gatling$http$action$sse$fsm$SseConnectingState$$SseConnectSuccessStatusCode(), (Option<String>)None$.MODULE$);
        List<SseMessageCheckSequence> list = this.fsm.connectCheckSequence();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            SseMessageCheckSequence sseMessageCheckSequence = (SseMessageCheckSequence)colon2.head();
            List remainingCheckSequences = colon2.tl$access$1();
            if (sseMessageCheckSequence != null) {
                FiniteDuration timeout = sseMessageCheckSequence.timeout();
                List<SseMessageCheck> list2 = sseMessageCheckSequence.checks();
                if (list2 instanceof .colon.colon) {
                    BoxedUnit boxedUnit2;
                    .colon.colon colon3 = (.colon.colon)list2;
                    SseMessageCheck currentCheck = (SseMessageCheck)colon3.head();
                    List remainingChecks = colon3.tl$access$1();
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Connected, performing checks before proceeding");
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    this.fsm.scheduleTimeout(timeout);
                    return new NextSseState(new SsePerformingCheckState(this.fsm, currentCheck, (List<SseMessageCheck>)remainingChecks, connectEnd, (List<SseMessageCheckSequence>)remainingCheckSequences, sessionWithGroupTimings, this.next), NextSseState$.MODULE$.apply$default$2());
                }
            }
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Connected, no checks, performing next action");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.next.$bang(sessionWithGroupTimings);
        return new NextSseState(new SseIdleState(this.fsm, sessionWithGroupTimings), NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onSseStreamCrashed(Throwable t, long timestamp) {
        BoxedUnit boxedUnit;
        String error = Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(t));
        Session newSession = this.logResponse(this.session, this.fsm.connectActionName(), this.connectStart, timestamp, (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)error));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Connect failed: {}, going to Crashed state and performing next action", new Object[]{error});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextSseState(new SseCrashedState(this.fsm.statsEngine(), error), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.next.$bang(newSession.markAsFailed()));
    }

    public SseConnectingState(SseFsm fsm, Session session, Action next, long connectStart) {
        this.fsm = fsm;
        this.session = session;
        this.next = next;
        this.connectStart = connectStart;
        super(fsm);
        StrictLogging.$init$((StrictLogging)this);
    }
}

