/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.util.NameGen;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.engine.response.Crash;
import io.gatling.http.engine.response.NextExecutor;
import io.gatling.http.engine.response.Proceed;
import io.gatling.http.engine.response.ProcessorResult;
import io.gatling.http.engine.response.Redirect;
import io.gatling.http.engine.response.RedirectProcessor$;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.response.SessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0007\u000f\u0001eA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\"B*\u0001\t\u0003!\u0006\"B.\u0001\t\u0003a\u0006\"B4\u0001\t\u0013A\u0007\"\u00028\u0001\t\u0013y\u0007\"B;\u0001\t\u00131\b\"\u0002?\u0001\t\u0013i\bbBA\b\u0001\u0011%\u0011\u0011\u0003\u0002\u0019\t\u00164\u0017-\u001e7u%\u0016\u001c\bo\u001c8tKB\u0013xnY3tg>\u0014(BA\b\u0011\u0003!\u0011Xm\u001d9p]N,'BA\t\u0013\u0003\u0019)gnZ5oK*\u00111\u0003F\u0001\u0005QR$\bO\u0003\u0002\u0016-\u00059q-\u0019;mS:<'\"A\f\u0002\u0005%|7\u0001A\n\u0006\u0001i\u0001CE\f\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0012S\"\u0001\b\n\u0005\rr!!\u0005*fgB|gn]3Qe>\u001cWm]:peB\u0011Q\u0005L\u0007\u0002M)\u0011q\u0005K\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003S)\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002W\u0005\u00191m\\7\n\u000552#a\u0003'bufdunZ4j]\u001e\u0004\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0003gQ\tAaY8sK&\u0011Q\u0007\r\u0002\b\u001d\u0006lWmR3o\u0003\t!\b\u0010\u0005\u00029u5\t\u0011H\u0003\u00027!%\u00111(\u000f\u0002\u0007\u0011R$\b\u000f\u0016=\u0002!M,7o]5p]B\u0013xnY3tg>\u0014\bCA\u0011?\u0013\tydB\u0001\tTKN\u001c\u0018n\u001c8Qe>\u001cWm]:pe\u0006q1\u000f^1ugB\u0013xnY3tg>\u0014\bCA\u0011C\u0013\t\u0019eB\u0001\bTi\u0006$8\u000f\u0015:pG\u0016\u001c8o\u001c:\u0002\u00199,\u0007\u0010^#yK\u000e,Ho\u001c:\u0011\u0005\u00052\u0015BA$\u000f\u00051qU\r\u001f;Fq\u0016\u001cW\u000f^8s\u00039!WMZ1vYR\u001c\u0005.\u0019:tKR\u0004\"AS)\u000e\u0003-S!\u0001T'\u0002\u000f\rD\u0017M]:fi*\u0011ajT\u0001\u0004]&|'\"\u0001)\u0002\t)\fg/Y\u0005\u0003%.\u0013qa\u00115beN,G/\u0001\u0004=S:LGO\u0010\u000b\u0007+Z;\u0006,\u0017.\u0011\u0005\u0005\u0002\u0001\"\u0002\u001c\u0007\u0001\u00049\u0004\"\u0002\u001f\u0007\u0001\u0004i\u0004\"\u0002!\u0007\u0001\u0004\t\u0005\"\u0002#\u0007\u0001\u0004)\u0005\"\u0002%\u0007\u0001\u0004I\u0015AC8o\u0007>l\u0007\u000f\\3uKR\u0011Q\f\u0019\t\u00037yK!a\u0018\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006C\u001e\u0001\rAY\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0005\r,W\"\u00013\u000b\u0005=\u0011\u0012B\u00014e\u0005)AE\u000f\u001e9SKN,H\u000e^\u0001\u000eQ\u0006tG\r\\3GC&dWO]3\u0015\u0005uK\u0007\"\u00026\t\u0001\u0004Y\u0017a\u00024bS2,(/\u001a\t\u0003G2L!!\u001c3\u0003\u0017!#H\u000f\u001d$bS2,(/Z\u0001\u000fQ\u0006tG\r\\3SKN\u0004xN\\:f)\ti\u0006\u000fC\u0003r\u0013\u0001\u0007!/A\u0006sC^\u0014Vm\u001d9p]N,\u0007CA2t\u0013\t!HM\u0001\u0005SKN\u0004xN\\:f\u0003\u001d\u0001(o\\2fK\u0012$2!X<y\u0011\u0015y!\u00021\u0001s\u0011\u0015\t'\u00021\u0001z!\t\t#0\u0003\u0002|\u001d\ty\u0001K]8dKN\u001cxN\u001d*fgVdG/\u0001\rbaBd\u0017PU3ta>t7/\u001a+sC:\u001chm\u001c:nKJ$2A`A\u0007!\u0011y\u0018\u0011\u0002:\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\t!B^1mS\u0012\fG/[8o\u0015\r\t9\u0001F\u0001\bG>lWn\u001c8t\u0013\u0011\tY!!\u0001\u0003\u0015Y\u000bG.\u001b3bi&|g\u000eC\u0003r\u0017\u0001\u0007!/A\bqe>\u001cWm]:SKN\u0004xN\\:f)\rI\u00181\u0003\u0005\u0006\u001f1\u0001\rA\u001d")
public class DefaultResponseProcessor
implements ResponseProcessor,
LazyLogging,
NameGen {
    private final HttpTx tx;
    private final SessionProcessor sessionProcessor;
    private final StatsProcessor statsProcessor;
    private final NextExecutor nextExecutor;
    private final Charset defaultCharset;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    private Logger logger$lzycompute() {
        DefaultResponseProcessor defaultResponseProcessor = this;
        synchronized (defaultResponseProcessor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public void onComplete(HttpResult result) {
        HttpResult httpResult = result;
        if (httpResult instanceof Response) {
            Response response = (Response)httpResult;
            this.handleResponse(response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (httpResult instanceof HttpFailure) {
            HttpFailure httpFailure = (HttpFailure)httpResult;
            this.handleFailure(httpFailure);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)httpResult);
        }
    }

    private void handleFailure(HttpFailure failure) {
        block8: {
            Session sessionWithUpdatedStats = this.sessionProcessor.updateSessionCrashed(this.tx.currentSession(), failure.startTimestamp(), failure.endTimestamp());
            try {
                try {
                    this.statsProcessor.reportStats(this.tx.fullRequestName(), sessionWithUpdatedStats, (Status)KO$.MODULE$, failure, (Option<String>)new Some((Object)failure.errorMessage()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable t = (Throwable)option.get();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(new StringBuilder(84).append("ResponseProcessor crashed while handling failure ").append(failure).append(" on session=").append(this.tx.currentSession()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break block8;
                    }
                    throw throwable;
                }
            }
            finally {
                this.nextExecutor.executeNextOnCrash(sessionWithUpdatedStats);
            }
        }
    }

    private void handleResponse(Response rawResponse) {
        Validation<Response> validation = this.applyResponseTransformer(rawResponse);
        if (validation instanceof Failure) {
            Failure failure = (Failure)validation;
            String errorMessage = failure.message();
            this.proceed(rawResponse, new Crash(errorMessage));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (validation instanceof Success) {
            Success success = (Success)validation;
            Response response = (Response)success.value();
            this.proceed(response, this.processResponse(response));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(validation);
        }
    }

    private void proceed(Response response, ProcessorResult result) {
        ProcessorResult processorResult = result;
        if (processorResult instanceof Proceed) {
            Proceed proceed = (Proceed)processorResult;
            Session newSession = proceed.newSession();
            Option<String> errorMessage = proceed.error();
            KO$ status = errorMessage.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
            this.statsProcessor.reportStats(this.tx.fullRequestName(), newSession, (Status)status, response, errorMessage);
            this.nextExecutor.executeNext(newSession, (Status)status, response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (processorResult instanceof Redirect) {
            Redirect redirect = (Redirect)processorResult;
            HttpTx redirectTx = redirect.redirectTx();
            this.statsProcessor.reportStats(this.tx.fullRequestName(), redirectTx.currentSession(), (Status)OK$.MODULE$, response, (Option<String>)None$.MODULE$);
            this.nextExecutor.executeRedirect(redirectTx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (processorResult instanceof Crash) {
            Crash crash = (Crash)processorResult;
            String errorMessage = crash.error();
            Session newSession = this.sessionProcessor.updateSessionCrashed(this.tx.currentSession(), response.startTimestamp(), response.endTimestamp());
            this.statsProcessor.reportStats(this.tx.fullRequestName(), newSession, (Status)KO$.MODULE$, response, (Option<String>)new Some((Object)errorMessage));
            this.nextExecutor.executeNextOnCrash(newSession);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)processorResult);
        }
    }

    private Validation<Response> applyResponseTransformer(Response rawResponse) {
        Validation validation;
        Option<Function2<Session, Response, Validation<Response>>> option = this.tx.request().requestConfig().responseTransformer();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function2 transformer = (Function2)some.value();
            validation = package$.MODULE$.safely((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(30).append("Response transformer crashed: ").append((String)x$1).toString(), (Function0 & Serializable & scala.Serializable)() -> (Validation)transformer.apply((Object)$this.tx.currentSession(), (Object)rawResponse));
        } else {
            validation = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)rawResponse));
        }
        return validation;
    }

    private ProcessorResult processResponse(Response response) {
        ProcessorResult processorResult;
        block14: {
            try {
                if (HttpHelper$.MODULE$.isRedirect(response.status()) && this.tx.request().requestConfig().followRedirect()) {
                    String location = response.headers().get((CharSequence)HttpHeaderNames.LOCATION);
                    if (location == null) {
                        processorResult = new Crash("Redirect status, yet no Location header");
                    } else {
                        ProcessorResult processorResult2;
                        Uri redirectUri = HttpHelper$.MODULE$.resolveFromUri(this.tx.request().clientRequest().getUri(), location);
                        Session newSession = this.sessionProcessor.updatedRedirectSession(this.tx.currentSession(), response, redirectUri);
                        Validation<Request> validation = RedirectProcessor$.MODULE$.redirectRequest(this.tx.request().clientRequest(), newSession, response.status(), this.tx.request().requestConfig().httpProtocol(), redirectUri, this.defaultCharset);
                        if (validation instanceof Success) {
                            Success success = (Success)validation;
                            Request redirectRequest = (Request)success.value();
                            Session x$4 = newSession;
                            Request x$1 = redirectRequest;
                            String x$2 = this.tx.request().copy$default$1();
                            HttpRequestConfig x$3 = this.tx.request().copy$default$3();
                            HttpRequest x$5 = this.tx.request().copy(x$2, x$1, x$3);
                            int x$6 = this.tx.redirectCount() + 1;
                            Action x$7 = this.tx.copy$default$3();
                            Option<ResourceTx> x$8 = this.tx.copy$default$4();
                            processorResult2 = new Redirect(this.tx.copy(x$4, x$5, x$7, x$8, x$6));
                        } else if (validation instanceof Failure) {
                            Failure failure = (Failure)validation;
                            String message = failure.message();
                            processorResult2 = new Crash(message);
                        } else {
                            throw new MatchError(validation);
                        }
                        processorResult = processorResult2;
                    }
                    break block14;
                }
                Tuple2<Session, Option<String>> tuple2 = this.sessionProcessor.updatedSession(this.tx.currentSession(), response);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Session newSession = (Session)tuple2._1();
                Option errorMessage = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)newSession, (Object)errorMessage);
                Tuple2 tuple23 = tuple22;
                Session newSession2 = (Session)tuple23._1();
                Option errorMessage2 = (Option)tuple23._2();
                processorResult = new Proceed(newSession2, (Option<String>)errorMessage2);
            }
            catch (Throwable throwable) {
                Throwable t;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    t = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(85).append("ResponseProcessor crashed while handling response ").append(response.status()).append(" on session=").append(this.tx.currentSession()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                Crash crash = new Crash(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
                processorResult = crash;
            }
        }
        return processorResult;
    }

    public DefaultResponseProcessor(HttpTx tx, SessionProcessor sessionProcessor, StatsProcessor statsProcessor, NextExecutor nextExecutor, Charset defaultCharset) {
        this.tx = tx;
        this.sessionProcessor = sessionProcessor;
        this.statsProcessor = statsProcessor;
        this.nextExecutor = nextExecutor;
        this.defaultCharset = defaultCharset;
        LazyLogging.$init$((LazyLogging)this);
        NameGen.$init$((NameGen)this);
    }
}

