/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.core.session.Session;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.check.HttpCheck;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.cookie.CookieSupport$;
import io.gatling.http.engine.response.CheckProcessor$;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055d!B\b\u0011\u0003CY\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001dB\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u0002H\u0001!I!!\u0013\t\u000f\u0005E\u0003A\"\u0005\u0002T!9\u0011\u0011\f\u0001\u0007\u0012\u0005m#\u0001E*fgNLwN\u001c)s_\u000e,7o]8s\u0015\t\t\"#\u0001\u0005sKN\u0004xN\\:f\u0015\t\u0019B#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003+Y\tA\u0001\u001b;ua*\u0011q\u0003G\u0001\bO\u0006$H.\u001b8h\u0015\u0005I\u0012AA5p\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0019\u0018\u000e\\3oiB\u0011Q\u0004J\u0005\u0003Ky\u0011qAQ8pY\u0016\fg.A\u0004sKF,Xm\u001d;\u0011\u0005!ZS\"A\u0015\u000b\u0005)\"\u0012AB2mS\u0016tG/\u0003\u0002-S\t9!+Z9vKN$\u0018AB2iK\u000e\\7\u000fE\u00020oir!\u0001M\u001b\u000f\u0005E\"T\"\u0001\u001a\u000b\u0005MR\u0012A\u0002\u001fs_>$h(C\u0001 \u0013\t1d$A\u0004qC\u000e\\\u0017mZ3\n\u0005aJ$\u0001\u0002'jgRT!A\u000e\u0010\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u\"\u0012!B2iK\u000e\\\u0017BA =\u0005%AE\u000f\u001e9DQ\u0016\u001c7.\u0001\u0006iiR\u00048)Y2iKN\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u000b\u0002\u000b\r\f7\r[3\n\u0005\u0019\u001b%A\u0003%uiB\u001c\u0015m\u00195fg\u0006a\u0001\u000e\u001e;q!J|Go\\2pYB\u0011\u0011\nT\u0007\u0002\u0015*\u00111\nF\u0001\taJ|Go\\2pY&\u0011QJ\u0013\u0002\r\u0011R$\b\u000f\u0015:pi>\u001cw\u000e\\\u0001\u0006G2|7m\u001b\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000bA!\u001e;jY*\u0011AKF\u0001\bG>lWn\u001c8t\u0013\t1\u0016KA\u0003DY>\u001c7.\u0001\u0004=S:LGO\u0010\u000b\b3ncVLX0a!\tQ\u0006!D\u0001\u0011\u0011\u0015\u0011s\u00011\u0001$\u0011\u00151s\u00011\u0001(\u0011\u0015is\u00011\u0001/\u0011\u0015\u0001u\u00011\u0001B\u0011\u00159u\u00011\u0001I\u0011\u0015qu\u00011\u0001P\u0003Q)\b\u000fZ1uKN+7o]5p]\u000e\u0013\u0018m\u001d5fIR!1m\u001b7r!\t!\u0017.D\u0001f\u0015\t1w-A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005!4\u0012\u0001B2pe\u0016L!A[3\u0003\u000fM+7o]5p]\")a\r\u0003a\u0001G\")Q\u000e\u0003a\u0001]\u0006q1\u000f^1siRKW.Z:uC6\u0004\bCA\u000fp\u0013\t\u0001hD\u0001\u0003M_:<\u0007\"\u0002:\t\u0001\u0004q\u0017\u0001D3oIRKW.Z:uC6\u0004\u0018AE;qI\u0006$XmU3tg&|gn\u0015;biN$RaY;wobDQAZ\u0005A\u0002\rDQ!\\\u0005A\u00029DQA]\u0005A\u00029DQ!_\u0005A\u0002i\faa\u001d;biV\u001c\bCA>\u007f\u001b\u0005a(BA?T\u0003\u0015\u0019H/\u0019;t\u0013\tyHP\u0001\u0004Ti\u0006$Xo]\u0001\u000fkB$\u0017\r^3e'\u0016\u001c8/[8o)\u0019\t)!!\t\u0002$A1Q$a\u0002d\u0003\u0017I1!!\u0003\u001f\u0005\u0019!V\u000f\u001d7feA)Q$!\u0004\u0002\u0012%\u0019\u0011q\u0002\u0010\u0003\r=\u0003H/[8o!\u0011\t\u0019\"a\u0007\u000f\t\u0005U\u0011q\u0003\t\u0003cyI1!!\u0007\u001f\u0003\u0019\u0001&/\u001a3fM&!\u0011QDA\u0010\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0004\u0010\t\u000b\u0019T\u0001\u0019A2\t\rEQ\u0001\u0019AA\u0013!\u0011\t9#a\u000b\u000e\u0005\u0005%\"BA\t\u0015\u0013\u0011\ti#!\u000b\u0003\u0011I+7\u000f]8og\u0016\fa#\u001e9eCR,GMU3eSJ,7\r^*fgNLwN\u001c\u000b\bG\u0006M\u0012QGA\u001c\u0011\u001517\u00021\u0001d\u0011\u0019\t2\u00021\u0001\u0002&!9\u0011\u0011H\u0006A\u0002\u0005m\u0012a\u0003:fI&\u0014Xm\u0019;Ve&\u0004B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003J\u0013aA;sS&!\u0011QIA \u0005\r)&/[\u0001\u000eG\u0006\u001c\u0007.\u001a*fI&\u0014Xm\u0019;\u0015\u000f\r\fY%!\u0014\u0002P!)a\r\u0004a\u0001G\"1\u0011\u0003\u0004a\u0001\u0003KAq!!\u000f\r\u0001\u0004\tY$A\u0007va\u0012\fG/\u001a*fM\u0016\u0014XM\u001d\u000b\u0006G\u0006U\u0013q\u000b\u0005\u0006M6\u0001\ra\u0019\u0005\u0007#5\u0001\r!!\n\u00023U\u0004H-\u0019;f\u000fJ|W\u000f\u001d*fcV,7\u000f\u001e+j[&twm\u001d\u000b\bG\u0006u\u0013qLA1\u0011\u00151g\u00021\u0001d\u0011\u0015ig\u00021\u0001o\u0011\u0015\u0011h\u00021\u0001oS\u0015\u0001\u0011QMA5\u0013\r\t9\u0007\u0005\u0002\u0019%\u0016\u001cx.\u001e:dKN+7o]5p]B\u0013xnY3tg>\u0014\u0018bAA6!\t!\"k\\8u'\u0016\u001c8/[8o!J|7-Z:t_J\u0004")
public abstract class SessionProcessor {
    private final boolean silent;
    private final Request request;
    private final List<HttpCheck> checks;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final Clock clock;

    public Session updateSessionCrashed(Session session, long startTimestamp, long endTimestamp) {
        return this.updateSessionStats(session, startTimestamp, endTimestamp, (Status)KO$.MODULE$);
    }

    private Session updateSessionStats(Session session, long startTimestamp, long endTimestamp, Status status) {
        Session session2;
        if (this.silent) {
            session2 = session;
        } else {
            Status status2 = status;
            KO$ kO$ = KO$.MODULE$;
            Session sessionWithUpdatedStatus = !(status2 != null ? !status2.equals(kO$) : kO$ != null) ? session.markAsFailed() : session;
            session2 = this.updateGroupRequestTimings(sessionWithUpdatedStatus, startTimestamp, endTimestamp);
        }
        return session2;
    }

    public Tuple2<Session, Option<String>> updatedSession(Session session, Response response) {
        Tuple2<Session, Option<Failure>> tuple2 = CheckProcessor$.MODULE$.check(session, response, this.checks);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Session sessionWithCheckSavedValues = (Session)tuple2._1();
        Option checkError = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sessionWithCheckSavedValues, (Object)checkError);
        Tuple2 tuple23 = tuple22;
        Session sessionWithCheckSavedValues2 = (Session)tuple23._1();
        Option checkError2 = (Option)tuple23._2();
        Session sessionWithHttp2PriorKnowledge = this.httpProtocol.enginePart().enableHttp2() ? Http2PriorKnowledgeSupport$.MODULE$.updateSessionHttp2PriorKnowledge(sessionWithCheckSavedValues2, response) : sessionWithCheckSavedValues2;
        KO$ newStatus = checkError2.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
        Session newSession = this.updateSessionAfterChecks$1(sessionWithHttp2PriorKnowledge, (Status)newStatus, response);
        return new Tuple2((Object)newSession, (Object)checkError2.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.message()));
    }

    public Session updatedRedirectSession(Session session, Response response, Uri redirectUri) {
        Session sessionWithCookieStoreUpdate = CookieSupport$.MODULE$.storeCookies(session, this.request.getUri(), response.cookies(), this.clock.nowMillis());
        Session sessionWithGroupUpdate = this.updateSessionStats(sessionWithCookieStoreUpdate, response.startTimestamp(), response.endTimestamp(), (Status)OK$.MODULE$);
        return this.cacheRedirect(sessionWithGroupUpdate, response, redirectUri);
    }

    private Session cacheRedirect(Session session, Response response, Uri redirectUri) {
        return this.httpProtocol.requestPart().cache() && HttpHelper$.MODULE$.isPermanentRedirect(response.status()) ? this.httpCaches.addRedirect(session, this.request, redirectUri) : session;
    }

    public abstract Session updateReferer(Session var1, Response var2);

    public abstract Session updateGroupRequestTimings(Session var1, long var2, long var4);

    private final Session updateSessionAfterChecks$1(Session s1, Status status, Response response$1) {
        Session s2 = CookieSupport$.MODULE$.storeCookies(s1, this.request.getUri(), response$1.cookies(), this.clock.nowMillis());
        Session s3 = this.updateReferer(s2, response$1);
        Session s4 = this.httpCaches.cacheContent(s3, this.httpProtocol, this.request, response$1.headers());
        return this.updateSessionStats(s4, response$1.startTimestamp(), response$1.endTimestamp(), status);
    }

    public SessionProcessor(boolean silent, Request request, List<HttpCheck> checks, HttpCaches httpCaches, HttpProtocol httpProtocol, Clock clock) {
        this.silent = silent;
        this.request = request;
        this.checks = checks;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.clock = clock;
    }
}

