/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.tx;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.CoreComponents;
import io.gatling.core.controller.throttle.Throttler;
import io.gatling.core.session.Session;
import io.gatling.core.util.NameGen;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.cache.SslContextSupport$;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.Pair;
import io.gatling.http.engine.GatlingHttpListener;
import io.gatling.http.engine.HttpEngine;
import io.gatling.http.engine.response.DefaultResponseProcessor;
import io.gatling.http.engine.response.DefaultStatsProcessor;
import io.gatling.http.engine.response.NoopStatsProcessor;
import io.gatling.http.engine.response.ResourceNextExecutor;
import io.gatling.http.engine.response.ResourceSessionProcessor;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.response.RootNextExecutor;
import io.gatling.http.engine.response.RootSessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.fetch.ResourceAggregator;
import io.gatling.http.fetch.ResourceFetcher;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.util.SslContexts;
import io.netty.handler.ssl.SslContext;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\f\u0018\u0001\tB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0019\u0006A!A!\u0002\u0013!\u0006\"\u0002.\u0001\t\u0003Y\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B3\t\u000f%\u0004!\u0019!C\u0005U\"1\u0011\u000f\u0001Q\u0001\n-DQA\u001d\u0001\u0005\nMDq!!\u0002\u0001\t\u0013\t9\u0001C\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005-\u0002\u0001\"\u0001\u00022!9\u00111\u0006\u0001\u0005\u0002\u0005U\u0002bBA\u0016\u0001\u0011\u0005\u0011Q\t\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003\u0017B\u0001\"!\u0014\u0001A\u0003%\u0011Q\b\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!!\u001a\u0001\t\u0003\t9G\u0001\bIiR\u0004H\u000b_#yK\u000e,Ho\u001c:\u000b\u0005aI\u0012A\u0001;y\u0015\tQ2$\u0001\u0004f]\u001eLg.\u001a\u0006\u00039u\tA\u0001\u001b;ua*\u0011adH\u0001\bO\u0006$H.\u001b8h\u0015\u0005\u0001\u0013AA5p\u0007\u0001\u0019B\u0001A\u0012*cA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\tU$\u0018\u000e\u001c\u0006\u0003]u\tAaY8sK&\u0011\u0001g\u000b\u0002\b\u001d\u0006lWmR3o!\t\u0011\u0014(D\u00014\u0015\t!T'\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00027o\u0005AA/\u001f9fg\u00064WMC\u00019\u0003\r\u0019w.\\\u0005\u0003uM\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0017AD2pe\u0016\u001cu.\u001c9p]\u0016tGo\u001d\t\u0003{yj\u0011!L\u0005\u0003\u007f5\u0012abQ8sK\u000e{W\u000e]8oK:$8/\u0001\u0006iiR\u0004XI\\4j]\u0016\u0004\"AQ\"\u000e\u0003eI!\u0001R\r\u0003\u0015!#H\u000f]#oO&tW-\u0001\u0006iiR\u00048)Y2iKN\u0004\"a\u0012&\u000e\u0003!S!!S\u000e\u0002\u000b\r\f7\r[3\n\u0005-C%A\u0003%uiB\u001c\u0015m\u00195fg\u0006)B-\u001a4bk2$8\u000b^1ugB\u0013xnY3tg>\u0014\bC\u0001(R\u001b\u0005y%B\u0001)\u001a\u0003!\u0011Xm\u001d9p]N,\u0017B\u0001*P\u0005U!UMZ1vYR\u001cF/\u0019;t!J|7-Z:t_J\fA\u0002\u001b;uaB\u0013x\u000e^8d_2\u0004\"!\u0016-\u000e\u0003YS!aV\u000e\u0002\u0011A\u0014x\u000e^8d_2L!!\u0017,\u0003\u0019!#H\u000f\u001d)s_R|7m\u001c7\u0002\rqJg.\u001b;?)\u0019afl\u00181bEB\u0011Q\fA\u0007\u0002/!)1H\u0002a\u0001y!)\u0001I\u0002a\u0001\u0003\")QI\u0002a\u0001\r\")AJ\u0002a\u0001\u001b\")1K\u0002a\u0001)\u0006\u0011bn\\8q'R\fGo\u001d)s_\u000e,7o]8s+\u0005)\u0007C\u0001(g\u0013\t9wJ\u0001\nO_>\u00048\u000b^1ugB\u0013xnY3tg>\u0014\u0018a\u00058p_B\u001cF/\u0019;t!J|7-Z:t_J\u0004\u0013a\u0004:fg>,(oY3GKR\u001c\u0007.\u001a:\u0016\u0003-\u0004\"\u0001\\8\u000e\u00035T!A\\\u000e\u0002\u000b\u0019,Go\u00195\n\u0005Al'a\u0004*fg>,(oY3GKR\u001c\u0007.\u001a:\u0002!I,7o\\;sG\u00164U\r^2iKJ\u0004\u0013\u0001E3yK\u000e,H/Z,ji\"\u001c\u0015m\u00195f)\r!\u0018\u0011\u0001\u000b\u0003kb\u0004\"\u0001\n<\n\u0005],#\u0001B+oSRDQ!_\u0006A\u0002i\f\u0011A\u001a\t\u0005ImlX/\u0003\u0002}K\tIa)\u001e8di&|g.\r\t\u0003;zL!a`\f\u0003\r!#H\u000f\u001d+y\u0011\u0019\t\u0019a\u0003a\u0001{\u00061qN]5h)b\fQ#\u001a=fGV$X\r\u0013;uaJ:\u0016\u000e\u001e5DC\u000eDW\r\u0006\u0003\u0002\n\u0005\u001dBcA;\u0002\f!1\u0011\u0010\u0004a\u0001\u0003\u001b\u0001R\u0001J>\u0002\u0010U\u0004R!!\u0005\u0002\"utA!a\u0005\u0002\u001e9!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0005\na\u0001\u0010:p_Rt\u0014\"\u0001\u0014\n\u0007\u0005}Q%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0012Q\u0005\u0002\t\u0013R,'/\u00192mK*\u0019\u0011qD\u0013\t\u000f\u0005%B\u00021\u0001\u0002\u0010\u00059qN]5h)b\u001c\u0018aB3yK\u000e,H/\u001a\u000b\u0004k\u0006=\u0002BBA\u0002\u001b\u0001\u0007Q\u0010F\u0002v\u0003gAq!!\u000b\u000f\u0001\u0004\ty\u0001F\u0003v\u0003o\tI\u0004\u0003\u0004\u0002\u0004=\u0001\r! \u0005\b\u0003wy\u0001\u0019AA\u001f\u0003a\u0011Xm\u001d9p]N,\u0007K]8dKN\u001cxN\u001d$bGR|'/\u001f\t\u0006Iml\u0018q\b\t\u0004\u001d\u0006\u0005\u0013bAA\"\u001f\n\t\"+Z:q_:\u001cX\r\u0015:pG\u0016\u001c8o\u001c:\u0015\u000bU\f9%!\u0013\t\u000f\u0005%\u0002\u00031\u0001\u0002\u0010!9\u00111\b\tA\u0002\u0005uRCAA\u001f\u0003e\u0011Xm\u001d9p]N,\u0007K]8dKN\u001cxN\u001d$bGR|'/\u001f\u0011\u000219,wOU8piJ+7\u000f]8og\u0016\u0004&o\\2fgN|'\u000f\u0006\u0003\u0002@\u0005M\u0003\"\u0002\r\u0014\u0001\u0004i\u0018\u0001\b8foJ+7o\\;sG\u0016\u0014Vm\u001d9p]N,\u0007K]8dKN\u001cxN\u001d\u000b\u0007\u0003\u007f\tI&a\u0017\t\u000ba!\u0002\u0019A?\t\u000f\u0005uC\u00031\u0001\u0002`\u0005Q!/Z:pkJ\u001cW\r\u0016=\u0011\u0007u\u000b\t'C\u0002\u0002d]\u0011!BU3t_V\u00148-\u001a+y\u00039\u0019H/\u0019;t!J|7-Z:t_J$B!!\u001b\u0002pA\u0019a*a\u001b\n\u0007\u00055tJ\u0001\bTi\u0006$8\u000f\u0015:pG\u0016\u001c8o\u001c:\t\u000ba)\u0002\u0019A?")
public class HttpTxExecutor
implements NameGen,
StrictLogging {
    private final CoreComponents coreComponents;
    private final HttpEngine httpEngine;
    private final HttpCaches httpCaches;
    private final DefaultStatsProcessor defaultStatsProcessor;
    private final HttpProtocol httpProtocol;
    private final NoopStatsProcessor noopStatsProcessor;
    private final ResourceFetcher resourceFetcher;
    private final Function1<HttpTx, ResponseProcessor> responseProcessorFactory;
    private final Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private NoopStatsProcessor noopStatsProcessor() {
        return this.noopStatsProcessor;
    }

    private ResourceFetcher resourceFetcher() {
        return this.resourceFetcher;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void executeWithCache(HttpTx origTx, Function1<HttpTx, BoxedUnit> f) {
        Option<ResourceAggregator> option;
        Option<Object> option2;
        Some some;
        ContentCacheEntry contentCacheEntry;
        Option<Object> option3;
        Some some2;
        ContentCacheEntry contentCacheEntry2;
        HttpTx tx = this.httpCaches.applyPermanentRedirect(origTx);
        Request clientRequest = tx.request().clientRequest();
        Uri uri = clientRequest.getUri();
        Option<ContentCacheEntry> option4 = this.httpCaches.contentCacheEntry(tx.session(), clientRequest);
        boolean bl = None$.MODULE$.equals(option4) ? true : option4 instanceof Some && (contentCacheEntry2 = (ContentCacheEntry)(some2 = (Some)option4).value()) != null && None$.MODULE$.equals(option3 = contentCacheEntry2.expires());
        if (bl) {
            BoxedUnit boxedUnit = (BoxedUnit)f.apply((Object)tx);
            return;
        }
        if (option4 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option4).value()) != null && (option2 = contentCacheEntry.expires()) instanceof Some) {
            Some some3 = (Some)option2;
            long expire = BoxesRunTime.unboxToLong((Object)some3.value());
            if (this.coreComponents.clock().nowMillis() > expire) {
                HttpTx newTx = tx.copy(this.httpCaches.clearContentCache(tx.session(), clientRequest), tx.copy$default$2(), tx.copy$default$3(), tx.copy$default$4(), tx.copy$default$5());
                BoxedUnit boxedUnit = (BoxedUnit)f.apply((Object)newTx);
                return;
            }
        }
        if ((option = this.resourceFetcher().newResourceAggregatorForCachedPage(tx)) instanceof Some) {
            BoxedUnit boxedUnit;
            Some some4 = (Some)option;
            ResourceAggregator aggregator = (ResourceAggregator)some4.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Fetching resources of cached page request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), uri, tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            aggregator.start(tx.session());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            Some some5;
            ResourceTx resourceTx;
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Skipping cached request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), uri, tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option<ResourceTx> option5 = tx.resourceTx();
            if (option5 instanceof Some && (resourceTx = (ResourceTx)(some5 = (Some)option5).value()) != null) {
                ResourceAggregator aggregator = resourceTx.aggregator();
                aggregator.onCachedResource(uri, tx);
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else {
                tx.next().$bang(tx.session());
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void executeHttp2WithCache(Iterable<HttpTx> origTxs, Function1<Iterable<HttpTx>, BoxedUnit> f) {
        ListBuffer cached = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer nonCached = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef session = ObjectRef.create((Object)((HttpTx)origTxs.head()).session());
        origTxs.foreach((Function1 & Serializable & scala.Serializable)tx -> {
            Option<Object> option;
            Some some;
            ContentCacheEntry contentCacheEntry;
            HttpTx updatedTx = $this.httpCaches.applyPermanentRedirect((HttpTx)tx);
            Option<ContentCacheEntry> txCacheEntry = $this.httpCaches.contentCacheEntry(updatedTx.session(), updatedTx.request().clientRequest());
            Option<ContentCacheEntry> option2 = txCacheEntry;
            boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && (contentCacheEntry = (ContentCacheEntry)(some = (Some)option2).value()) != null && None$.MODULE$.equals(option = contentCacheEntry.expires());
            if (bl) {
                return nonCached.$plus$eq((Object)updatedTx);
            }
            if (!(option2 instanceof Some)) return cached.$plus$eq((Object)updatedTx);
            Some some2 = (Some)option2;
            ContentCacheEntry contentCacheEntry2 = (ContentCacheEntry)some2.value();
            if (contentCacheEntry2 == null) return cached.$plus$eq((Object)updatedTx);
            Option<Object> option3 = contentCacheEntry2.expires();
            if (!(option3 instanceof Some)) return cached.$plus$eq((Object)updatedTx);
            Some some3 = (Some)option3;
            long expire = BoxesRunTime.unboxToLong((Object)some3.value());
            if ($this.coreComponents.clock().nowMillis() <= expire) return cached.$plus$eq((Object)updatedTx);
            Request requestToClean = updatedTx.request().clientRequest();
            session$1.elem = $this.httpCaches.clearContentCache((Session)session$1.elem, requestToClean);
            return nonCached.$plus$eq((Object)updatedTx);
        });
        f.apply(nonCached.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.copy((Session)session$1.elem, x$1.copy$default$2(), x$1.copy$default$3(), x$1.copy$default$4(), x$1.copy$default$5()), ListBuffer$.MODULE$.canBuildFrom()));
        ((TraversableForwarder)cached.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.copy((Session)session$1.elem, x$2.copy$default$2(), x$2.copy$default$3(), x$2.copy$default$4(), x$2.copy$default$5()), ListBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)tx -> {
            HttpTxExecutor.$anonfun$executeHttp2WithCache$4(this, tx);
            return BoxedUnit.UNIT;
        });
    }

    public void execute(HttpTx origTx) {
        this.execute(origTx, this.responseProcessorFactory());
    }

    public void execute(Iterable<HttpTx> origTxs) {
        this.execute(origTxs, this.responseProcessorFactory());
    }

    public void execute(HttpTx origTx, Function1<HttpTx, ResponseProcessor> responseProcessorFactory) {
        this.executeWithCache(origTx, (Function1<HttpTx, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tx -> {
            HttpTxExecutor.$anonfun$execute$1(this, responseProcessorFactory, tx);
            return BoxedUnit.UNIT;
        });
    }

    public void execute(Iterable<HttpTx> origTxs, Function1<HttpTx, ResponseProcessor> responseProcessorFactory) {
        this.executeHttp2WithCache(origTxs, (Function1<Iterable<HttpTx>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)txs -> {
            HttpTxExecutor.$anonfun$execute$5(this, responseProcessorFactory, txs);
            return BoxedUnit.UNIT;
        });
    }

    private Function1<HttpTx, ResponseProcessor> responseProcessorFactory() {
        return this.responseProcessorFactory;
    }

    private ResponseProcessor newRootResponseProcessor(HttpTx tx) {
        return new DefaultResponseProcessor(tx, new RootSessionProcessor(tx.silent(), tx.request().clientRequest(), tx.request().requestConfig().checks(), this.httpCaches, this.httpProtocol, this.coreComponents.clock()), this.statsProcessor(tx), new RootNextExecutor(tx, this.resourceFetcher(), this), this.coreComponents.configuration().core().charset());
    }

    private ResponseProcessor newResourceResponseProcessor(HttpTx tx, ResourceTx resourceTx) {
        return new DefaultResponseProcessor(tx.copy(resourceTx.aggregator().currentSession(), tx.copy$default$2(), tx.copy$default$3(), tx.copy$default$4(), tx.copy$default$5()), new ResourceSessionProcessor(tx.silent(), tx.request().clientRequest(), tx.request().requestConfig().checks(), this.httpCaches, this.httpProtocol, this.coreComponents.clock()), this.statsProcessor(tx), new ResourceNextExecutor(tx, resourceTx), this.coreComponents.configuration().core().charset());
    }

    public StatsProcessor statsProcessor(HttpTx tx) {
        return tx.silent() ? this.noopStatsProcessor() : this.defaultStatsProcessor;
    }

    public static final /* synthetic */ void $anonfun$executeHttp2WithCache$4(HttpTxExecutor $this, HttpTx tx) {
        Uri uri = tx.request().clientRequest().getUri();
        Option<ResourceAggregator> option = $this.resourceFetcher().newResourceAggregatorForCachedPage(tx);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            ResourceAggregator aggregator = (ResourceAggregator)some.value();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Fetching resources of cached page request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), uri, tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            aggregator.start(tx.session());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else {
            Some some;
            ResourceTx resourceTx;
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info("Skipping cached request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), uri, tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option<ResourceTx> option2 = tx.resourceTx();
            if (option2 instanceof Some && (resourceTx = (ResourceTx)(some = (Some)option2).value()) != null) {
                ResourceAggregator aggregator = resourceTx.aggregator();
                aggregator.onCachedResource(uri, tx);
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$execute$1(HttpTxExecutor $this, Function1 responseProcessorFactory$1, HttpTx tx) {
        BoxedUnit boxedUnit;
        if (tx.redirectCount() >= tx.request().requestConfig().httpProtocol().responsePart().maxRedirects()) {
            long now = $this.coreComponents.clock().nowMillis();
            ((ResponseProcessor)responseProcessorFactory$1.apply((Object)tx)).onComplete(new HttpFailure(tx.request().clientRequest(), now, now, new StringBuilder(27).append("Too many redirects, max is ").append(tx.request().requestConfig().httpProtocol().responsePart().maxRedirects()).toString()));
            return;
        }
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Sending request={} uri={}: scenario={}, userId={}", new Object[]{tx.request().requestName(), tx.request().clientRequest().getUri(), tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Request clientRequest = tx.request().clientRequest();
        long clientId = tx.session().userId();
        boolean shared = tx.request().requestConfig().httpProtocol().enginePart().shareConnections();
        GatlingHttpListener listener = new GatlingHttpListener(tx, $this.coreComponents.clock(), (ResponseProcessor)responseProcessorFactory$1.apply((Object)tx));
        Option<SslContexts> userSslContexts = SslContextSupport$.MODULE$.sslContexts(tx.session());
        SslContext sslContext = (SslContext)userSslContexts.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.sslContext()).orNull(Predef$.MODULE$.$conforms());
        SslContext alpnSslContext = (SslContext)userSslContexts.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.alpnSslContext()).orNull(Predef$.MODULE$.$conforms());
        Option option = $this.coreComponents.throttler();
        if (option instanceof Some) {
            Some some = (Some)option;
            Throttler th = (Throttler)some.value();
            if (tx.request().requestConfig().throttled()) {
                th.throttle(tx.session().scenario(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.httpEngine.executeRequest(clientRequest, clientId, shared, tx.session().eventLoop(), listener, sslContext, alpnSslContext));
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        $this.httpEngine.executeRequest(clientRequest, clientId, shared, tx.session().eventLoop(), listener, sslContext, alpnSslContext);
        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$execute$6(HttpTxExecutor $this, HttpTx tx) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Sending request={} uri={} scenario={}, userId={}", new Object[]{tx.request().requestName(), tx.request().clientRequest().getUri(), tx.session().scenario(), BoxesRunTime.boxToLong((long)tx.session().userId())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$execute$5(HttpTxExecutor $this, Function1 responseProcessorFactory$2, Iterable txs) {
        HttpTx headTx = (HttpTx)txs.head();
        txs.foreach((Function1 & Serializable & scala.Serializable)tx -> {
            HttpTxExecutor.$anonfun$execute$6($this, tx);
            return BoxedUnit.UNIT;
        });
        Iterable requestsAndListeners = (Iterable)txs.map((Function1 & Serializable & scala.Serializable)tx -> {
            GatlingHttpListener listener = new GatlingHttpListener((HttpTx)tx, $this.coreComponents.clock(), (ResponseProcessor)responseProcessorFactory$2.apply(tx));
            return new Pair((Object)tx.request().clientRequest(), (Object)listener);
        }, Iterable$.MODULE$.canBuildFrom());
        long clientId = headTx.session().userId();
        boolean shared = headTx.request().requestConfig().httpProtocol().enginePart().shareConnections();
        Option<SslContexts> userSslContexts = SslContextSupport$.MODULE$.sslContexts(headTx.session());
        SslContext sslContext = (SslContext)userSslContexts.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.sslContext()).orNull(Predef$.MODULE$.$conforms());
        SslContext alpnSslContext = (SslContext)userSslContexts.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.alpnSslContext()).orNull(Predef$.MODULE$.$conforms());
        Option option = $this.coreComponents.throttler();
        if (option instanceof Some) {
            Some some = (Some)option;
            Throttler th = (Throttler)some.value();
            if (((HttpTx)txs.head()).request().requestConfig().throttled()) {
                th.throttle(headTx.session().scenario(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.httpEngine.executeHttp2Requests((Iterable<Pair<Request, HttpListener>>)requestsAndListeners, clientId, shared, headTx.session().eventLoop(), sslContext, alpnSslContext));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        $this.httpEngine.executeHttp2Requests((Iterable<Pair<Request, HttpListener>>)requestsAndListeners, clientId, shared, headTx.session().eventLoop(), sslContext, alpnSslContext);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpTxExecutor(CoreComponents coreComponents, HttpEngine httpEngine, HttpCaches httpCaches, DefaultStatsProcessor defaultStatsProcessor, HttpProtocol httpProtocol) {
        this.coreComponents = coreComponents;
        this.httpEngine = httpEngine;
        this.httpCaches = httpCaches;
        this.defaultStatsProcessor = defaultStatsProcessor;
        this.httpProtocol = httpProtocol;
        NameGen.$init$((NameGen)this);
        StrictLogging.$init$((StrictLogging)this);
        this.noopStatsProcessor = new NoopStatsProcessor(coreComponents.configuration().core().charset());
        this.resourceFetcher = new ResourceFetcher(coreComponents, httpCaches, httpProtocol, this);
        this.responseProcessorFactory = (Function1 & Serializable & scala.Serializable)tx -> {
            ResponseProcessor responseProcessor;
            Option<ResourceTx> option = tx.resourceTx();
            if (option instanceof Some) {
                Some some = (Some)option;
                ResourceTx resourceTx = (ResourceTx)some.value();
                responseProcessor = this.newResourceResponseProcessor((HttpTx)tx, resourceTx);
            } else {
                responseProcessor = this.newRootResponseProcessor((HttpTx)tx);
            }
            return responseProcessor;
        };
    }
}

