/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.resolver;

import io.gatling.http.client.HttpListener;
import io.gatling.http.client.resolver.InetAddressNameResolver;
import io.gatling.http.util.InetAddresses$;
import io.gatling.http.util.Lists;
import io.netty.channel.EventLoop;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000154Q\u0001C\u0005\u0001\u0017EA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\u0007\u0005\tG\u0001\u0011\t\u0011)A\u0005I!)A\u0006\u0001C\u0001[!9!\u0007\u0001b\u0001\n\u0013\u0019\u0004B\u0002)\u0001A\u0003%A\u0007C\u0003R\u0001\u0011\u0005#\u000bC\u0003h\u0001\u0011\u0005\u0003NA\u000bTQV4g\r\\5oO:\u000bW.\u001a*fg>dg/\u001a:\u000b\u0005)Y\u0011\u0001\u0003:fg>dg/\u001a:\u000b\u00051i\u0011\u0001\u00025uiBT!AD\b\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0001#\u0001\u0002j_N\u0019\u0001A\u0005\u000e\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001\u00027b]\u001eT\u0011aF\u0001\u0005U\u00064\u0018-\u0003\u0002\u001a)\t1qJ\u00196fGR\u0004\"aG\u0010\u000e\u0003qQ!AC\u000f\u000b\u0005yY\u0011AB2mS\u0016tG/\u0003\u0002!9\t9\u0012J\\3u\u0003\u0012$'/Z:t\u001d\u0006lWMU3t_24XM]\u0001\boJ\f\u0007\u000f]3e\u0007\u0001\t\u0011\"\u001a<f]Rdun\u001c9\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013aB2iC:tW\r\u001c\u0006\u0003S=\tQA\\3uifL!a\u000b\u0014\u0003\u0013\u00153XM\u001c;M_>\u0004\u0018A\u0002\u001fj]&$h\bF\u0002/aE\u0002\"a\f\u0001\u000e\u0003%AQ!I\u0002A\u0002iAQaI\u0002A\u0002\u0011\nQaY1dQ\u0016,\u0012\u0001\u000e\t\u0005kaRt)D\u00017\u0015\t9d#\u0001\u0003vi&d\u0017BA\u001d7\u0005\u001dA\u0015m\u001d5NCB\u0004\"a\u000f#\u000f\u0005q\u0012\u0005CA\u001fA\u001b\u0005q$BA #\u0003\u0019a$o\\8u})\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\u00061\u0001K]3eK\u001aL!!\u0012$\u0003\rM#(/\u001b8h\u0015\t\u0019\u0005\tE\u00026\u0011*K!!\u0013\u001c\u0003\t1K7\u000f\u001e\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bZ\t1A\\3u\u0013\tyEJA\u0006J]\u0016$\u0018\t\u001a3sKN\u001c\u0018AB2bG\",\u0007%\u0001\u0006sKN|GN^3BY2$Ba\u0015.]CB\u0019A\u000bW$\u000e\u0003US!AV,\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00028Q%\u0011\u0011,\u0016\u0002\u0007\rV$XO]3\t\u000bm3\u0001\u0019\u0001\u001e\u0002\u0011%tW\r\u001e%pgRDQ!\u0018\u0004A\u0002y\u000bq\u0001\u001d:p[&\u001cX\rE\u0002U?\u001eK!\u0001Y+\u0003\u000fA\u0013x.\\5tK\")!M\u0002a\u0001G\u0006AA.[:uK:,'\u000f\u0005\u0002eK6\tQ$\u0003\u0002g;\ta\u0001\n\u001e;q\u0019&\u001cH/\u001a8fe\u0006)1\r\\8tKR\t\u0011\u000e\u0005\u0002kW6\t\u0001)\u0003\u0002m\u0001\n!QK\\5u\u0001")
public class ShufflingNameResolver
implements InetAddressNameResolver {
    private final InetAddressNameResolver wrapped;
    private final EventLoop eventLoop;
    private final HashMap<String, List<InetAddress>> cache;

    private HashMap<String, List<InetAddress>> cache() {
        return this.cache;
    }

    public Future<List<InetAddress>> resolveAll(String inetHost, Promise<List<InetAddress>> promise, HttpListener listener) {
        this.wrapped.resolveAll(inetHost, this.eventLoop.newPromise(), listener).addListener(future -> {
            if (future.isSuccess()) {
                List rawAddresses = (List)future.getNow();
                if (rawAddresses.size() == 1) {
                    this.cache().remove(inetHost);
                    promise.setSuccess((Object)rawAddresses);
                } else {
                    List<InetAddress> cachedAddresses = this.cache().get(inetHost);
                    if (cachedAddresses != null && Lists.isSameSetAssumingNoDuplicate(cachedAddresses, rawAddresses)) {
                        promise.setSuccess(cachedAddresses);
                    } else {
                        List<InetAddress> shuffledAddresses = InetAddresses$.MODULE$.shuffleInetAddresses(rawAddresses, NetUtil.isIpV4StackPreferred(), NetUtil.isIpV6AddressesPreferred());
                        this.cache().put(inetHost, shuffledAddresses);
                        promise.setSuccess(shuffledAddresses);
                    }
                }
            } else {
                promise.setFailure(future.cause());
            }
        });
        return promise;
    }

    public void close() {
        this.wrapped.close();
    }

    public ShufflingNameResolver(InetAddressNameResolver wrapped, EventLoop eventLoop) {
        this.wrapped = wrapped;
        this.eventLoop = eventLoop;
        this.cache = new HashMap(3);
    }
}

