/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.http.MissingNettyHttpHeaderValues$;
import io.gatling.http.action.sse.SseInvalidContentTypeException;
import io.gatling.http.action.sse.SseInvalidStatusException;
import io.gatling.http.action.sse.fsm.ServerSentEvent;
import io.gatling.http.action.sse.fsm.SseStream;
import io.gatling.http.action.sse.fsm.SseStreamDecoder;
import io.gatling.http.client.HttpListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\t\u0012\u0001qA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006y\u0001!\t!\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0011\u00191\u0005\u0001)A\u0005\u0007\"Iq\t\u0001a\u0001\u0002\u0004%I\u0001\u0013\u0005\n!\u0002\u0001\r\u00111A\u0005\nEC\u0011B\u0017\u0001A\u0002\u0003\u0005\u000b\u0015B%\t\u000fm\u0003\u0001\u0019!C\u00059\"9\u0001\r\u0001a\u0001\n\u0013\t\u0007BB2\u0001A\u0003&Q\fC\u0003e\u0001\u0011\u0005S\rC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0003j\u0001\u0011\u0005#\u000eC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\u0010\u0001!\t%!\u0005\u0003\u0017M\u001bX\rT5ti\u0016tWM\u001d\u0006\u0003%M\t1a]:f\u0015\t!R#\u0001\u0004bGRLwN\u001c\u0006\u0003-]\tA\u0001\u001b;ua*\u0011\u0001$G\u0001\bO\u0006$H.\u001b8h\u0015\u0005Q\u0012AA5p\u0007\u0001\u0019B\u0001A\u000f&WA\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005Y\u0006twMC\u0001#\u0003\u0011Q\u0017M^1\n\u0005\u0011z\"AB(cU\u0016\u001cG\u000f\u0005\u0002'S5\tqE\u0003\u0002)+\u000511\r\\5f]RL!AK\u0014\u0003\u0019!#H\u000f\u001d'jgR,g.\u001a:\u0011\u00051\u001aT\"A\u0017\u000b\u00059z\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u00192\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u001a\u0002\u0007\r|W.\u0003\u00025[\ti1\u000b\u001e:jGRdunZ4j]\u001e\faa\u001d;sK\u0006l\u0007CA\u001c;\u001b\u0005A$BA\u001d\u0012\u0003\r17/\\\u0005\u0003wa\u0012\u0011bU:f'R\u0014X-Y7\u0002\rqJg.\u001b;?)\tq\u0004\t\u0005\u0002@\u00015\t\u0011\u0003C\u00036\u0005\u0001\u0007a'A\u0004eK\u000e|G-\u001a:\u0016\u0003\r\u0003\"a\u000e#\n\u0005\u0015C$\u0001E*tKN#(/Z1n\t\u0016\u001cw\u000eZ3s\u0003!!WmY8eKJ\u0004\u0013aB2iC:tW\r\\\u000b\u0002\u0013B\u0011!JT\u0007\u0002\u0017*\u0011q\t\u0014\u0006\u0003\u001bf\tQA\\3uifL!aT&\u0003\u000f\rC\u0017M\u001c8fY\u0006Y1\r[1o]\u0016dw\fJ3r)\t\u0011\u0006\f\u0005\u0002T-6\tAKC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9FK\u0001\u0003V]&$\bbB-\u0007\u0003\u0003\u0005\r!S\u0001\u0004q\u0012\n\u0014\u0001C2iC:tW\r\u001c\u0011\u0002\r\rdwn]3e+\u0005i\u0006CA*_\u0013\tyFKA\u0004C_>dW-\u00198\u0002\u0015\rdwn]3e?\u0012*\u0017\u000f\u0006\u0002SE\"9\u0011,CA\u0001\u0002\u0004i\u0016aB2m_N,G\rI\u0001\b_:<&/\u001b;f)\t\u0011f\rC\u0003H\u0017\u0001\u0007\u0011*\u0001\u0007dY>\u001cXm\u00115b]:,G\u000eF\u0001S\u00039yg\u000e\u0013;uaJ+7\u000f]8og\u0016$2AU6w\u0011\u0015aW\u00021\u0001n\u0003\u0019\u0019H/\u0019;vgB\u0011a\u000e^\u0007\u0002_*\u0011a\u0003\u001d\u0006\u0003cJ\fQaY8eK\u000eT!a\u001d'\u0002\u000f!\fg\u000e\u001a7fe&\u0011Qo\u001c\u0002\u0013\u0011R$\bOU3ta>t7/Z*uCR,8\u000fC\u0003x\u001b\u0001\u0007\u00010A\u0004iK\u0006$WM]:\u0011\u00059L\u0018B\u0001>p\u0005-AE\u000f\u001e9IK\u0006$WM]:\u0002/=t\u0007\n\u001e;q%\u0016\u001c\bo\u001c8tK\n{G-_\"ik:\\G\u0003\u0002*~\u0003\u0017AQA \bA\u0002}\fQa\u00195v].\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000ba\u0015A\u00022vM\u001a,'/\u0003\u0003\u0002\n\u0005\r!a\u0002\"zi\u0016\u0014UO\u001a\u0005\u0007\u0003\u001bq\u0001\u0019A/\u0002\t1\f7\u000f^\u0001\f_:$\u0006N]8xC\ndW\rF\u0002S\u0003'Aq!!\u0006\u0010\u0001\u0004\t9\"A\u0005uQJ|w/\u00192mKB!\u0011\u0011DA\u0015\u001d\u0011\tY\"!\n\u000f\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t\u001c\u0003\u0019a$o\\8u}%\tQ+C\u0002\u0002(Q\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002,\u00055\"!\u0003+ie><\u0018M\u00197f\u0015\r\t9\u0003\u0016")
public class SseListener
implements HttpListener,
StrictLogging {
    private final SseStream stream;
    private final SseStreamDecoder decoder;
    private Channel channel;
    private boolean closed;
    private Logger logger;

    public void onSend() {
        super.onSend();
    }

    public void onProtocolAwareness(boolean x$1) {
        super.onProtocolAwareness(x$1);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private SseStreamDecoder decoder() {
        return this.decoder;
    }

    private Channel channel() {
        return this.channel;
    }

    private void channel_$eq(Channel x$1) {
        this.channel = x$1;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public void onWrite(Channel channel) {
        this.channel_$eq(channel);
    }

    public void closeChannel() {
        block0: {
            if (this.channel() == null) break block0;
            this.closed_$eq(true);
            this.channel().close();
            boolean bl = this.channel() == null;
        }
    }

    public void onHttpResponse(HttpResponseStatus status, HttpHeaders headers) {
        block8: {
            BoxedUnit boxedUnit;
            if (this.closed()) break block8;
            String contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Status {} Content-Type {} received for SSE", new Object[]{BoxesRunTime.boxToInteger((int)status.code()), contentType});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HttpResponseStatus httpResponseStatus = status;
            HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
            HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
            if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
                BoxedUnit boxedUnit2;
                if (contentType != null && contentType.startsWith(MissingNettyHttpHeaderValues$.MODULE$.TextEventStream().toString())) {
                    this.stream.connected();
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    this.onThrowable(new SseInvalidContentTypeException(contentType));
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit2;
            } else {
                HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.NO_CONTENT;
                HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
                if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
                    this.stream.endOfStream();
                    this.closeChannel();
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    this.onThrowable(new SseInvalidStatusException(status.code()));
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                }
            }
        }
    }

    public void onHttpResponseBodyChunk(ByteBuf chunk, boolean last) {
        block1: {
            if (this.closed()) break block1;
            Seq<ServerSentEvent> events = this.decoder().decodeStream(chunk);
            events.foreach((Function1 & Serializable)event -> {
                this.stream.eventReceived(event);
                return BoxedUnit.UNIT;
            });
            if (last) {
                this.stream.closedByServer();
            }
        }
    }

    public void onThrowable(Throwable throwable) {
        block0: {
            if (this.closed()) break block0;
            this.closeChannel();
            this.stream.crash(throwable);
        }
    }

    public SseListener(SseStream stream) {
        this.stream = stream;
        StrictLogging.$init$((StrictLogging)this);
        this.decoder = new SseStreamDecoder();
        this.closed = false;
        Statics.releaseFence();
    }
}

