/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.sse.fsm.NextSseState;
import io.gatling.http.action.sse.fsm.SseConnectingState$;
import io.gatling.http.action.sse.fsm.SseFsm$;
import io.gatling.http.action.sse.fsm.SseState;
import io.gatling.http.action.sse.fsm.SseStream;
import io.gatling.http.check.sse.SseMessageCheckSequence;
import io.gatling.http.client.Request;
import io.gatling.http.engine.HttpEngine;
import io.gatling.http.protocol.HttpProtocol;
import io.netty.channel.EventLoop;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tMr!\u0002\u0013&\u0011\u0003\u0011d!\u0002\u001b&\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004\"\u0002 \u0002\t\u0003yd\u0001\u0002\u001b&\u0001\u0005C\u0011\u0002\u0014\u0003\u0003\u0006\u0004%\t!J'\t\u0011e#!\u0011!Q\u0001\n9C\u0011B\u0017\u0003\u0003\u0006\u0004%\t!J'\t\u0011m#!\u0011!Q\u0001\n9C\u0011\u0002\u0018\u0003\u0003\u0006\u0004%\t!J/\t\u00119$!\u0011!Q\u0001\nyC\u0011b\u001c\u0003\u0003\u0006\u0004%\t!\n9\t\u0011e$!\u0011!Q\u0001\nED\u0001B\u001f\u0003\u0003\u0002\u0003\u0006Ia\u001f\u0005\f\u0003\u000f!!Q1A\u0005\u0002\u0015\nI\u0001\u0003\u0006\u0002\u001c\u0011\u0011\t\u0011)A\u0005\u0003\u0017A1\"!\b\u0005\u0005\u000b\u0007I\u0011A\u0013\u0002 !Q\u0011q\u0005\u0003\u0003\u0002\u0003\u0006I!!\t\t\rq\"A\u0011AA\u0015\u0011-\tI\u0004\u0002a\u0001\u0002\u0004%I!a\u000f\t\u0017\u0005\rC\u00011AA\u0002\u0013%\u0011Q\t\u0005\f\u0003#\"\u0001\u0019!A!B\u0013\ti\u0004C\u0006\u0002T\u0011\u0001\r\u00111A\u0005\n\u0005U\u0003bCA5\t\u0001\u0007\t\u0019!C\u0005\u0003WB1\"a\u001c\u0005\u0001\u0004\u0005\t\u0015)\u0003\u0002X!A\u0011\u0011\u000f\u0003\u0005\u0002\u0015\n\u0019\b\u0003\u0005\u0002\b\u0012!\t!JAE\u0011\u001d\tY\t\u0002C\u0005\u0003\u001bCq!a(\u0005\t\u0003\t\t\u000bC\u0004\u0002@\u0012!\t!!#\t\u000f\u0005\u0005G\u0001\"\u0001\u0002D\"9\u00111\u001b\u0003\u0005\u0002\u0005U\u0007bBAn\t\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003;$A\u0011AAE\u0011\u001d\ty\u000e\u0002C\u0001\u0003CDq!!<\u0005\t\u0003\ty/\u0001\u0004Tg\u001645/\u001c\u0006\u0003M\u001d\n1AZ:n\u0015\tA\u0013&A\u0002tg\u0016T!AK\u0016\u0002\r\u0005\u001cG/[8o\u0015\taS&\u0001\u0003iiR\u0004(B\u0001\u00180\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001M\u0001\u0003S>\u001c\u0001\u0001\u0005\u00024\u00035\tQE\u0001\u0004Tg\u001645/\\\n\u0003\u0003Y\u0002\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00013\u0003\u0015\t\u0007\u000f\u001d7z)M\u0001\u0015q_A}\u0003w\fiP!\u0004\u0003\u0010\tE!\u0011\u0005B\u0019!\t\u0019DaE\u0002\u0005m\t\u0003\"a\u0011&\u000e\u0003\u0011S!!\u0012$\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u001dC\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003%\u000b1aY8n\u0013\tYEIA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\bgN,g*Y7f+\u0005q\u0005CA(W\u001d\t\u0001F\u000b\u0005\u0002Rq5\t!K\u0003\u0002Tc\u00051AH]8pizJ!!\u0016\u001d\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+b\n\u0001b]:f\u001d\u0006lW\rI\u0001\u0012G>tg.Z2u\u0003\u000e$\u0018n\u001c8OC6,\u0017AE2p]:,7\r^!di&|gNT1nK\u0002\nAcY8o]\u0016\u001cGo\u00115fG.\u001cV-];f]\u000e,W#\u00010\u0011\u0007}#wM\u0004\u0002aE:\u0011\u0011+Y\u0005\u0002s%\u00111\rO\u0001\ba\u0006\u001c7.Y4f\u0013\t)gM\u0001\u0003MSN$(BA29!\tAG.D\u0001j\u0015\tA#N\u0003\u0002lW\u0005)1\r[3dW&\u0011Q.\u001b\u0002\u0018'N,W*Z:tC\u001e,7\t[3dWN+\u0017/^3oG\u0016\fQcY8o]\u0016\u001cGo\u00115fG.\u001cV-];f]\u000e,\u0007%A\u0006ti\u0006$8/\u00128hS:,W#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018!B:uCR\u001c(B\u0001<.\u0003\u0011\u0019wN]3\n\u0005a\u001c(aC*uCR\u001cXI\\4j]\u0016\fAb\u001d;biN,enZ5oK\u0002\n\u0011\"\u001a<f]Rdun\u001c9\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0A\u0004dQ\u0006tg.\u001a7\u000b\u0007\u0005\u0005q&A\u0003oKR$\u00180C\u0002\u0002\u0006u\u0014\u0011\"\u0012<f]Rdun\u001c9\u0002\u000b\rdwnY6\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005kRLGNC\u0002\u0002\u00165\nqaY8n[>t7/\u0003\u0003\u0002\u001a\u0005=!!B\"m_\u000e\\\u0017AB2m_\u000e\\\u0007%\u0001\u0004tiJ,\u0017-\\\u000b\u0003\u0003C\u00012aMA\u0012\u0013\r\t)#\n\u0002\n'N,7\u000b\u001e:fC6\fqa\u001d;sK\u0006l\u0007\u0005F\bA\u0003W\ti#a\f\u00022\u0005M\u0012QGA\u001c\u0011\u0015a%\u00031\u0001O\u0011\u0015Q&\u00031\u0001O\u0011\u0015a&\u00031\u0001_\u0011\u0015y'\u00031\u0001r\u0011\u0015Q(\u00031\u0001|\u0011\u001d\t9A\u0005a\u0001\u0003\u0017Aq!!\b\u0013\u0001\u0004\t\t#\u0001\u0007dkJ\u0014XM\u001c;Ti\u0006$X-\u0006\u0002\u0002>A\u00191'a\u0010\n\u0007\u0005\u0005SE\u0001\u0005Tg\u0016\u001cF/\u0019;f\u0003A\u0019WO\u001d:f]R\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002H\u00055\u0003cA\u001c\u0002J%\u0019\u00111\n\u001d\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u001f\"\u0012\u0011!a\u0001\u0003{\t1\u0001\u001f\u00132\u00035\u0019WO\u001d:f]R\u001cF/\u0019;fA\u0005q1-\u001e:sK:$H+[7f_V$XCAA,!\u0019\tI&!\u001a\u0002H5\u0011\u00111\f\u0006\u0005\u0003;\ny&\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\u0005\u0002b)\u0011\u00111M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002h\u0005m#aD*dQ\u0016$W\u000f\\3e\rV$XO]3\u0002%\r,(O]3oiRKW.Z8vi~#S-\u001d\u000b\u0005\u0003\u000f\ni\u0007C\u0005\u0002P]\t\t\u00111\u0001\u0002X\u0005y1-\u001e:sK:$H+[7f_V$\b%A\btG\",G-\u001e7f)&lWm\\;u)\u0011\t9%!\u001e\t\u000f\u0005]\u0014\u00041\u0001\u0002z\u0005\u0019A-\u001e:\u0011\t\u0005m\u00141Q\u0007\u0003\u0003{RA!a \u0002\u0002\u0006AA-\u001e:bi&|gNC\u0002\u0002^aJA!!\"\u0002~\tqa)\u001b8ji\u0016$UO]1uS>t\u0017!D2b]\u000e,G\u000eV5nK>,H\u000f\u0006\u0002\u0002H\u00059Q\r_3dkR,G\u0003BA$\u0003\u001fC\u0001\"!%\u001c\t\u0003\u0007\u00111S\u0001\u0002MB)q'!&\u0002\u001a&\u0019\u0011q\u0013\u001d\u0003\u0011q\u0012\u0017P\\1nKz\u00022aMAN\u0013\r\ti*\n\u0002\r\u001d\u0016DHoU:f'R\fG/Z\u0001\u0018_:\u0004VM\u001d4pe6Le.\u001b;jC2\u001cuN\u001c8fGR$b!a\u0012\u0002$\u0006E\u0006bBAS9\u0001\u0007\u0011qU\u0001\bg\u0016\u001c8/[8o!\u0011\tI+!,\u000e\u0005\u0005-&bAASk&!\u0011qVAV\u0005\u001d\u0019Vm]:j_:Dq!a-\u001d\u0001\u0004\t),\u0001\nj]&$\u0018.\u00197D_:tWm\u0019;OKb$\b\u0003BA\\\u0003wk!!!/\u000b\u0005)*\u0018\u0002BA_\u0003s\u0013a!Q2uS>t\u0017\u0001F8o'N,7\u000b\u001e:fC6\u001cuN\u001c8fGR,G-\u0001\u0006p]N+Go\u00115fG.$\"\"a\u0012\u0002F\u0006%\u0017QZAh\u0011\u0019\t9M\ba\u0001\u001d\u0006Q\u0011m\u0019;j_:t\u0015-\\3\t\r\u0005-g\u00041\u0001_\u00039\u0019\u0007.Z2l'\u0016\fX/\u001a8dKNDq!!*\u001f\u0001\u0004\t9\u000bC\u0004\u0002Rz\u0001\r!!.\u0002\t9,\u0007\u0010^\u0001\u000e_:\u001c6/\u001a*fG\u0016Lg/\u001a3\u0015\t\u0005\u001d\u0013q\u001b\u0005\u0007\u00033|\u0002\u0019\u0001(\u0002\u000f5,7o]1hK\u0006\u0001rN\\*tK\u0016sGm\u00144TiJ,\u0017-\\\u0001\u0012_:\u001c6/Z*ue\u0016\fWn\u00117pg\u0016$\u0017AE8o'N,7\u000b\u001e:fC6\u001c%/Y:iK\u0012$B!a\u0012\u0002d\"9\u0011Q\u001d\u0012A\u0002\u0005\u001d\u0018!\u0001;\u0011\u0007}\u000bI/C\u0002\u0002l\u001a\u0014\u0011\u0002\u00165s_^\f'\r\\3\u0002)=t7\t\\5f]R\u001cEn\\:f%\u0016\fX/Z:u)!\t9%!=\u0002t\u0006U\bBBAdG\u0001\u0007a\nC\u0004\u0002&\u000e\u0002\r!a*\t\u000f\u0005E7\u00051\u0001\u00026\"9\u0011QU\u0002A\u0002\u0005\u001d\u0006\"\u0002'\u0004\u0001\u0004q\u0005\"\u0002.\u0004\u0001\u0004q\u0005bBA\u0000\u0007\u0001\u0007!\u0011A\u0001\u000fG>tg.Z2u%\u0016\fX/Z:u!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!b\u0001B\u0004W\u000511\r\\5f]RLAAa\u0003\u0003\u0006\t9!+Z9vKN$\b\"\u0002/\u0004\u0001\u0004q\u0006\"B8\u0004\u0001\u0004\t\bb\u0002B\n\u0007\u0001\u0007!QC\u0001\u000bQR$\b/\u00128hS:,\u0007\u0003\u0002B\f\u0005;i!A!\u0007\u000b\u0007\tm1&\u0001\u0004f]\u001eLg.Z\u0005\u0005\u0005?\u0011IB\u0001\u0006IiR\u0004XI\\4j]\u0016DqAa\t\u0004\u0001\u0004\u0011)#\u0001\u0007iiR\u0004\bK]8u_\u000e|G\u000e\u0005\u0003\u0003(\t5RB\u0001B\u0015\u0015\r\u0011YcK\u0001\taJ|Go\\2pY&!!q\u0006B\u0015\u00051AE\u000f\u001e9Qe>$xnY8m\u0011\u001d\t9a\u0001a\u0001\u0003\u0017\u0001")
public class SseFsm
implements StrictLogging {
    private final String sseName;
    private final String connectActionName;
    private final List<SseMessageCheckSequence> connectCheckSequence;
    private final StatsEngine statsEngine;
    private final EventLoop eventLoop;
    private final Clock clock;
    private final SseStream stream;
    private SseState currentState;
    private ScheduledFuture<BoxedUnit> currentTimeout;
    private Logger logger;

    public static SseFsm apply(Session session, String string, String string2, Request request, List<SseMessageCheckSequence> list, StatsEngine statsEngine, HttpEngine httpEngine, HttpProtocol httpProtocol, Clock clock) {
        return SseFsm$.MODULE$.apply(session, string, string2, request, list, statsEngine, httpEngine, httpProtocol, clock);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String sseName() {
        return this.sseName;
    }

    public String connectActionName() {
        return this.connectActionName;
    }

    public List<SseMessageCheckSequence> connectCheckSequence() {
        return this.connectCheckSequence;
    }

    public StatsEngine statsEngine() {
        return this.statsEngine;
    }

    public Clock clock() {
        return this.clock;
    }

    public SseStream stream() {
        return this.stream;
    }

    private SseState currentState() {
        return this.currentState;
    }

    private void currentState_$eq(SseState x$1) {
        this.currentState = x$1;
    }

    private ScheduledFuture<BoxedUnit> currentTimeout() {
        return this.currentTimeout;
    }

    private void currentTimeout_$eq(ScheduledFuture<BoxedUnit> x$1) {
        this.currentTimeout = x$1;
    }

    public void scheduleTimeout(FiniteDuration dur) {
        BoxedUnit boxedUnit;
        this.currentTimeout_$eq((ScheduledFuture<BoxedUnit>)this.eventLoop.schedule(() -> {
            SseFsm.$anonfun$scheduleTimeout$1(this);
            return BoxedUnit.UNIT;
        }, dur.toMillis(), TimeUnit.MILLISECONDS));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Timeout {} scheduled", (Object)BoxesRunTime.boxToInteger((int)this.currentTimeout().hashCode()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void cancelTimeout() {
        if (this.currentTimeout() == null) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Couldn't cancel timeout because it wasn't set");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit;
            if (this.currentTimeout().cancel(true)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Timeout {} cancelled", (Object)BoxesRunTime.boxToInteger((int)this.currentTimeout().hashCode()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Failed to cancel timeout {}", (Object)BoxesRunTime.boxToInteger((int)this.currentTimeout().hashCode()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.currentTimeout_$eq(null);
        }
    }

    private void execute(Function0<NextSseState> f) {
        NextSseState nextSseState = (NextSseState)f.apply();
        if (nextSseState == null) {
            throw new MatchError((Object)nextSseState);
        }
        SseState nextState = nextSseState.state();
        Function0<BoxedUnit> afterStateUpdate = nextSseState.afterStateUpdate();
        Tuple2 tuple2 = new Tuple2((Object)nextState, afterStateUpdate);
        Tuple2 tuple22 = tuple2;
        SseState nextState2 = (SseState)tuple22._1();
        Function0 afterStateUpdate2 = (Function0)tuple22._2();
        this.currentState_$eq(nextState2);
        afterStateUpdate2.apply$mcV$sp();
    }

    public void onPerformInitialConnect(Session session, Action initialConnectNext) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable)() -> SseConnectingState$.MODULE$.gotoConnecting(this, session, initialConnectNext));
    }

    public void onSseStreamConnected() {
        this.execute((Function0<NextSseState>)(Function0 & Serializable)() -> this.currentState().onSseStreamConnected(this.clock().nowMillis()));
    }

    public void onSetCheck(String actionName, List<SseMessageCheckSequence> checkSequences, Session session, Action next) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable)() -> this.currentState().onSetCheck(actionName, checkSequences, session, next));
    }

    public void onSseReceived(String message) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable)() -> this.currentState().onSseReceived(message, this.clock().nowMillis()));
    }

    public void onSseEndOfStream() {
        this.execute((Function0<NextSseState>)(Function0 & Serializable)() -> this.currentState().onSseStreamClosed(this.clock().nowMillis()));
    }

    public void onSseStreamClosed() {
        this.execute((Function0<NextSseState>)(Function0 & Serializable)() -> this.currentState().onSseStreamClosed(this.clock().nowMillis()));
    }

    public void onSseStreamCrashed(Throwable t) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable)() -> this.currentState().onSseStreamCrashed(t, this.clock().nowMillis()));
    }

    public void onClientCloseRequest(String actionName, Session session, Action next) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable)() -> this.currentState().onClientCloseRequest(actionName, session, next));
    }

    public static final /* synthetic */ void $anonfun$scheduleTimeout$1(SseFsm $this) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Timeout {} triggered", (Object)BoxesRunTime.boxToInteger((int)$this.currentTimeout().hashCode()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $this.currentTimeout_$eq(null);
        $this.execute((Function0<NextSseState>)(Function0 & Serializable)() -> $this.currentState().onTimeout());
    }

    public SseFsm(String sseName, String connectActionName, List<SseMessageCheckSequence> connectCheckSequence, StatsEngine statsEngine, EventLoop eventLoop, Clock clock, SseStream stream) {
        this.sseName = sseName;
        this.connectActionName = connectActionName;
        this.connectCheckSequence = connectCheckSequence;
        this.statsEngine = statsEngine;
        this.eventLoop = eventLoop;
        this.clock = clock;
        this.stream = stream;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

