/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.validation.Failure;
import io.gatling.core.session.Session;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.check.HttpCheck;
import io.gatling.http.client.Request;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.cookie.CookieSupport$;
import io.gatling.http.engine.response.CheckProcessor$;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005mc!\u0002\b\u0010\u0003CQ\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\"Aa\t\u0001B\u0001B\u0003%q\tC\u0003N\u0001\u0011\u0005a\nC\u0003W\u0001\u0011\u0005q\u000bC\u0003i\u0001\u0011%\u0011\u000eC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u0011q\b\u0001\u0007\u0012\u0005\u0005\u0003bBA$\u0001\u0019E\u0011\u0011\n\u0002\u0011'\u0016\u001c8/[8o!J|7-Z:t_JT!\u0001E\t\u0002\u0011I,7\u000f]8og\u0016T!AE\n\u0002\r\u0015tw-\u001b8f\u0015\t!R#\u0001\u0003iiR\u0004(B\u0001\f\u0018\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011\u0001G\u0001\u0003S>\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\faa]5mK:$\bC\u0001\u000f$\u0013\t!SDA\u0004C_>dW-\u00198\u0002\u000fI,\u0017/^3tiB\u0011qEK\u0007\u0002Q)\u0011\u0011fE\u0001\u0007G2LWM\u001c;\n\u0005-B#a\u0002*fcV,7\u000f^\u0001\u0007G\",7m[:\u0011\u000792\u0014H\u0004\u00020i9\u0011\u0001gM\u0007\u0002c)\u0011!'G\u0001\u0007yI|w\u000e\u001e \n\u0003yI!!N\u000f\u0002\u000fA\f7m[1hK&\u0011q\u0007\u000f\u0002\u0005\u0019&\u001cHO\u0003\u00026;A\u0011!(P\u0007\u0002w)\u0011AhE\u0001\u0006G\",7m[\u0005\u0003}m\u0012\u0011\u0002\u0013;ua\u000eCWmY6\u0002\u0015!$H\u000f]\"bG\",7\u000f\u0005\u0002B\t6\t!I\u0003\u0002D'\u0005)1-Y2iK&\u0011QI\u0011\u0002\u000b\u0011R$\boQ1dQ\u0016\u001c\u0018\u0001\u00045uiB\u0004&o\u001c;pG>d\u0007C\u0001%L\u001b\u0005I%B\u0001&\u0014\u0003!\u0001(o\u001c;pG>d\u0017B\u0001'J\u00051AE\u000f\u001e9Qe>$xnY8m\u0003\u0019a\u0014N\\5u}Q1q*\u0015*T)V\u0003\"\u0001\u0015\u0001\u000e\u0003=AQ!\t\u0004A\u0002\tBQ!\n\u0004A\u0002\u0019BQ\u0001\f\u0004A\u00025BQa\u0010\u0004A\u0002\u0001CQA\u0012\u0004A\u0002\u001d\u000bA#\u001e9eCR,7+Z:tS>t7I]1tQ\u0016$G\u0003\u0002-aC\u001a\u0004\"!\u00170\u000e\u0003iS!a\u0017/\u0002\u000fM,7o]5p]*\u0011Q,F\u0001\u0005G>\u0014X-\u0003\u0002`5\n91+Z:tS>t\u0007\"B.\b\u0001\u0004A\u0006\"\u00022\b\u0001\u0004\u0019\u0017AD:uCJ$H+[7fgR\fW\u000e\u001d\t\u00039\u0011L!!Z\u000f\u0003\t1{gn\u001a\u0005\u0006O\u001e\u0001\raY\u0001\rK:$G+[7fgR\fW\u000e]\u0001\u0013kB$\u0017\r^3TKN\u001c\u0018n\u001c8Ti\u0006$8\u000fF\u0003YU.dW\u000eC\u0003\\\u0011\u0001\u0007\u0001\fC\u0003c\u0011\u0001\u00071\rC\u0003h\u0011\u0001\u00071\rC\u0003o\u0011\u0001\u0007q.\u0001\u0004ti\u0006$Xo\u001d\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fQa\u001d;biNT!\u0001^\u000b\u0002\u000f\r|W.\\8og&\u0011a/\u001d\u0002\u0007'R\fG/^:\u0002\u001dU\u0004H-\u0019;fIN+7o]5p]R)\u00110a\u0004\u0002\u0012A!AD\u001f-}\u0013\tYXD\u0001\u0004UkBdWM\r\t\u00049u|\u0018B\u0001@\u001e\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011AA\u0005\u001d\u0011\t\u0019!!\u0002\u0011\u0005Aj\u0012bAA\u0004;\u00051\u0001K]3eK\u001aLA!a\u0003\u0002\u000e\t11\u000b\u001e:j]\u001eT1!a\u0002\u001e\u0011\u0015Y\u0016\u00021\u0001Y\u0011\u0019\u0001\u0012\u00021\u0001\u0002\u0014A!\u0011QCA\r\u001b\t\t9B\u0003\u0002\u0011'%!\u00111DA\f\u0005!\u0011Vm\u001d9p]N,\u0017AF;qI\u0006$X\r\u001a*fI&\u0014Xm\u0019;TKN\u001c\u0018n\u001c8\u0015\u000fa\u000b\t#a\t\u0002&!)1L\u0003a\u00011\"1\u0001C\u0003a\u0001\u0003'Aq!a\n\u000b\u0001\u0004\tI#A\u0006sK\u0012L'/Z2u+JL\u0007\u0003BA\u0016\u0003ci!!!\f\u000b\u0007\u0005=\u0002&A\u0002ve&LA!a\r\u0002.\t\u0019QK]5\u0002\u001b\r\f7\r[3SK\u0012L'/Z2u)\u001dA\u0016\u0011HA\u001e\u0003{AQaW\u0006A\u0002aCa\u0001E\u0006A\u0002\u0005M\u0001bBA\u0014\u0017\u0001\u0007\u0011\u0011F\u0001\u000ekB$\u0017\r^3SK\u001a,'/\u001a:\u0015\u000ba\u000b\u0019%!\u0012\t\u000bmc\u0001\u0019\u0001-\t\rAa\u0001\u0019AA\n\u0003e)\b\u000fZ1uK\u001e\u0013x.\u001e9SKF,Xm\u001d;US6LgnZ:\u0015\u000fa\u000bY%!\u0014\u0002P!)1,\u0004a\u00011\")!-\u0004a\u0001G\")q-\u0004a\u0001G&*\u0001!a\u0015\u0002X%\u0019\u0011QK\b\u00031I+7o\\;sG\u0016\u001cVm]:j_:\u0004&o\\2fgN|'/C\u0002\u0002Z=\u0011ACU8piN+7o]5p]B\u0013xnY3tg>\u0014\b")
public abstract class SessionProcessor {
    private final boolean silent;
    private final Request request;
    private final List<HttpCheck> checks;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;

    public Session updateSessionCrashed(Session session, long startTimestamp, long endTimestamp) {
        return this.updateSessionStats(session, startTimestamp, endTimestamp, (Status)KO$.MODULE$);
    }

    private Session updateSessionStats(Session session, long startTimestamp, long endTimestamp, Status status) {
        Session session2;
        if (this.silent) {
            session2 = session;
        } else {
            Status status2 = status;
            KO$ kO$ = KO$.MODULE$;
            Session sessionWithUpdatedStatus = !(status2 != null ? !status2.equals(kO$) : kO$ != null) ? session.markAsFailed() : session;
            session2 = this.updateGroupRequestTimings(sessionWithUpdatedStatus, startTimestamp, endTimestamp);
        }
        return session2;
    }

    public Tuple2<Session, Option<String>> updatedSession(Session session, Response response) {
        Tuple2<Session, Option<Failure>> tuple2 = CheckProcessor$.MODULE$.check(session, response, this.checks);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Session sessionWithCheckSavedValues = (Session)tuple2._1();
        Option checkError = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sessionWithCheckSavedValues, (Object)checkError);
        Tuple2 tuple23 = tuple22;
        Session sessionWithCheckSavedValues2 = (Session)tuple23._1();
        Option checkError2 = (Option)tuple23._2();
        Session sessionWithHttp2PriorKnowledge = this.httpProtocol.enginePart().enableHttp2() ? Http2PriorKnowledgeSupport$.MODULE$.updateSessionHttp2PriorKnowledge(sessionWithCheckSavedValues2, response) : sessionWithCheckSavedValues2;
        KO$ newStatus = checkError2.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
        Session newSession = this.updateSessionAfterChecks$1(sessionWithHttp2PriorKnowledge, (Status)newStatus, response);
        return new Tuple2((Object)newSession, (Object)checkError2.map((Function1 & Serializable)x$2 -> x$2.message()));
    }

    public Session updatedRedirectSession(Session session, Response response, Uri redirectUri) {
        Session sessionWithCookieStoreUpdate = CookieSupport$.MODULE$.storeCookies(session, this.request.getUri(), response.cookies(), response.endTimestamp());
        Session sessionWithGroupUpdate = this.updateSessionStats(sessionWithCookieStoreUpdate, response.startTimestamp(), response.endTimestamp(), (Status)OK$.MODULE$);
        return this.cacheRedirect(sessionWithGroupUpdate, response, redirectUri);
    }

    private Session cacheRedirect(Session session, Response response, Uri redirectUri) {
        return this.httpProtocol.requestPart().cache() && HttpHelper$.MODULE$.isPermanentRedirect(response.status()) ? this.httpCaches.addRedirect(session, this.request, redirectUri) : session;
    }

    public abstract Session updateReferer(Session var1, Response var2);

    public abstract Session updateGroupRequestTimings(Session var1, long var2, long var4);

    private final Session updateSessionAfterChecks$1(Session s1, Status status, Response response$1) {
        Session s2 = CookieSupport$.MODULE$.storeCookies(s1, this.request.getUri(), response$1.cookies(), response$1.endTimestamp());
        Session s3 = this.updateReferer(s2, response$1);
        Session s4 = this.httpCaches.cacheContent(s3, this.httpProtocol, this.request, response$1.headers());
        return this.updateSessionStats(s4, response$1.startTimestamp(), response$1.endTimestamp(), status);
    }

    public SessionProcessor(boolean silent, Request request, List<HttpCheck> checks, HttpCaches httpCaches, HttpProtocol httpProtocol) {
        this.silent = silent;
        this.request = request;
        this.checks = checks;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
    }
}

