/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cache;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.CircularIterator$;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.session.SessionPrivateAttributes$;
import io.gatling.core.session.package;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.protocol.HttpProtocol;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class BaseUrlSupport$
implements LazyLogging {
    public static final BaseUrlSupport$ MODULE$ = new BaseUrlSupport$();
    private static final String BaseUrlAttributeName;
    private static final String WsBaseUrlAttributeName;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        BaseUrlAttributeName = SessionPrivateAttributes$.MODULE$.generatePrivateAttribute("http.cache.baseUrl");
        WsBaseUrlAttributeName = SessionPrivateAttributes$.MODULE$.generatePrivateAttribute("http.cache.wsBaseUrl");
    }

    private Logger logger$lzycompute() {
        BaseUrlSupport$ baseUrlSupport$ = this;
        synchronized (baseUrlSupport$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        return !bitmap$trans$0 ? this.logger$lzycompute() : logger;
    }

    private String BaseUrlAttributeName() {
        return BaseUrlAttributeName;
    }

    private String WsBaseUrlAttributeName() {
        return WsBaseUrlAttributeName;
    }

    private void preResolve(String baseUrl, Set<String> aliasedHostnames) {
        try {
            Uri uri = Uri.create((String)baseUrl);
            if (!aliasedHostnames.contains((Object)uri.getHost())) {
                InetAddress.getAllByName(uri.getHost());
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(43).append("Couldn't pre-resolve hostname from baseUrl ").append(baseUrl).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function1<Session, Session> setBaseUrl(List<String> baseUrls, String attributeName, Set<String> aliasedHostnames) {
        baseUrls.foreach((Function1 & Serializable)x$1 -> {
            BaseUrlSupport$.MODULE$.preResolve(x$1, (Set<String>)aliasedHostnames);
            return BoxedUnit.UNIT;
        });
        List<String> list = baseUrls;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (nil$ == null) {
            if (list2 == null) return Session$.MODULE$.Identity();
        } else if (nil$.equals(list2)) {
            return Session$.MODULE$.Identity();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String url = (String)colon2.head();
            List list3 = colon2.next$access$1();
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (nil$2 == null) {
                if (list4 == null) return (Function1 & Serializable)x$2 -> x$2.set(attributeName, (Object)url);
            } else if (nil$2.equals(list4)) {
                return (Function1 & Serializable)x$2 -> x$2.set(attributeName, (Object)url);
            }
        }
        Iterator it = CircularIterator$.MODULE$.apply((IndexedSeq)list.toVector(), true);
        return (Function1 & Serializable)x$3 -> x$3.set(attributeName, it.next());
    }

    public Function1<Session, Session> setHttpBaseUrl(HttpProtocol httpProtocol) {
        return this.setBaseUrl(httpProtocol.baseUrls(), this.BaseUrlAttributeName(), (Set<String>)httpProtocol.dnsPart().hostNameAliases().keySet());
    }

    public Function1<Session, Session> setWsBaseUrl(HttpProtocol httpProtocol) {
        return this.setBaseUrl(httpProtocol.wsPart().wsBaseUrls(), this.WsBaseUrlAttributeName(), (Set<String>)httpProtocol.dnsPart().hostNameAliases().keySet());
    }

    private Option<String> baseUrl(Session session, String attributeName) {
        return session.attributes().get((Object)attributeName).map((Function1 & Serializable)x$4 -> (String)x$4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function1<Session, Option<String>> httpBaseUrl(HttpProtocol httpProtocol) {
        List<String> list = httpProtocol.baseUrls();
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (nil$ == null) {
            if (list2 == null) return (Function1 & Serializable)x$5 -> None$.MODULE$;
        } else if (nil$.equals(list2)) {
            return (Function1 & Serializable)x$5 -> None$.MODULE$;
        }
        if (!(list instanceof .colon.colon)) return (Function1 & Serializable)x$7 -> MODULE$.baseUrl((Session)x$7, MODULE$.BaseUrlAttributeName());
        .colon.colon colon2 = (.colon.colon)list;
        String single = (String)colon2.head();
        List list3 = colon2.next$access$1();
        Nil$ nil$2 = package$.MODULE$.Nil();
        List list4 = list3;
        if (nil$2 == null) {
            if (list4 != null) {
                return (Function1 & Serializable)x$7 -> MODULE$.baseUrl((Session)x$7, MODULE$.BaseUrlAttributeName());
            }
        } else if (!nil$2.equals(list4)) return (Function1 & Serializable)x$7 -> MODULE$.baseUrl((Session)x$7, MODULE$.BaseUrlAttributeName());
        Some s = new Some((Object)single);
        return (Function1 & Serializable)x$6 -> s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function1<Session, Option<String>> wsBaseUrl(HttpProtocol httpProtocol) {
        List<String> list = httpProtocol.wsPart().wsBaseUrls();
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (nil$ == null) {
            if (list2 == null) return (Function1 & Serializable)x$8 -> None$.MODULE$;
        } else if (nil$.equals(list2)) {
            return (Function1 & Serializable)x$8 -> None$.MODULE$;
        }
        if (!(list instanceof .colon.colon)) return (Function1 & Serializable)x$10 -> MODULE$.baseUrl((Session)x$10, MODULE$.WsBaseUrlAttributeName());
        .colon.colon colon2 = (.colon.colon)list;
        String single = (String)colon2.head();
        List list3 = colon2.next$access$1();
        Nil$ nil$2 = package$.MODULE$.Nil();
        List list4 = list3;
        if (nil$2 == null) {
            if (list4 != null) {
                return (Function1 & Serializable)x$10 -> MODULE$.baseUrl((Session)x$10, MODULE$.WsBaseUrlAttributeName());
            }
        } else if (!nil$2.equals(list4)) return (Function1 & Serializable)x$10 -> MODULE$.baseUrl((Session)x$10, MODULE$.WsBaseUrlAttributeName());
        Some s = new Some((Object)single);
        return (Function1 & Serializable)x$9 -> s;
    }

    /*
     * Unable to fully structure code
     */
    public Function1<Session, Validation<String>> defaultDomain(HttpProtocol httpProtocol, Function1<Session, Validation<String>> failure) {
        block7: {
            block4: {
                block6: {
                    block5: {
                        var5_3 = httpProtocol.baseUrls();
                        v0 = package$.MODULE$.Nil();
                        var6_4 = var5_3;
                        if (v0 != null ? v0.equals(var6_4) == false : var6_4 != null) break block4;
                        var7_5 = httpProtocol.wsPart().wsBaseUrls();
                        v1 = package$.MODULE$.Nil();
                        var8_6 = var7_5;
                        if (v1 != null ? v1.equals(var8_6) == false : var8_6 != null) break block5;
                        var4_7 = failure;
                        break block6;
                    }
                    if (!(var7_5 instanceof .colon.colon)) ** GOTO lbl-1000
                    var9_8 = (.colon.colon)var7_5;
                    single = (String)var9_8.head();
                    var11_10 = var9_8.next$access$1();
                    v2 = package$.MODULE$.Nil();
                    var12_11 = var11_10;
                    if (!(v2 != null ? v2.equals(var12_11) == false : var12_11 != null)) {
                        var4_7 = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(io.gatling.core.session.package$.MODULE$.ExpressionSuccessWrapper((Object)Uri.create((String)single).getHost()));
                    } else lbl-1000:
                    // 2 sources

                    {
                        var4_7 = (Function1)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$defaultDomain$1(io.gatling.core.session.Session ), (Lio/gatling/core/session/Session;)Lio/gatling/commons/validation/Validation;)();
                    }
                }
                var3_12 = var4_7;
                break block7;
            }
            if (!(var5_3 instanceof .colon.colon)) ** GOTO lbl-1000
            var13_13 = (.colon.colon)var5_3;
            single = (String)var13_13.head();
            var15_15 = var13_13.next$access$1();
            v3 = package$.MODULE$.Nil();
            var16_16 = var15_15;
            if (!(v3 != null ? v3.equals(var16_16) == false : var16_16 != null)) {
                var3_12 = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(io.gatling.core.session.package$.MODULE$.ExpressionSuccessWrapper((Object)Uri.create((String)single).getHost()));
            } else lbl-1000:
            // 2 sources

            {
                var3_12 = (Function1)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$defaultDomain$2(io.gatling.core.session.Session ), (Lio/gatling/core/session/Session;)Lio/gatling/commons/validation/Validation;)();
            }
        }
        return var3_12;
    }

    public static final /* synthetic */ Validation $anonfun$defaultDomain$1(Session session) {
        return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)Uri.create((String)((String)MODULE$.baseUrl(session, MODULE$.WsBaseUrlAttributeName()).get())).getHost()));
    }

    public static final /* synthetic */ Validation $anonfun$defaultDomain$2(Session session) {
        return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)Uri.create((String)((String)MODULE$.baseUrl(session, MODULE$.BaseUrlAttributeName()).get())).getHost()));
    }

    private BaseUrlSupport$() {
    }
}

