/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.ElBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.util.Resource;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.Http2PriorKnowledgeSupport$;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Param;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.gatling.http.client.body.stringchunks.StringChunksRequestBodyBuilder;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.HttpParam;
import io.gatling.http.request.builder.HttpRequestExpressionBuilder$;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.package$;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tMt!\u0002\u0011\"\u0011\u0003ac!\u0002\u0018\"\u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004b\u0002\u001d\u0002\u0005\u0004%I!\u000f\u0005\u0007;\u0006\u0001\u000b\u0011\u0002\u001e\t\u000b\u0015\fA\u0011\u00024\u0007\u000b9\n\u0003!a\u0006\t\u0015\u0005}aA!A!\u0002\u0013\t\t\u0003\u0003\u0006\u0002(\u0019\u0011\t\u0011)A\u0005\u0003SA!\"a\f\u0007\u0005\u0003\u0005\u000b\u0011BA\u0019\u0011)\tiD\u0002B\u0001B\u0003%\u0011q\b\u0005\u000b\u0003\u00172!\u0011!Q\u0001\n\u00055\u0003B\u0002\u001c\u0007\t\u0003\tI\u0006C\u0004\u0002h\u0019!I!!\u001b\t\u000f\u0005%g\u0001\"\u0003\u0002L\"9\u00111\u001d\u0004\u0005\n\u0005\u0015\b\"CA{\r\t\u0007I\u0011BA|\u0011!\u0011)A\u0002Q\u0001\n\u0005e\b\"\u0003B\u0004\r\t\u0007I\u0011\u0002B\u0005\u0011!\u0011\tB\u0002Q\u0001\n\t-\u0001\"\u0003B\n\r\t\u0007I\u0011\u0002B\u0005\u0011!\u0011)B\u0002Q\u0001\n\t-\u0001b\u0002B\f\r\u0011%!\u0011\u0004\u0005\n\u0005S1!\u0019!C\u0005\u0005\u0013A\u0001Ba\u000b\u0007A\u0003%!1\u0002\u0005\b\u0005[1A\u0011\u0002B\u0018\u0011%\u0011YD\u0002b\u0001\n\u0013\u0011i\u0004\u0003\u0005\u0003F\u0019\u0001\u000b\u0011\u0002B \u0011\u001d\u00119E\u0002C)\u0005\u0013BqA!\u0014\u0007\t#\u0012y\u0005C\u0004\u0003`\u0019!IA!\u0019\t\u000f\t5d\u0001\"\u0011\u0003p\u0005a\u0002\n\u001e;q%\u0016\fX/Z:u\u000bb\u0004(/Z:tS>t')^5mI\u0016\u0014(B\u0001\u0012$\u0003\u001d\u0011W/\u001b7eKJT!\u0001J\u0013\u0002\u000fI,\u0017/^3ti*\u0011aeJ\u0001\u0005QR$\bO\u0003\u0002)S\u00059q-\u0019;mS:<'\"\u0001\u0016\u0002\u0005%|7\u0001\u0001\t\u0003[\u0005i\u0011!\t\u0002\u001d\u0011R$\bOU3rk\u0016\u001cH/\u0012=qe\u0016\u001c8/[8o\u0005VLG\u000eZ3s'\t\t\u0001\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\n\u0011DY8esB\u000b'\u000f^:U_6+H\u000e^5qCJ$8OW3s_V\t!\bE\u0002<\u0001\nk\u0011\u0001\u0010\u0006\u0003{y\n!B^1mS\u0012\fG/[8o\u0015\tyt%A\u0004d_6lwN\\:\n\u0005\u0005c$A\u0003,bY&$\u0017\r^5p]B\u00191i\u0013(\u000f\u0005\u0011KeBA#I\u001b\u00051%BA$,\u0003\u0019a$o\\8u}%\t1'\u0003\u0002Ke\u00059\u0001/Y2lC\u001e,\u0017B\u0001'N\u0005\u0011a\u0015n\u001d;\u000b\u0005)\u0013\u0004GA(\\!\r\u0001v+W\u0007\u0002#*\u0011!kU\u0001\n[VdG/\u001b9beRT!\u0001V+\u0002\t\t|G-\u001f\u0006\u0003-\u0016\naa\u00197jK:$\u0018B\u0001-R\u0005\u0011\u0001\u0016M\u001d;\u0011\u0005i[F\u0002\u0001\u0003\n9\u0012\t\t\u0011!A\u0003\u0002y\u00131a\u0018\u00132\u0003i\u0011w\u000eZ=QCJ$8\u000fV8Nk2$\u0018\u000e]1siNTVM]8!#\ty&\r\u0005\u00022A&\u0011\u0011M\r\u0002\b\u001d>$\b.\u001b8h!\t\t4-\u0003\u0002ee\t\u0019\u0011I\\=\u0002+\t|G-\u001f)beR\u001cHk\\'vYRL\u0007/\u0019:ugR\u0019qM\\;\u0011\u0007m\u0002\u0005\u000eE\u0002D\u0017&\u0004$A\u001b7\u0011\u0007A;6\u000e\u0005\u0002[Y\u0012IQ.BA\u0001\u0002\u0003\u0015\tA\u0018\u0002\u0004?\u0012\u0012\u0004\"B8\u0006\u0001\u0004\u0001\u0018!\u00032pIf\u0004\u0016M\u001d;t!\r\u00195*\u001d\t\u0003eNl\u0011aI\u0005\u0003i\u000e\u0012\u0001BQ8esB\u000b'\u000f\u001e\u0005\u0006m\u0016\u0001\ra^\u0001\bg\u0016\u001c8/[8o!\tAH0D\u0001z\u0015\t1(P\u0003\u0002|O\u0005!1m\u001c:f\u0013\ti\u0018PA\u0004TKN\u001c\u0018n\u001c8)\r\u0015y\u0018qBA\t!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tA\u0001\\1oO*\u0011\u0011\u0011B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0005\r!\u0001E*vaB\u0014Xm]:XCJt\u0017N\\4t\u0003\u00151\u0018\r\\;fY\t\t\u0019\"\t\u0002\u0002\u0016\u0005\u0001sN]4/o\u0006\u0014HO]3n_Z,'OL<beR\u001ch\u0006T5ti\u0006\u0003\b/\u001a8e'\r1\u0011\u0011\u0004\t\u0004[\u0005m\u0011bAA\u000fC\tA\"+Z9vKN$X\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0002!\r|W.\\8o\u0003R$(/\u001b2vi\u0016\u001c\bcA\u0017\u0002$%\u0019\u0011QE\u0011\u0003!\r{W.\\8o\u0003R$(/\u001b2vi\u0016\u001c\u0018A\u00045uiB\fE\u000f\u001e:jEV$Xm\u001d\t\u0004[\u0005-\u0012bAA\u0017C\tq\u0001\n\u001e;q\u0003R$(/\u001b2vi\u0016\u001c\u0018A\u00035uiB\u001c\u0015m\u00195fgB!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028\u0015\nQaY1dQ\u0016LA!a\u000f\u00026\tQ\u0001\n\u001e;q\u0007\u0006\u001c\u0007.Z:\u0002\u0019!$H\u000f\u001d)s_R|7m\u001c7\u0011\t\u0005\u0005\u0013qI\u0007\u0003\u0003\u0007R1!!\u0012&\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA%\u0003\u0007\u0012A\u0002\u0013;uaB\u0013x\u000e^8d_2\fQbY8oM&<WO]1uS>t\u0007\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M#0\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003/\n\tF\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\u000b\r\u00037\ni&a\u0018\u0002b\u0005\r\u0014Q\r\t\u0003[\u0019Aq!a\b\r\u0001\u0004\t\t\u0003C\u0004\u0002(1\u0001\r!!\u000b\t\u000f\u0005=B\u00021\u0001\u00022!9\u0011Q\b\u0007A\u0002\u0005}\u0002bBA&\u0019\u0001\u0007\u0011QJ\u0001%[\u0016\u0014x-\u001a$pe6\u0004\u0016M]1ng\u0006sGMR8s[&sGo\u001c)be\u0006l'\nT5tiRA\u00111NA@\u0003\u0017\u000b9\r\u0005\u0003<\u0001\u00065\u0004CBA8\u0003k\n9(\u0004\u0002\u0002r)!\u00111OA\u0004\u0003\u0011)H/\u001b7\n\u00071\u000b\t\b\u0005\u0003\u0002z\u0005mT\"A+\n\u0007\u0005uTKA\u0003QCJ\fW\u000eC\u0004\u0002\u00026\u0001\r!a!\u0002\rA\f'/Y7t!\u0011\u00195*!\"\u0011\u00075\n9)C\u0002\u0002\n\u0006\u0012\u0011\u0002\u0013;uaB\u000b'/Y7\t\u000f\u00055U\u00021\u0001\u0002\u0010\u0006IQ.Y=cK\u001a{'/\u001c\t\u0006c\u0005E\u0015QS\u0005\u0004\u0003'\u0013$AB(qi&|g\u000e\u0005\u0004\u0002\u0018\u0006-\u0016\u0011\u0017\b\u0005\u00033\u000bIK\u0004\u0003\u0002\u001c\u0006\u001df\u0002BAO\u0003KsA!a(\u0002$:\u0019Q)!)\n\u0003)J!\u0001K\u0015\n\u0005m<\u0013B\u0001<{\u0013\tQ\u00150\u0003\u0003\u0002.\u0006=&AC#yaJ,7o]5p]*\u0011!*\u001f\t\b\u0003g\u000bY,!1c\u001d\u0011\t),a.\u0011\u0005\u0015\u0013\u0014bAA]e\u00051\u0001K]3eK\u001aLA!!0\u0002@\n\u0019Q*\u00199\u000b\u0007\u0005e&\u0007\u0005\u0003\u00024\u0006\r\u0017\u0002BAc\u0003\u007f\u0013aa\u0015;sS:<\u0007\"\u0002<\u000e\u0001\u00049\u0018AG2p]\u001aLw-\u001e:f\u001bVdG/\u001b9beR4uN]7ECR\fGCBAg\u0003/\fI\u000e\r\u0003\u0002P\u0006M\u0007\u0003B\u001eA\u0003#\u00042AWAj\t)\t)NDA\u0001\u0002\u0003\u0015\tA\u0018\u0002\u0004?\u0012\u001a\u0004\"\u0002<\u000f\u0001\u00049\bbBAn\u001d\u0001\u0007\u0011Q\\\u0001\u000fe\u0016\fX/Z:u\u0005VLG\u000eZ3s!\u0011\tI(a8\n\u0007\u0005\u0005XK\u0001\bSKF,Xm\u001d;Ck&dG-\u001a:\u0002/\r|gNZ5hkJ,gi\u001c:n+JdWI\\2pI\u0016$GCBAt\u0003c\f\u0019\u0010\r\u0003\u0002j\u00065\b\u0003B\u001eA\u0003W\u00042AWAw\t)\tyoDA\u0001\u0002\u0003\u0015\tA\u0018\u0002\u0004?\u0012\"\u0004\"\u0002<\u0010\u0001\u00049\bbBAn\u001f\u0001\u0007\u0011Q\\\u0001\"[\u0006L(-\u001a*fcV,7\u000f\u001e\"pIf\u0014U/\u001b7eKJ,\u0005\u0010\u001d:fgNLwN\\\u000b\u0003\u0003s\u0004R!MAI\u0003w\u0004b!a&\u0002,\u0006u\b\u0003BA\u0000\u0005\u0003i\u0011aU\u0005\u0004\u0005\u0007\u0019&A\u0005*fcV,7\u000f\u001e\"pIf\u0014U/\u001b7eKJ\f!%\\1zE\u0016\u0014V-];fgR\u0014u\u000eZ=Ck&dG-\u001a:FqB\u0014Xm]:j_:\u0004\u0013\u0001\u00035bgB\u000b'\u000f^:\u0016\u0005\t-\u0001cA\u0019\u0003\u000e%\u0019!q\u0002\u001a\u0003\u000f\t{w\u000e\\3b]\u0006I\u0001.Y:QCJ$8\u000fI\u0001\bQ\u0006\u001chi\u001c:n\u0003!A\u0017m\u001d$pe6\u0004\u0013!D2p]\u001aLw-\u001e:f\u0005>$\u0017\u0010\u0006\u0004\u0003\u001c\t\u0015\"q\u0005\u0019\u0005\u0005;\u0011\t\u0003\u0005\u0003<\u0001\n}\u0001c\u0001.\u0003\"\u0011Q!1\u0005\f\u0002\u0002\u0003\u0005)\u0011\u00010\u0003\u0007}#S\u0007C\u0003w-\u0001\u0007q\u000fC\u0004\u0002\\Z\u0001\r!!8\u0002\u0017\u0015t\u0017M\u00197f\u0011R$\bOM\u0001\rK:\f'\r\\3IiR\u0004(\u0007I\u0001\u0018G>tg-[4ve\u0016\u0004&/[8s\u0017:|w\u000f\\3eO\u0016$bA!\r\u00038\te\u0002cA\u0019\u00034%\u0019!Q\u0007\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0006mf\u0001\ra\u001e\u0005\b\u00037L\u0002\u0019AAo\u00039\u0011X-];fgR$\u0016.\\3pkR,\"Aa\u0010\u0011\u0007E\u0012\t%C\u0002\u0003DI\u0012A\u0001T8oO\u0006y!/Z9vKN$H+[7f_V$\b%A\fd_:4\u0017nZ;sKJ+\u0017/^3tiRKW.Z8viR!!\u0011\u0007B&\u0011\u001d\tY\u000e\ba\u0001\u0003;\f\u0011dY8oM&<WO]3Qe>$xnY8m'B,7-\u001b4jGR1!\u0011\u000bB.\u0005;\u0002DAa\u0015\u0003XA!1\b\u0011B+!\rQ&q\u000b\u0003\u000b\u00053j\u0012\u0011!A\u0001\u0006\u0003q&aA0%m!)a/\ba\u0001o\"9\u00111\\\u000fA\u0002\u0005u\u0017aF2p]\u001aLw-\u001e:f\u0007\u0006\u001c\u0007.\u001b8h\u0011\u0016\fG-\u001a:t)\u0019\u0011\tDa\u0019\u0003f!)aO\ba\u0001o\"1AE\ba\u0001\u0005O\u0002B!!\u001f\u0003j%\u0019!1N+\u0003\u000fI+\u0017/^3ti\u0006)!-^5mIV\u0011!\u0011\u000f\t\u0007\u0003/\u000bYKa\u001a")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final HttpAttributes httpAttributes;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final GatlingConfiguration configuration;
    private final Option<Function1<Session, Validation<RequestBodyBuilder>>> maybeRequestBodyBuilderExpression;
    private final boolean hasParts;
    private final boolean hasForm;
    private final boolean enableHttp2;
    private final long requestTimeout;

    private Validation<java.util.List<Param>> mergeFormParamsAndFormIntoParamJList(List<HttpParam> params, Option<Function1<Session, Validation<Map<String, Object>>>> maybeForm, Session session) {
        Validation<java.util.List<Param>> formParams = package$.MODULE$.resolveParamJList(params, session);
        Option<Function1<Session, Validation<Map<String, Object>>>> option = maybeForm;
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 form = (Function1)some.value();
            return formParams.flatMap((Function1 & Serializable)resolvedFormParams -> ((Validation)form.apply((Object)session)).map((Function1 & Serializable)resolvedForm -> {
                Map formParamsByName = CollectionConverters$.MODULE$.ListHasAsScala(resolvedFormParams).asScala().groupBy((Function1 & Serializable)x$1 -> x$1.getName());
                Map formFieldsByName = (Map)resolvedForm.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        Object value2 = tuple2._2();
                        Object object = value2;
                        if (object instanceof scala.collection.immutable.Seq) {
                            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)object;
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), seq.map((Function1 & Serializable)value -> new Param(key, value.toString())));
                        }
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new .colon.colon((Object)new Param(key, object.toString()), (List)Nil$.MODULE$));
                    }
                    throw new MatchError((Object)tuple2);
                });
                java.util.List javaParams = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)((MapOps)formFieldsByName.$plus$plus((IterableOnce)formParamsByName)).values().flatten(Predef$.MODULE$.$conforms())).toSeq()).asJava();
                return javaParams;
            }));
        }
        return formParams;
    }

    private Validation<?> configureMultipartFormData(Session session, RequestBuilder requestBuilder) {
        return this.mergeFormParamsAndFormIntoParamJList(this.httpAttributes.formParams(), this.httpAttributes.form(), session).flatMap((Function1 & Serializable)params -> {
            Buffer stringParts = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(params).asScala().map((Function1 & Serializable)param -> new StringPart(param.getName(), param.getValue(), this.charset(), null, null, null, null, null));
            return HttpRequestExpressionBuilder$.MODULE$.io$gatling$http$request$builder$HttpRequestExpressionBuilder$$bodyPartsToMultiparts($this.httpAttributes.bodyParts(), session).map((Function1 & Serializable)parts -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new MultipartFormDataRequestBodyBuilder(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)stringParts.$plus$plus((IterableOnce)parts)).asJava())));
        });
    }

    private Validation<?> configureFormUrlEncoded(Session session, RequestBuilder requestBuilder) {
        return this.mergeFormParamsAndFormIntoParamJList(this.httpAttributes.formParams(), this.httpAttributes.form(), session).map((Function1 & Serializable)params -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new FormUrlEncodedRequestBodyBuilder(params)));
    }

    private Option<Function1<Session, Validation<RequestBodyBuilder>>> maybeRequestBodyBuilderExpression() {
        return this.maybeRequestBodyBuilderExpression;
    }

    private boolean hasParts() {
        return this.hasParts;
    }

    private boolean hasForm() {
        return this.hasForm;
    }

    private Validation<?> configureBody(Session session, RequestBuilder requestBuilder) {
        Option<Function1<Session, Validation<RequestBodyBuilder>>> option = this.maybeRequestBodyBuilderExpression();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function1 requestBodyBuilderExpression = (Function1)some.value();
            return ((Validation)requestBodyBuilderExpression.apply((Object)session)).map((Function1 & Serializable)x$1 -> requestBuilder.setBodyBuilder(x$1));
        }
        if (this.hasParts() || this.hasForm() && HttpHelper$.MODULE$.isMultipartFormData(requestBuilder.getContentType())) {
            return this.configureMultipartFormData(session, requestBuilder);
        }
        if (this.hasForm()) {
            return this.configureFormUrlEncoded(session, requestBuilder);
        }
        return Validation$.MODULE$.unit();
    }

    private boolean enableHttp2() {
        return this.enableHttp2;
    }

    private void configurePriorKnowledge(Session session, RequestBuilder requestBuilder) {
        if (this.enableHttp2()) {
            Option<Object> http2PriorKnowledge = Http2PriorKnowledgeSupport$.MODULE$.isHttp2PriorKnowledge(session, Remote$.MODULE$.apply(requestBuilder.getUri()));
            requestBuilder.setHttp2Enabled(true).setAlpnRequired(http2PriorKnowledge.forall((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestExpressionBuilder.$anonfun$configurePriorKnowledge$1(BoxesRunTime.unboxToBoolean((Object)x$11))))).setHttp2PriorKnowledge(http2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            return;
        }
    }

    private long requestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public void configureRequestTimeout(RequestBuilder requestBuilder) {
        requestBuilder.setRequestTimeout(this.requestTimeout());
    }

    @Override
    public Validation<?> configureProtocolSpecific(Session session, RequestBuilder requestBuilder) {
        return this.configureBody(session, requestBuilder).map((Function1 & Serializable)x$12 -> {
            Object object = x$12;
            this.configurePriorKnowledge(session, requestBuilder);
            return BoxedUnit.UNIT;
        });
    }

    private void configureCachingHeaders(Session session, Request request) {
        this.httpCaches.contentCacheEntry(session, request).foreach((Function1 & Serializable)x0$1 -> {
            HttpRequestExpressionBuilder.$anonfun$configureCachingHeaders$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Function1<Session, Validation<Request>> build() {
        Function1<Session, Validation<Request>> exp = super.build();
        if (this.httpProtocol.requestPart().cache()) {
            return (Function1 & Serializable)session -> ((Validation)exp.apply(session)).map((Function1 & Serializable)request -> {
                this.configureCachingHeaders((Session)session, (Request)request);
                return request;
            });
        }
        return exp;
    }

    public static final /* synthetic */ boolean $anonfun$configurePriorKnowledge$1(boolean x$11) {
        return x$11;
    }

    public static final /* synthetic */ void $anonfun$configureCachingHeaders$1(Request request$1, ContentCacheEntry x0$1) {
        ContentCacheEntry contentCacheEntry = x0$1;
        if (contentCacheEntry != null) {
            Option<String> etag = contentCacheEntry.etag();
            Option<String> lastModified = contentCacheEntry.lastModified();
            etag.foreach((Function1 & Serializable)x$13 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_NONE_MATCH, x$13));
            lastModified.foreach((Function1 & Serializable)x$14 -> request$1.getHeaders().set((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE, x$14));
            return;
        }
        throw new MatchError((Object)contentCacheEntry);
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpCaches httpCaches, HttpProtocol httpProtocol, GatlingConfiguration configuration) {
        this.httpAttributes = httpAttributes;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.configuration = configuration;
        super(commonAttributes, httpCaches, httpProtocol, configuration);
        Predef$.MODULE$.require(httpAttributes.body().isEmpty() || httpAttributes.bodyParts().isEmpty(), (Function0 & Serializable)() -> "Can't have both a body and body parts!");
        this.maybeRequestBodyBuilderExpression = httpAttributes.body().map((Function1 & Serializable)x0$1 -> {
            Body body = x0$1;
            if (body instanceof StringBody) {
                StringBody stringBody = (StringBody)body;
                Function1 string = stringBody.string();
                return (Function1 & Serializable)x$3 -> ((Validation)string.apply(x$3)).map((Function1 & Serializable)x$4 -> new StringRequestBodyBuilder(x$4));
            }
            if (body instanceof RawFileBody) {
                RawFileBody rawFileBody = (RawFileBody)body;
                Function1 resourceWithCachedBytes = rawFileBody.resourceAndCachedBytes();
                return (Function1 & Serializable)x$5 -> ((Validation)resourceWithCachedBytes.apply(x$5)).map((Function1 & Serializable)x0$2 -> {
                    ResourceAndCachedBytes resourceAndCachedBytes = x0$2;
                    if (resourceAndCachedBytes != null) {
                        Resource resource = resourceAndCachedBytes.resource();
                        Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                        Option option = cachedBytes;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            byte[] bytes = (byte[])some.value();
                            return new ByteArrayRequestBodyBuilder(bytes, resource.name());
                        }
                        return new FileRequestBodyBuilder(resource.file());
                    }
                    throw new MatchError((Object)resourceAndCachedBytes);
                });
            }
            if (body instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)body;
                Function1 bytes = byteArrayBody.bytes();
                return (Function1 & Serializable)x$6 -> ((Validation)bytes.apply(x$6)).map((Function1 & Serializable)x$7 -> new ByteArrayRequestBodyBuilder(x$7, null));
            }
            if (body instanceof ElBody) {
                ElBody elBody = (ElBody)body;
                return (Function1 & Serializable)x$8 -> ((Validation)elBody.asStringWithCachedBytes().apply(x$8)).map((Function1 & Serializable)chunks -> new StringChunksRequestBodyBuilder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)chunks).asJava()));
            }
            if (body instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)body;
                Function1 is = inputStreamBody.is();
                return (Function1 & Serializable)x$9 -> ((Validation)is.apply(x$9)).map((Function1 & Serializable)x$10 -> new InputStreamRequestBodyBuilder(x$10));
            }
            throw new MatchError((Object)body);
        });
        this.hasParts = httpAttributes.bodyParts().nonEmpty();
        this.hasForm = httpAttributes.formParams().nonEmpty() || httpAttributes.form().nonEmpty();
        this.enableHttp2 = httpProtocol.enginePart().enableHttp2();
        this.requestTimeout = ((FiniteDuration)httpAttributes.requestTimeout().getOrElse((Function0 & Serializable)() -> $this.configuration.http().requestTimeout())).toMillis();
    }
}

