/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.jms;

import io.gatling.core.protocol.Protocol;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.jms.JmsJndiConnectionFactoryBuilder;
import io.gatling.javaapi.jms.JmsMessageMatcher;
import io.gatling.javaapi.jms.internal.JmsMessageMatchers;
import io.gatling.jms.protocol.JmsProtocolBuilderBase;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.jms.ConnectionFactory;

public final class JmsProtocolBuilder
implements ProtocolBuilder {
    private final io.gatling.jms.protocol.JmsProtocolBuilder wrapped;

    public JmsProtocolBuilder(io.gatling.jms.protocol.JmsProtocolBuilder jmsProtocolBuilder) {
        this.wrapped = jmsProtocolBuilder;
    }

    public Protocol protocol() {
        return this.wrapped.build();
    }

    @Nonnull
    public JmsProtocolBuilder credentials(@Nonnull String string, @Nonnull String string2) {
        return new JmsProtocolBuilder(this.wrapped.credentials(string, string2));
    }

    @Nonnull
    public JmsProtocolBuilder usePersistentDeliveryMode() {
        return new JmsProtocolBuilder(this.wrapped.usePersistentDeliveryMode());
    }

    @Nonnull
    public JmsProtocolBuilder useNonPersistentDeliveryMode() {
        return new JmsProtocolBuilder(this.wrapped.useNonPersistentDeliveryMode());
    }

    @Nonnull
    public JmsProtocolBuilder matchByMessageId() {
        return new JmsProtocolBuilder(this.wrapped.matchByMessageId());
    }

    @Nonnull
    public JmsProtocolBuilder matchByCorrelationId() {
        return new JmsProtocolBuilder(this.wrapped.matchByCorrelationId());
    }

    @Nonnull
    public JmsProtocolBuilder messageMatcher(@Nonnull JmsMessageMatcher jmsMessageMatcher) {
        return new JmsProtocolBuilder(this.wrapped.messageMatcher(JmsMessageMatchers.toScala(jmsMessageMatcher)));
    }

    @Nonnull
    public JmsProtocolBuilder replyTimeout(int n) {
        return this.replyTimeout(Duration.ofSeconds(n));
    }

    @Nonnull
    public JmsProtocolBuilder replyTimeout(Duration duration) {
        return new JmsProtocolBuilder(this.wrapped.replyTimeout(Converters.toScalaDuration((Duration)duration)));
    }

    @Nonnull
    public JmsProtocolBuilder listenerThreadCount(int n) {
        return new JmsProtocolBuilder(this.wrapped.listenerThreadCount(n));
    }

    public static final class Base {
        public static final Base INSTANCE = new Base();

        private Base() {
        }

        @Nonnull
        public JmsProtocolBuilder connectionFactory(@Nonnull ConnectionFactory connectionFactory) {
            return new JmsProtocolBuilder(JmsProtocolBuilderBase.connectionFactory((ConnectionFactory)connectionFactory));
        }

        @Nonnull
        public JmsProtocolBuilder connectionFactory(@Nonnull JmsJndiConnectionFactoryBuilder jmsJndiConnectionFactoryBuilder) {
            return new JmsProtocolBuilder(JmsProtocolBuilderBase.connectionFactory((ConnectionFactory)jmsJndiConnectionFactoryBuilder.build()));
        }
    }
}

