/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import io.gatling.jms.client.CachedProducerKey;
import io.gatling.jms.client.JmsProducer;
import io.gatling.jms.client.JmsSessionPool;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005m3A!\u0003\u0006\u0003'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\t\rQ\u0002\u0001\u0015!\u0003&\u0011\u001d)\u0004A1A\u0005\nYBa!\u0013\u0001!\u0002\u00139\u0004\"\u0002&\u0001\t\u0003Y\u0005\"\u0002,\u0001\t\u00039&a\u0004&ngB\u0013x\u000eZ;dKJ\u0004vn\u001c7\u000b\u0005-a\u0011AB2mS\u0016tGO\u0003\u0002\u000e\u001d\u0005\u0019!.\\:\u000b\u0005=\u0001\u0012aB4bi2Lgn\u001a\u0006\u0002#\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\fg\u0016\u001c8/[8o!>|G\u000e\u0005\u0002\u001d;5\t!\"\u0003\u0002\u001f\u0015\tq!*\\:TKN\u001c\u0018n\u001c8Q_>d\u0017A\u0002\u001fj]&$h\b\u0006\u0002\"EA\u0011A\u0004\u0001\u0005\u00065\t\u0001\raG\u0001\u0014e\u0016<\u0017n\u001d;fe\u0016$\u0007K]8ek\u000e,'o]\u000b\u0002KA\u0019aeK\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0005!!.\u0019<b\u0013\tasEA\u0002TKR\u0004\"A\f\u001a\u000e\u0003=R!!\u0004\u0019\u000b\u0003E\nQA[1wCbL!aM\u0018\u0003\u001f5+7o]1hKB\u0013x\u000eZ;dKJ\fAC]3hSN$XM]3e!J|G-^2feN\u0004\u0013!\u00039s_\u0012,8-\u001a:t+\u00059\u0004\u0003\u0002\u001d<{\u0001k\u0011!\u000f\u0006\u0003u\u001d\n!bY8oGV\u0014(/\u001a8u\u0013\ta\u0014HA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u0004\"\u0001\b \n\u0005}R!!E\"bG\",G\r\u0015:pIV\u001cWM]&fsB\u0019\u0011\t\u0012$\u000e\u0003\tS!aQ\u0015\u0002\t1\fgnZ\u0005\u0003\u000b\n\u00131\u0002\u00165sK\u0006$Gj\\2bYB\u0011AdR\u0005\u0003\u0011*\u00111BS7t!J|G-^2fe\u0006Q\u0001O]8ek\u000e,'o\u001d\u0011\u0002\u0011A\u0014x\u000eZ;dKJ$2A\u0012'R\u0011\u0015iu\u00011\u0001O\u0003-!Wm\u001d;j]\u0006$\u0018n\u001c8\u0011\u00059z\u0015B\u0001)0\u0005-!Um\u001d;j]\u0006$\u0018n\u001c8\t\u000bI;\u0001\u0019A*\u0002\u0019\u0011,G.\u001b<feflu\u000eZ3\u0011\u0005U!\u0016BA+\u0017\u0005\rIe\u000e^\u0001\u0006G2|7/\u001a\u000b\u00021B\u0011Q#W\u0005\u00035Z\u0011A!\u00168ji\u0002")
public final class JmsProducerPool {
    private final JmsSessionPool sessionPool;
    private final Set<MessageProducer> registeredProducers;
    private final ConcurrentHashMap<CachedProducerKey, ThreadLocal<JmsProducer>> producers;

    private Set<MessageProducer> registeredProducers() {
        return this.registeredProducers;
    }

    private ConcurrentHashMap<CachedProducerKey, ThreadLocal<JmsProducer>> producers() {
        return this.producers;
    }

    public JmsProducer producer(Destination destination, int deliveryMode) {
        return (JmsProducer)this.producers().computeIfAbsent(new CachedProducerKey(destination, deliveryMode), key -> ThreadLocal.withInitial(() -> {
            Session jmsSession = $this.sessionPool.jmsSession();
            MessageProducer producer = jmsSession.createProducer(key.destination());
            producer.setDeliveryMode(key.deliveryMode());
            this.registeredProducers().add(producer);
            return new JmsProducer(jmsSession, producer);
        })).get();
    }

    public void close() {
        CollectionConverters$.MODULE$.SetHasAsScala(this.registeredProducers()).asScala().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public JmsProducerPool(JmsSessionPool sessionPool) {
        this.sessionPool = sessionPool;
        this.registeredProducers = Collections.newSetFromMap(new ConcurrentHashMap());
        this.producers = new ConcurrentHashMap();
    }
}

