/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.check;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.core.check.Check;
import io.gatling.core.check.CheckMaterializer;
import io.gatling.core.check.bytes.BodyBytesCheckType;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.package$;
import io.gatling.core.check.string.BodyStringCheckType;
import io.gatling.core.check.substring.SubstringCheckType;
import io.gatling.core.check.xpath.XPathCheckType;
import io.gatling.core.check.xpath.XmlParsers$;
import io.gatling.core.json.JsonParsers;
import io.gatling.jms.check.JmsCheckMaterializer;
import io.gatling.jms.check.JmsPropertyCheckType;
import io.gatling.jms.client.CachingMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import net.sf.saxon.s9api.XdmNode;
import scala.Function0;
import scala.Function1;
import scala.runtime.BoxesRunTime;

public final class JmsCheckMaterializer$ {
    public static final JmsCheckMaterializer$ MODULE$ = new JmsCheckMaterializer$();
    private static final Function1<String, String> JsonPreparerErrorMapper = (Function1 & Serializable)x$1 -> "Could not parse response into a JSON: " + x$1;
    private static final CheckMaterializer<XPathCheckType, Check<Message>, Message, XdmNode> Xpath;
    private static final CheckMaterializer<JmsPropertyCheckType, Check<Message>, Message, Message> JmsProperty;

    static {
        Function1 & Serializable errorMapper = (Function1 & Serializable)x$2 -> "Could not parse response into a DOM Document: " + x$2;
        Function1 & Serializable preparer = (Function1 & Serializable)message -> io.gatling.commons.validation.package$.MODULE$.safely(errorMapper, (Function0 & Serializable)() -> {
            Message message = message;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)XmlParsers$.MODULE$.parse(textMessage.getText())));
            }
            return package.FailureWrapper$.MODULE$.failure$extension(io.gatling.commons.validation.package$.MODULE$.FailureWrapper("Unsupported message type"));
        });
        Xpath = new JmsCheckMaterializer<XPathCheckType, XdmNode>(preparer);
        JmsProperty = new JmsCheckMaterializer<JmsPropertyCheckType, Message>(package$.MODULE$.identityPreparer());
    }

    private Function1<Message, Validation<byte[]>> bodyBytesPreparer(Charset charset) {
        return (Function1 & Serializable)x0$1 -> {
            Message message = x0$1;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)textMessage.getText().getBytes(charset)));
            }
            if (message instanceof CachingMessage.Bytes) {
                CachingMessage.Bytes bytes = (CachingMessage.Bytes)message;
                return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)bytes.bytes()));
            }
            return package.FailureWrapper$.MODULE$.failure$extension(io.gatling.commons.validation.package$.MODULE$.FailureWrapper("Unsupported message type"));
        };
    }

    private Function1<Message, Validation<Object>> bodyLengthPreparer(Charset charset) {
        return (Function1 & Serializable)x0$1 -> {
            Message message = x0$1;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)BoxesRunTime.boxToInteger((int)textMessage.getText().getBytes(charset).length)));
            }
            if (message instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)message;
                return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)BoxesRunTime.boxToInteger((int)((int)bytesMessage.getBodyLength()))));
            }
            return package.FailureWrapper$.MODULE$.failure$extension(io.gatling.commons.validation.package$.MODULE$.FailureWrapper("Unsupported message type"));
        };
    }

    private Function1<String, String> JsonPreparerErrorMapper() {
        return JsonPreparerErrorMapper;
    }

    private Function1<Message, Validation<JsonNode>> jsonPreparer(JsonParsers jsonParsers) {
        return (Function1 & Serializable)replyMessage -> io.gatling.commons.validation.package$.MODULE$.safely(MODULE$.JsonPreparerErrorMapper(), (Function0 & Serializable)() -> {
            Message message = replyMessage;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                return jsonParsers.safeParse(textMessage.getText());
            }
            if (message instanceof CachingMessage.Bytes) {
                CachingMessage.Bytes bytes = (CachingMessage.Bytes)message;
                return jsonParsers.safeParse((InputStream)new ByteArrayInputStream(bytes.bytes()));
            }
            return package.FailureWrapper$.MODULE$.failure$extension(io.gatling.commons.validation.package$.MODULE$.FailureWrapper("Unsupported message type"));
        });
    }

    private Function1<Message, Validation<String>> stringBodyPreparer(Charset charset) {
        return (Function1 & Serializable)x0$1 -> {
            Message message = x0$1;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)textMessage.getText()));
            }
            if (message instanceof CachingMessage.Bytes) {
                CachingMessage.Bytes bytes = (CachingMessage.Bytes)message;
                return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)new String(bytes.bytes(), charset)));
            }
            return package.FailureWrapper$.MODULE$.failure$extension(io.gatling.commons.validation.package$.MODULE$.FailureWrapper("Unsupported message type"));
        };
    }

    public CheckMaterializer<BodyStringCheckType, Check<Message>, Message, String> bodyString(Charset charset) {
        return new JmsCheckMaterializer<BodyStringCheckType, String>(this.stringBodyPreparer(charset));
    }

    public CheckMaterializer<BodyBytesCheckType, Check<Message>, Message, byte[]> bodyBytes(Charset charset) {
        return new JmsCheckMaterializer<BodyBytesCheckType, byte[]>(this.bodyBytesPreparer(charset));
    }

    public CheckMaterializer<BodyBytesCheckType, Check<Message>, Message, Object> bodyLength(Charset charset) {
        return new JmsCheckMaterializer<BodyBytesCheckType, Object>(this.bodyLengthPreparer(charset));
    }

    public CheckMaterializer<SubstringCheckType, Check<Message>, Message, String> substring(Charset charset) {
        return new JmsCheckMaterializer<SubstringCheckType, String>(this.stringBodyPreparer(charset));
    }

    public CheckMaterializer<JmesPathCheckType, Check<Message>, Message, JsonNode> jmesPath(JsonParsers jsonParsers) {
        return new JmsCheckMaterializer<JmesPathCheckType, JsonNode>(this.jsonPreparer(jsonParsers));
    }

    public CheckMaterializer<JsonPathCheckType, Check<Message>, Message, JsonNode> jsonPath(JsonParsers jsonParsers) {
        return new JmsCheckMaterializer<JsonPathCheckType, JsonNode>(this.jsonPreparer(jsonParsers));
    }

    public CheckMaterializer<XPathCheckType, Check<Message>, Message, XdmNode> Xpath() {
        return Xpath;
    }

    public CheckMaterializer<JmsPropertyCheckType, Check<Message>, Message, Message> JmsProperty() {
        return JmsProperty;
    }

    private JmsCheckMaterializer$() {
    }
}

