/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import io.gatling.jms.client.CachedProducerKey;
import io.gatling.jms.client.JmsProducer;
import io.gatling.jms.client.JmsSessionPool;
import jakarta.jms.Destination;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005m3A!\u0003\u0006\u0003'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\t\rQ\u0002\u0001\u0015!\u0003&\u0011\u001d)\u0004A1A\u0005\nYBa!\u0013\u0001!\u0002\u00139\u0004\"\u0002&\u0001\t\u0003Y\u0005\"\u0002,\u0001\t\u00039&a\u0004&ngB\u0013x\u000eZ;dKJ\u0004vn\u001c7\u000b\u0005-a\u0011AB2mS\u0016tGO\u0003\u0002\u000e\u001d\u0005\u0019!.\\:\u000b\u0005=\u0001\u0012aB4bi2Lgn\u001a\u0006\u0002#\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\fg\u0016\u001c8/[8o!>|G\u000e\u0005\u0002\u001d;5\t!\"\u0003\u0002\u001f\u0015\tq!*\\:TKN\u001c\u0018n\u001c8Q_>d\u0017A\u0002\u001fj]&$h\b\u0006\u0002\"EA\u0011A\u0004\u0001\u0005\u00065\t\u0001\raG\u0001\u0014e\u0016<\u0017n\u001d;fe\u0016$\u0007K]8ek\u000e,'o]\u000b\u0002KA\u0019aeK\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0005!!.\u0019<b\u0013\tasEA\u0002TKR\u0004\"A\f\u001a\u000e\u0003=R!!\u0004\u0019\u000b\u0003E\nqA[1lCJ$\u0018-\u0003\u00024_\tyQ*Z:tC\u001e,\u0007K]8ek\u000e,'/\u0001\u000bsK\u001eL7\u000f^3sK\u0012\u0004&o\u001c3vG\u0016\u00148\u000fI\u0001\naJ|G-^2feN,\u0012a\u000e\t\u0005qmj\u0004)D\u0001:\u0015\tQt%\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001P\u001d\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002\u001d}%\u0011qH\u0003\u0002\u0012\u0007\u0006\u001c\u0007.\u001a3Qe>$WoY3s\u0017\u0016L\bcA!E\r6\t!I\u0003\u0002DS\u0005!A.\u00198h\u0013\t)%IA\u0006UQJ,\u0017\r\u001a'pG\u0006d\u0007C\u0001\u000fH\u0013\tA%BA\u0006K[N\u0004&o\u001c3vG\u0016\u0014\u0018A\u00039s_\u0012,8-\u001a:tA\u0005A\u0001O]8ek\u000e,'\u000fF\u0002G\u0019FCQ!T\u0004A\u00029\u000b1\u0002Z3ti&t\u0017\r^5p]B\u0011afT\u0005\u0003!>\u00121\u0002R3ti&t\u0017\r^5p]\")!k\u0002a\u0001'\u0006aA-\u001a7jm\u0016\u0014\u00180T8eKB\u0011Q\u0003V\u0005\u0003+Z\u00111!\u00138u\u0003\u0015\u0019Gn\\:f)\u0005A\u0006CA\u000bZ\u0013\tQfC\u0001\u0003V]&$\b")
public final class JmsProducerPool {
    private final JmsSessionPool sessionPool;
    private final Set<MessageProducer> registeredProducers;
    private final ConcurrentHashMap<CachedProducerKey, ThreadLocal<JmsProducer>> producers;

    private Set<MessageProducer> registeredProducers() {
        return this.registeredProducers;
    }

    private ConcurrentHashMap<CachedProducerKey, ThreadLocal<JmsProducer>> producers() {
        return this.producers;
    }

    public JmsProducer producer(Destination destination, int deliveryMode) {
        return (JmsProducer)this.producers().computeIfAbsent(new CachedProducerKey(destination, deliveryMode), key -> ThreadLocal.withInitial(() -> {
            Session jmsSession = $this.sessionPool.jmsSession();
            MessageProducer producer = jmsSession.createProducer(key.destination());
            producer.setDeliveryMode(key.deliveryMode());
            this.registeredProducers().add(producer);
            return new JmsProducer(jmsSession, producer);
        })).get();
    }

    public void close() {
        CollectionConverters$.MODULE$.SetHasAsScala(this.registeredProducers()).asScala().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public JmsProducerPool(JmsSessionPool sessionPool) {
        this.sessionPool = sessionPool;
        this.registeredProducers = Collections.newSetFromMap(new ConcurrentHashMap());
        this.producers = new ConcurrentHashMap();
    }
}

