/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000593A!\u0003\u0006\u0003'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\t\r\u0001\u0003\u0001\u0015!\u0003*\u0011\u001d\t\u0005A1A\u0005\n\tCaA\u0012\u0001!\u0002\u0013\u0019\u0005\"B$\u0001\t\u0003A\u0005\"B%\u0001\t\u0003Q%A\u0004&ngN+7o]5p]B{w\u000e\u001c\u0006\u0003\u00171\taa\u00197jK:$(BA\u0007\u000f\u0003\rQWn\u001d\u0006\u0003\u001fA\tqaZ1uY&twMC\u0001\u0012\u0003\tIwn\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-\u0001\u0006d_:tWm\u0019;j_:\u0004\"\u0001\b\u0011\u000e\u0003uQ!!\u0004\u0010\u000b\u0003}\tqA[1lCJ$\u0018-\u0003\u0002\";\tQ1i\u001c8oK\u000e$\u0018n\u001c8\u0002\rqJg.\u001b;?)\t!c\u0005\u0005\u0002&\u00015\t!\u0002C\u0003\u001b\u0005\u0001\u00071$A\u000bsK\u001eL7\u000f^3sK\u0012TUn]*fgNLwN\\:\u0016\u0003%\u0002BA\u000b\u001b8u9\u00111FM\u0007\u0002Y)\u0011QFL\u0001\u000bG>t7-\u001e:sK:$(BA\u00181\u0003\u0011)H/\u001b7\u000b\u0003E\nAA[1wC&\u00111\u0007L\u0001\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\u0018BA\u001b7\u0005)YU-_*fiZKWm\u001e\u0006\u0003g1\u0002\"\u0001\b\u001d\n\u0005ej\"aB*fgNLwN\u001c\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{A\nA\u0001\\1oO&\u0011q\b\u0010\u0002\b\u0005>|G.Z1o\u0003Y\u0011XmZ5ti\u0016\u0014X\r\u001a&ngN+7o]5p]N\u0004\u0013a\u00036ngN+7o]5p]N,\u0012a\u0011\t\u0004w\u0011;\u0014BA#=\u0005-!\u0006N]3bI2{7-\u00197\u0002\u0019)l7oU3tg&|gn\u001d\u0011\u0002\u0015)l7oU3tg&|g\u000eF\u00018\u0003\u0015\u0019Gn\\:f)\u0005Y\u0005CA\u000bM\u0013\tieC\u0001\u0003V]&$\b")
public final class JmsSessionPool {
    private final Connection connection;
    private final ConcurrentHashMap.KeySetView<Session, Boolean> registeredJmsSessions;
    private final ThreadLocal<Session> jmsSessions;

    private ConcurrentHashMap.KeySetView<Session, Boolean> registeredJmsSessions() {
        return this.registeredJmsSessions;
    }

    private ThreadLocal<Session> jmsSessions() {
        return this.jmsSessions;
    }

    public Session jmsSession() {
        return this.jmsSessions().get();
    }

    public void close() {
        CollectionConverters$.MODULE$.SetHasAsScala(this.registeredJmsSessions()).asScala().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public JmsSessionPool(Connection connection) {
        this.connection = connection;
        this.registeredJmsSessions = ConcurrentHashMap.newKeySet();
        this.jmsSessions = ThreadLocal.withInitial(() -> {
            Session s = $this.connection.createSession(false, 1);
            this.registeredJmsSessions().add(s);
            return s;
        });
    }
}

