/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;

public class GatlingMojoUtils {
    private GatlingMojoUtils() {
        throw new AssertionError();
    }

    public static String toMultiPath(List<String> paths) {
        return StringUtils.join(paths.iterator(), (String)File.pathSeparator);
    }

    public static String fileNameToClassName(String fileName) {
        String trimmedFileName = StringUtils.trim((String)fileName);
        int lastIndexOfExtensionDelim = trimmedFileName.lastIndexOf(".");
        String strippedFileName = lastIndexOfExtensionDelim > 0 ? trimmedFileName.substring(0, lastIndexOfExtensionDelim) : trimmedFileName;
        return strippedFileName.replace(File.separatorChar, '.');
    }

    public static String locateJar(Class<?> c) throws Exception {
        String classLocation = c.getName().replace('.', '/') + ".class";
        ClassLoader loader = c.getClassLoader();
        URL location = loader == null ? ClassLoader.getSystemResource(classLocation) : loader.getResource(classLocation);
        if (location != null) {
            Pattern p = Pattern.compile("^.*file:(.*)!.*$");
            Matcher m = p.matcher(location.toString());
            if (m.find()) {
                return URLDecoder.decode(m.group(1), "UTF-8");
            }
            throw new ClassNotFoundException("Cannot parse location of '" + location + "'.  Probably not loaded from a Jar");
        }
        throw new ClassNotFoundException("Cannot find class '" + c.getName() + " using the classloader");
    }
}

