/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.Fork;
import io.gatling.mojo.GatlingMojo;
import io.gatling.mojo.MojoConstants;
import io.gatling.mojo.MojoUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

@Mojo(name="recorder", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class RecorderMojo
extends AbstractMojo {
    @Parameter(property="gatling.recorder.localPort", alias="lp")
    private Integer localPort;
    @Parameter(property="gatling.recorder.proxyHost", alias="ph")
    private String proxyHost;
    @Parameter(property="gatling.recorder.proxyPort", alias="pp")
    private Integer proxyPort;
    @Parameter(property="gatling.recorder.proxySslPort", alias="pps")
    private Integer proxySSLPort;
    @Parameter(property="gatling.recorder.outputFolder", alias="of", defaultValue="${basedir}/src/test/scala")
    private String outputFolder;
    @Parameter(property="gatling.recorder.bodiesFolder", alias="bdf", defaultValue="${basedir}/src/test/resources/bodies")
    private String bodiesFolder;
    @Parameter(property="gatling.recorder.className", alias="cn")
    private String className;
    @Parameter(property="gatling.recorder.package", alias="pkg", defaultValue="${project.groupId}")
    private String packageName;
    @Parameter(property="gatling.recorder.encoding", alias="enc")
    private String encoding;
    @Parameter(property="gatling.recorder.followRedirect", alias="fr")
    private Boolean followRedirect;
    @Parameter(property="gatling.configFolder", alias="cd", defaultValue="${basedir}/src/test/resources")
    private File configFolder;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String testClasspath = this.buildTestClasspath();
            this.getLog().info((CharSequence)testClasspath);
            List<String> recorderArgs = this.recorderArgs();
            Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            Fork forkedRecorder = new Fork("io.gatling.recorder.GatlingRecorder", testClasspath, MojoConstants.GATLING_JVM_ARGS, recorderArgs, toolchain, false);
            forkedRecorder.run();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Recorder execution failed", e);
        }
    }

    private String buildTestClasspath() throws Exception {
        List testClasspathElements = this.mavenProject.getTestClasspathElements();
        testClasspathElements.add(this.configFolder.getPath());
        testClasspathElements.add(MojoUtils.locateJar(GatlingMojo.class));
        return MojoUtils.toMultiPath(testClasspathElements);
    }

    private List<String> recorderArgs() {
        ArrayList<String> arguments = new ArrayList<String>();
        this.addToArgsIfNotNull(arguments, this.outputFolder, "of");
        this.addToArgsIfNotNull(arguments, this.bodiesFolder, "bdf");
        this.addToArgsIfNotNull(arguments, this.localPort, "lp");
        this.addToArgsIfNotNull(arguments, this.proxyHost, "ph");
        this.addToArgsIfNotNull(arguments, this.proxyPort, "pp");
        this.addToArgsIfNotNull(arguments, this.proxySSLPort, "pps");
        this.addToArgsIfNotNull(arguments, this.className, "cn");
        this.addToArgsIfNotNull(arguments, this.packageName, "pkg");
        this.addToArgsIfNotNull(arguments, this.encoding, "enc");
        this.addToArgsIfNotNull(arguments, this.followRedirect, "fr");
        return arguments;
    }

    private void addToArgsIfNotNull(List<String> args, Object value, String flag) {
        if (value != null) {
            args.addAll(Arrays.asList("-" + flag, value.toString()));
        }
    }
}

