/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractGatlingExecutionMojo;
import io.gatling.mojo.CompilationException;
import io.gatling.mojo.Fork;
import io.gatling.mojo.GatlingSimulationAssertionsFailedException;
import io.gatling.mojo.MojoConstants;
import io.gatling.mojo.MojoUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.exec.ExecuteException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class GatlingMojo
extends AbstractGatlingExecutionMojo {
    @Parameter(property="gatling.simulationClass")
    private String simulationClass;
    @Parameter(property="gatling.runMultipleSimulations", defaultValue="false")
    private boolean runMultipleSimulations;
    @Parameter(property="gatling.includes")
    private String[] includes;
    @Parameter(property="gatling.excludes")
    private String[] excludes;
    @Parameter(property="gatling.noReports", defaultValue="false")
    private boolean noReports;
    @Parameter(property="gatling.reportsOnly")
    private String reportsOnly;
    @Parameter(property="gatling.runDescription")
    private String runDescription;
    @Parameter(property="gatling.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="gatling.continueOnAssertionFailure", defaultValue="false")
    private boolean continueOnAssertionFailure;
    @Parameter(property="gatling.useOldJenkinsJUnitSupport", defaultValue="false")
    private boolean useOldJenkinsJUnitSupport;
    @Parameter(property="gatling.jvmArgs")
    private List<String> jvmArgs;
    @Parameter(property="gatling.overrideJvmArgs", defaultValue="false")
    private boolean overrideJvmArgs;
    @Parameter(property="gatling.propagateSystemProperties", defaultValue="true")
    private boolean propagateSystemProperties;
    @Parameter(property="gatling.compilerJvmArgs")
    private List<String> compilerJvmArgs;
    @Parameter(property="gatling.overrideCompilerJvmArgs", defaultValue="false")
    private boolean overrideCompilerJvmArgs;
    @Parameter(property="gatling.extraScalacOptions")
    private List<String> extraScalacOptions;
    @Parameter(property="gatling.disableCompiler", defaultValue="false")
    private boolean disableCompiler;
    @Parameter(property="gatling.simulationsFolder", defaultValue="${project.basedir}/src/test/scala")
    private File simulationsFolder;
    @Parameter(property="gatling.resourcesFolder", defaultValue="${project.basedir}/src/test/resources")
    private File resourcesFolder;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    private List<Artifact> artifacts;
    private Set<File> existingDirectories;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping gatling-maven-plugin");
            return;
        }
        this.resultsFolder.mkdirs();
        this.existingDirectories = this.directoriesInResultsFolder();
        try {
            List<String> testClasspath = this.buildTestClasspath();
            Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            if (!this.disableCompiler) {
                this.executeCompiler(this.compilerJvmArgs(), testClasspath, toolchain);
            }
            List<String> jvmArgs = this.gatlingJvmArgs();
            if (this.reportsOnly != null) {
                this.executeGatling(jvmArgs, this.gatlingArgs(null), testClasspath, toolchain);
            } else {
                List<String> simulations = this.simulations();
                this.iterateBySimulations(toolchain, jvmArgs, testClasspath, simulations);
            }
        }
        catch (Exception e) {
            if (this.failOnError) {
                if (e instanceof GatlingSimulationAssertionsFailedException) {
                    throw new MojoFailureException(e.getMessage(), (Throwable)e);
                }
                if (e instanceof MojoFailureException) {
                    throw (MojoFailureException)e;
                }
                if (e instanceof MojoExecutionException) {
                    throw (MojoExecutionException)e;
                }
                throw new MojoExecutionException("Gatling failed.", e);
            }
            this.getLog().warn((CharSequence)"There were some errors while running your simulation, but failOnError was set to false won't fail your build.");
        }
        finally {
            this.recordSimulationResults();
        }
    }

    private Set<File> directoriesInResultsFolder() {
        File[] directories = this.resultsFolder.listFiles(File::isDirectory);
        return directories == null ? Collections.emptySet() : new HashSet<File>(Arrays.asList(directories));
    }

    private void iterateBySimulations(Toolchain toolchain, List<String> jvmArgs, List<String> testClasspath, List<String> simulations) throws Exception {
        GatlingSimulationAssertionsFailedException exc = null;
        int simulationsCount = simulations.size();
        for (int i = 0; i < simulationsCount; ++i) {
            try {
                this.executeGatling(jvmArgs, this.gatlingArgs(simulations.get(i)), testClasspath, toolchain);
                continue;
            }
            catch (GatlingSimulationAssertionsFailedException e) {
                if (exc == null && i == simulationsCount - 1) {
                    throw e;
                }
                if (this.continueOnAssertionFailure) {
                    if (exc != null) continue;
                    exc = e;
                    continue;
                }
                throw e;
            }
        }
        if (exc != null) {
            this.getLog().warn((CharSequence)"There were some errors while running your simulation, but continueOnAssertionFailure was set to true, so your simulations continue to perform.");
            throw exc;
        }
    }

    private void executeCompiler(List<String> zincJvmArgs, List<String> testClasspath, Toolchain toolchain) throws Exception {
        List<String> compilerClasspath = this.buildCompilerClasspath();
        compilerClasspath.addAll(testClasspath);
        List<String> compilerArguments = this.compilerArgs();
        Fork forkedCompiler = new Fork("io.gatling.compiler.ZincCompiler", compilerClasspath, zincJvmArgs, compilerArguments, toolchain, false, this.getLog());
        try {
            forkedCompiler.run();
        }
        catch (ExecuteException e) {
            throw new CompilationException(e);
        }
    }

    private void executeGatling(List<String> gatlingJvmArgs, List<String> gatlingArgs, List<String> testClasspath, Toolchain toolchain) throws Exception {
        Fork forkedGatling = new Fork("io.gatling.app.Gatling", testClasspath, gatlingJvmArgs, gatlingArgs, toolchain, this.propagateSystemProperties, this.getLog());
        try {
            forkedGatling.run();
        }
        catch (ExecuteException e) {
            if (e.getExitValue() == 2) {
                throw new GatlingSimulationAssertionsFailedException(e);
            }
            throw e;
        }
    }

    private void recordSimulationResults() throws MojoExecutionException {
        try {
            this.saveListOfNewRunDirectories();
            this.copyJUnitReports();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not record simulation results.", (Exception)e);
        }
    }

    private void saveListOfNewRunDirectories() throws IOException {
        Path resultsFile = this.resultsFolder.toPath().resolve("lastRun.txt");
        try (BufferedWriter writer = Files.newBufferedWriter(resultsFile, new OpenOption[0]);){
            for (File directory : this.directoriesInResultsFolder()) {
                if (!this.isNewDirectory(directory)) continue;
                writer.write(directory.getName() + System.lineSeparator());
            }
        }
    }

    private boolean isNewDirectory(File directory) {
        return !this.existingDirectories.contains(directory);
    }

    private void copyJUnitReports() throws MojoExecutionException {
        try {
            if (this.useOldJenkinsJUnitSupport) {
                for (File directory : this.directoriesInResultsFolder()) {
                    File assertionFile;
                    File jsDir = new File(directory, "js");
                    if (!jsDir.exists() || !jsDir.isDirectory() || !(assertionFile = new File(jsDir, "assertions.xml")).exists()) continue;
                    File newAssertionFile = new File(this.resultsFolder, "assertions-" + directory.getName() + ".xml");
                    Files.copy(assertionFile.toPath(), newAssertionFile.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    this.getLog().info((CharSequence)("Copying assertion file " + assertionFile.getCanonicalPath() + " to " + newAssertionFile.getCanonicalPath()));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy JUnit reports", (Exception)e);
        }
    }

    private List<String> buildCompilerClasspath() throws Exception {
        ArrayList<String> compilerClasspathElements = new ArrayList<String>();
        for (Artifact artifact : this.artifacts) {
            String groupId = artifact.getGroupId();
            if (groupId.startsWith("org.codehaus.plexus") || groupId.startsWith("org.apache.maven") || groupId.startsWith("org.sonatype")) continue;
            compilerClasspathElements.add(artifact.getFile().getCanonicalPath());
        }
        String gatlingVersion = this.getVersion("io.gatling", "gatling-core");
        Set gatlingCompilerAndDeps = this.resolve("io.gatling", "gatling-compiler", gatlingVersion, true).getArtifacts();
        for (Artifact artifact : gatlingCompilerAndDeps) {
            compilerClasspathElements.add(artifact.getFile().getCanonicalPath());
        }
        compilerClasspathElements.add(MojoUtils.locateJar(GatlingMojo.class));
        return compilerClasspathElements;
    }

    private List<String> gatlingJvmArgs() {
        return this.computeArgs(this.jvmArgs, MojoConstants.GATLING_JVM_ARGS, this.overrideJvmArgs);
    }

    private List<String> compilerJvmArgs() {
        return this.computeArgs(this.compilerJvmArgs, MojoConstants.COMPILER_JVM_ARGS, this.overrideCompilerJvmArgs);
    }

    private List<String> computeArgs0(List<String> custom, List<String> defaults, boolean override) {
        if (custom.isEmpty()) {
            return defaults;
        }
        if (override) {
            ArrayList<String> merged = new ArrayList<String>(custom);
            merged.addAll(defaults);
            return merged;
        }
        return custom;
    }

    private List<String> computeArgs(List<String> custom, List<String> defaults, boolean override) {
        ArrayList<String> result = new ArrayList<String>(this.computeArgs0(custom, defaults, override));
        result.add("-Djdk.net.URLClassPath.disableClassPathURLCheck=true");
        return result;
    }

    private List<String> simulations() throws MojoFailureException {
        if (this.simulationClass != null) {
            return Collections.singletonList(this.simulationClass);
        }
        List<String> simulations = this.resolveSimulations();
        if (simulations.isEmpty()) {
            this.getLog().error((CharSequence)"No simulations to run");
            throw new MojoFailureException("No simulations to run");
        }
        if (simulations.size() > 1 && !this.runMultipleSimulations) {
            String message = "More than 1 simulation to run, need to specify one, or enable runMultipleSimulations";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        return simulations;
    }

    private List<String> gatlingArgs(String simulationClass) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "rsf", this.resourcesFolder.getCanonicalPath());
        this.addArg(args, "rf", this.resultsFolder.getCanonicalPath());
        this.addArg(args, "sf", this.simulationsFolder.getCanonicalPath());
        this.addArg(args, "rd", this.runDescription);
        if (this.noReports) {
            args.add("-nr");
        }
        this.addArg(args, "s", simulationClass);
        this.addArg(args, "ro", this.reportsOnly);
        return args;
    }

    private List<String> compilerArgs() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        this.addArg(args, "sf", this.simulationsFolder.getCanonicalPath());
        this.addArg(args, "bf", this.compiledClassesFolder.getCanonicalPath());
        if (!this.extraScalacOptions.isEmpty()) {
            this.addArg(args, "eso", StringUtils.join(this.extraScalacOptions.iterator(), (String)","));
        }
        return args;
    }

    private List<String> resolveSimulations() {
        try {
            URLClassLoader testClassLoader = new URLClassLoader(this.testClassPathUrls());
            Class<?> simulationClass = testClassLoader.loadClass("io.gatling.core.scenario.Simulation");
            List<String> includes = MojoUtils.arrayAsListEmptyIfNull(this.includes);
            List<String> excludes = MojoUtils.arrayAsListEmptyIfNull(this.excludes);
            ArrayList<String> simulationsClasses = new ArrayList<String>();
            for (String classFile : this.compiledClassFiles()) {
                Class<?> clazz;
                String className = this.pathToClassName(classFile);
                boolean isIncluded = includes.isEmpty() || GatlingMojo.match(includes, className);
                boolean isExcluded = GatlingMojo.match(excludes, className);
                if (!isIncluded || isExcluded || !simulationClass.isAssignableFrom(clazz = testClassLoader.loadClass(className)) || !this.isConcreteClass(clazz)) continue;
                simulationsClasses.add(className);
            }
            return simulationsClasses;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean match(List<String> patterns, String string) {
        for (String pattern : patterns) {
            if (!SelectorUtils.match((String)pattern, (String)string)) continue;
            return true;
        }
        return false;
    }

    private URL[] testClassPathUrls() throws DependencyResolutionRequiredException, MalformedURLException {
        List testClasspathElements = this.mavenProject.getTestClasspathElements();
        URL[] urls = new URL[testClasspathElements.size()];
        for (int i = 0; i < testClasspathElements.size(); ++i) {
            URL url;
            String testClasspathElement = (String)testClasspathElements.get(i);
            urls[i] = url = Paths.get(testClasspathElement, new String[0]).toUri().toURL();
        }
        return urls;
    }

    private String[] compiledClassFiles() throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.compiledClassesFolder.getCanonicalPath());
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        Object[] files = scanner.getIncludedFiles();
        Arrays.sort(files);
        return files;
    }

    private String pathToClassName(String path) {
        return path.substring(0, path.length() - ".class".length()).replace(File.separatorChar, '.');
    }

    private boolean isConcreteClass(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }
}

