/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.EnterpriseUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.SelectorUtils;
import org.zeroturnaround.zip.ZipUtil;
import org.zeroturnaround.zip.commons.FileUtilsV2_2;

@Execute(phase=LifecyclePhase.TEST_COMPILE)
@Mojo(name="enterprisePackage", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class EnterprisePackageMojo
extends AbstractMojo {
    private static final String[] ALWAYS_EXCLUDES = new String[]{"META-INF/LICENSE", "META-INF/MANIFEST.MF", "META-INF/versions/**", "META-INF/maven/**", "*.SF", "*.DSA", "*.RSA"};
    private static String GATLING_GROUP_ID = "io.gatling";
    private static String GATLING_HIGHCHARTS_GROUP_ID = "io.gatling.highcharts";
    private static String GATLING_FRONTLINE_GROUP_ID = "io.gatling.frontline";
    private static Set<String> GATLING_GROUP_IDS;
    @Component
    private RepositorySystem repository;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="shaded")
    private String shadedClassifier;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetPath;

    private Set<Artifact> nonGatlingDependencies(Artifact artifact) {
        if (artifact == null) {
            return Collections.emptySet();
        }
        return this.resolveTransitively(artifact).stream().filter(art -> !GATLING_GROUP_IDS.contains(art.getGroupId())).collect(Collectors.toSet());
    }

    private void deprecatedFrontLineMavenPluginWarning() throws MojoFailureException {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Throwable throwable;
        FileWriter fw;
        File workingDir;
        Set allDeps = this.project.getArtifacts();
        EnterpriseUtil.failOnLegacyFrontLinePlugin(this.project);
        Artifact gatlingApp = EnterprisePackageMojo.findByGroupIdAndArtifactId(allDeps, GATLING_GROUP_ID, "gatling-app");
        Artifact gatlingChartsHighcharts = EnterprisePackageMojo.findByGroupIdAndArtifactId(allDeps, GATLING_HIGHCHARTS_GROUP_ID, "gatling-charts-highcharts");
        Artifact frontlineProbe = EnterprisePackageMojo.findByGroupIdAndArtifactId(allDeps, GATLING_FRONTLINE_GROUP_ID, "frontline-probe");
        if (gatlingApp == null) {
            throw new MojoExecutionException("Couldn't find io.gatling:gatling-app in project dependencies");
        }
        HashSet<Artifact> gatlingDependencies = new HashSet<Artifact>();
        gatlingDependencies.addAll(this.nonGatlingDependencies(gatlingApp));
        gatlingDependencies.addAll(this.nonGatlingDependencies(gatlingChartsHighcharts));
        gatlingDependencies.addAll(this.nonGatlingDependencies(frontlineProbe));
        Set filteredDeps = allDeps.stream().filter(artifact -> !GATLING_GROUP_IDS.contains(artifact.getGroupId()) && (!artifact.getGroupId().equals("io.netty") || !artifact.getArtifactId().equals("netty-all")) && EnterprisePackageMojo.artifactNotIn(artifact, gatlingDependencies)).collect(Collectors.toSet());
        try {
            workingDir = Files.createTempDirectory("frontline", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create temp dir", (Exception)e);
        }
        for (Artifact artifact2 : filteredDeps) {
            ZipUtil.unpack((File)artifact2.getFile(), (File)workingDir, name -> this.exclude(name) ? null : name);
        }
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        Path outputDirectoryPath = outputDirectory.toPath();
        File testOutputDirectory = new File(this.project.getBuild().getTestOutputDirectory());
        Path testOutputDirectoryPath = testOutputDirectory.toPath();
        try {
            if (outputDirectory.exists()) {
                FileUtilsV2_2.copyDirectory((File)outputDirectory, (File)workingDir, pathname -> !this.exclude(outputDirectoryPath.relativize(pathname.toPath()).toString()), (boolean)false);
            }
            if (testOutputDirectory.exists()) {
                FileUtilsV2_2.copyDirectory((File)testOutputDirectory, (File)workingDir, pathname -> !this.exclude(testOutputDirectoryPath.relativize(pathname.toPath()).toString()), (boolean)false);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy compiled classes", (Exception)e);
        }
        File metaInfDir = new File(workingDir, "META-INF");
        metaInfDir.mkdirs();
        File mavenDir = new File(new File(new File(metaInfDir, "maven"), this.project.getGroupId()), this.project.getArtifactId());
        mavenDir.mkdirs();
        try {
            fw = new FileWriter(new File(mavenDir, "pom.properties"));
            throwable = null;
            try {
                fw.write("groupId=" + this.project.getGroupId() + "\n");
                fw.write("artifactId=" + this.project.getArtifactId() + "\n");
                fw.write("version=" + this.project.getVersion() + "\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fw != null) {
                    if (throwable != null) {
                        try {
                            fw.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fw.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate pom.properties", (Exception)e);
        }
        try {
            fw = new FileWriter(new File(mavenDir, "pom.xml"));
            throwable = null;
            try {
                fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                fw.write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
                fw.write("    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n");
                fw.write("    <modelVersion>4.0.0</modelVersion>\n");
                fw.write("    <groupId>" + this.project.getGroupId() + "</groupId>\n");
                fw.write("    <artifactId>" + this.project.getArtifactId() + "</artifactId>\n");
                fw.write("    <version>" + this.project.getVersion() + "</version>\n");
                fw.write("</project>");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (fw != null) {
                    if (throwable != null) {
                        try {
                            fw.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        fw.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate pom.properties", (Exception)e);
        }
        File manifest = new File(metaInfDir, "MANIFEST.MF");
        try (FileWriter fw2 = new FileWriter(manifest);){
            fw2.write("Manifest-Version: 1.0\n");
            fw2.write("Implementation-Title: " + this.project.getArtifactId() + "\n");
            fw2.write("Implementation-Version: " + this.project.getVersion() + "\n");
            fw2.write("Implementation-Vendor: " + this.project.getGroupId() + "\n");
            fw2.write("Specification-Vendor: GatlingCorp\n");
            fw2.write("Gatling-Version: " + gatlingApp.getVersion() + "\n");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate manifest", (Exception)e);
        }
        File shaded = EnterpriseUtil.shadedArtifactFile(this.project, this.targetPath, this.shadedClassifier);
        this.getLog().info((CharSequence)("Generating FrontLine shaded jar " + shaded));
        ZipUtil.pack((File)workingDir, (File)shaded);
        this.projectHelper.attachArtifact(this.project, "jar", this.shadedClassifier, shaded);
        try {
            FileUtilsV2_2.deleteDirectory((File)workingDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to delete working directory " + workingDir, (Exception)e);
        }
    }

    private boolean exclude(String name) {
        for (String pattern : ALWAYS_EXCLUDES) {
            if (!SelectorUtils.match((String)pattern, (String)name, (boolean)false)) continue;
            this.getLog().info((CharSequence)("Excluding file " + name));
            return true;
        }
        if (this.excludes != null) {
            for (String pattern : this.excludes) {
                if (!SelectorUtils.match((String)pattern, (String)name, (boolean)false)) continue;
                this.getLog().info((CharSequence)("Excluding file " + name));
                return true;
            }
        }
        return false;
    }

    private Set<Artifact> resolveTransitively(Artifact artifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setResolveRoot(true).setResolveTransitively(true).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies()).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        return this.repository.resolve(request).getArtifacts();
    }

    private static boolean artifactNotIn(Artifact target, Set<Artifact> artifacts) {
        return EnterprisePackageMojo.findByGroupIdAndArtifactId(artifacts, target.getGroupId(), target.getArtifactId()) == null;
    }

    private static Artifact findByGroupIdAndArtifactId(Set<Artifact> artifacts, String groupId, String artifactId) {
        for (Artifact artifact : artifacts) {
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId)) continue;
            return artifact;
        }
        return null;
    }

    static {
        HashSet<String> groupIds = new HashSet<String>();
        groupIds.add(GATLING_GROUP_ID);
        groupIds.add(GATLING_HIGHCHARTS_GROUP_ID);
        groupIds.add(GATLING_FRONTLINE_GROUP_ID);
        GATLING_GROUP_IDS = Collections.unmodifiableSet(groupIds);
    }
}

