/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.EnterpriseUtil;
import io.gatling.plugin.util.EnterpriseClientException;
import io.gatling.plugin.util.OkHttpEnterpriseClient;
import java.io.File;
import java.net.URL;
import java.util.UUID;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Execute(goal="enterprisePackage")
@Mojo(name="enterpriseUpload")
public class EnterpriseUploadMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetPath;
    @Parameter(defaultValue="shaded")
    private String shadedClassifier;
    @Parameter(defaultValue="https://cloud.gatling.io/api/public", readonly=true)
    private URL enterpriseUrl;
    @Parameter(defaultValue="${env.GATLING_ENTERPRISE_API_TOKEN}", property="gatling.enterprise.apiToken", readonly=true)
    private String apiToken;
    @Parameter(readonly=true)
    private String packageId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.apiToken == null) {
            throw new MojoFailureException("API token is not configure on plugin, neither available in environment variable");
        }
        if (this.packageId == null) {
            throw new MojoFailureException("Artifact ID is not configure on plugin");
        }
        File file = EnterpriseUtil.shadedArtifactFile(this.project, this.targetPath, this.shadedClassifier);
        OkHttpEnterpriseClient enterpriseClient = new OkHttpEnterpriseClient(this.enterpriseUrl, this.apiToken);
        try {
            enterpriseClient.uploadPackage(UUID.fromString(this.packageId), file);
            this.getLog().info((CharSequence)"Successfully upload package");
        }
        catch (EnterpriseClientException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

