/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterpriseMojo;
import io.gatling.mojo.CommonLogMessage;
import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.EnterprisePluginClient;
import io.gatling.plugin.InteractiveEnterprisePlugin;
import io.gatling.plugin.InteractiveEnterprisePluginClient;
import io.gatling.plugin.client.EnterpriseClient;
import io.gatling.plugin.client.http.OkHttpEnterpriseClient;
import io.gatling.plugin.exceptions.UnsupportedClientException;
import io.gatling.plugin.io.JavaPluginScanner;
import io.gatling.plugin.io.PluginIO;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.io.PluginScanner;
import java.net.URL;
import java.util.Scanner;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractEnterprisePluginMojo
extends AbstractEnterpriseMojo {
    @Parameter(defaultValue="https://cloud.gatling.io", readonly=true)
    protected URL enterpriseUrl;
    @Parameter(defaultValue="${env.GATLING_ENTERPRISE_API_TOKEN}", property="gatling.enterprise.apiToken")
    protected String apiToken;
    private final Log logger = this.getLog();
    private final PluginLogger pluginLogger = new PluginLogger(){

        public void info(String message) {
            AbstractEnterprisePluginMojo.this.logger.info((CharSequence)message);
        }

        public void error(String message) {
            AbstractEnterprisePluginMojo.this.logger.error((CharSequence)message);
        }
    };
    private final Scanner scanner = new Scanner(System.in);
    private final PluginScanner pluginScanner = new JavaPluginScanner(this.scanner);
    private final PluginIO pluginIO = new PluginIO(){

        public PluginLogger getLogger() {
            return AbstractEnterprisePluginMojo.this.pluginLogger;
        }

        public PluginScanner getScanner() {
            return AbstractEnterprisePluginMojo.this.pluginScanner;
        }
    };

    protected EnterprisePlugin initEnterprisePlugin() throws MojoFailureException {
        EnterpriseClient enterpriseClient = this.initEnterpriseClient();
        return new EnterprisePluginClient(enterpriseClient, this.pluginLogger);
    }

    protected InteractiveEnterprisePlugin initInteractiveEnterprisePlugin() throws MojoFailureException {
        EnterpriseClient enterpriseClient = this.initEnterpriseClient();
        return new InteractiveEnterprisePluginClient(enterpriseClient, this.pluginIO);
    }

    private EnterpriseClient initEnterpriseClient() throws MojoFailureException {
        if (this.apiToken == null) {
            String msg = "Missing API token\nAn API token is required to call the Gatling Enterprise server; see https://gatling.io/docs/enterprise/cloud/reference/admin/api_tokens/ and create a token with the role 'Configure'.\n" + CommonLogMessage.missingConfiguration("API token", "apiToken", "gatling.enterprise.apiToken", "GATLING_ENTERPRISE_API_TOKEN", "MY_API_TOKEN_VALUE");
            throw new MojoFailureException(msg);
        }
        String pluginTitle = ((Object)((Object)this)).getClass().getPackage().getImplementationTitle();
        String pluginVersion = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        if (pluginTitle == null || pluginVersion == null) {
            throw new IllegalStateException("Gatling plugin title and version not found");
        }
        try {
            URL apiUrl = new URL(this.enterpriseUrl, "api/public");
            return OkHttpEnterpriseClient.getInstance((URL)apiUrl, (String)this.apiToken, (String)pluginTitle, (String)pluginVersion);
        }
        catch (UnsupportedClientException e) {
            throw new MojoFailureException("Please update the Gatling Maven plugin to the latest version for compatibility with Gatling Enterprise. See https://gatling.io/docs/gatling/reference/current/extensions/maven_plugin/ for more information about this plugin.", (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

