/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterprisePluginMojo;
import io.gatling.mojo.CommonLogMessage;
import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import java.io.File;
import java.util.UUID;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Execute(goal="enterprisePackage")
@Mojo(name="enterpriseUpload")
public class EnterpriseUploadMojo
extends AbstractEnterprisePluginMojo {
    @Parameter(property="gatling.enterprise.packageId")
    private String packageId;
    @Parameter(property="gatling.enterprise.simulationId")
    private String simulationId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkPluginPreConditions();
        if (this.packageId == null && this.simulationId == null) {
            String msg = "Missing packageID\nYou must configure the ID of an existing package in Gatling Enterprise; see https://gatling.io/docs/enterprise/cloud/reference/user/package_conf/\n" + CommonLogMessage.missingConfiguration("package ID", "packageId", "gatling.enterprise.packageId", null, "MY_PACKAGE_ID") + "Alternately, if you don't configure a packageId, you can configure the simulationId of an existing simulation on Gatling Enterprise: your code will be uploaded to the package used by that simulation.";
            throw new MojoFailureException(msg);
        }
        File file = this.shadedArtifactFile();
        EnterprisePlugin enterprisePlugin = this.initEnterprisePlugin();
        try {
            if (this.packageId != null) {
                enterprisePlugin.uploadPackage(UUID.fromString(this.packageId), file);
            } else {
                enterprisePlugin.uploadPackageWithSimulationId(UUID.fromString(this.simulationId), file);
            }
            this.getLog().info((CharSequence)"Package successfully uploaded");
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

