/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterprisePluginMojo;
import io.gatling.mojo.CommonLogMessage;
import io.gatling.mojo.SimulationClassUtils;
import io.gatling.plugin.EmptyChoicesException;
import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.InteractiveEnterprisePlugin;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.SeveralTeamsFoundException;
import io.gatling.plugin.exceptions.SimulationStartException;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationStartResult;
import io.gatling.plugin.model.Team;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Execute(goal="enterprisePackage")
@Mojo(name="enterpriseStart", requiresDependencyResolution=ResolutionScope.TEST)
public class EnterpriseStartMojo
extends AbstractEnterprisePluginMojo {
    @Parameter(property="gatling.excludes")
    private String[] excludes;
    @Parameter(property="gatling.simulationClass")
    private String simulationClass;
    @Parameter(property="gatling.enterprise.teamId")
    private String teamId;
    @Parameter(property="gatling.enterprise.simulationId")
    private String simulationId;
    @Parameter(property="gatling.enterprise.packageId")
    private String packageId;
    @Parameter(property="gatling.enterprise.simulationSystemProperties")
    private Map<String, String> simulationSystemProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        UUID packageIdUuid;
        this.checkPluginPreConditions();
        UUID teamIdUuid = this.teamId != null ? UUID.fromString(this.teamId) : null;
        UUID uUID = packageIdUuid = this.packageId != null ? UUID.fromString(this.packageId) : null;
        if (this.simulationSystemProperties == null) {
            this.simulationSystemProperties = Collections.emptyMap();
        }
        File file = this.shadedArtifactFile();
        try {
            RunSummary runSummary = this.simulationId != null ? this.startExistingSimulation(file) : (this.session.getRequest().isInteractiveMode() ? this.interactiveCreateAndStartSimulation(file, teamIdUuid, packageIdUuid) : this.batchCreateAndStartSimulation(file, teamIdUuid, packageIdUuid));
            this.getLog().info((CharSequence)CommonLogMessage.simulationStartSuccess(this.enterpriseUrl, runSummary.reportsPath));
        }
        catch (SimulationStartException e) {
            Simulation simulation = e.getSimulation();
            String msg = "Failed to start simulation.\n" + String.format("Simulation %s with ID %s exists but could not be started: ", simulation.name, simulation.id) + e.getCause().getMessage() + "\n" + CommonLogMessage.simulationStartSample(simulation);
            throw new MojoFailureException(msg, (Throwable)e);
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private RunSummary startExistingSimulation(File file) throws MojoFailureException {
        this.getLog().info((CharSequence)"Uploading and starting simulation...");
        EnterprisePlugin enterprisePlugin = this.initEnterprisePlugin();
        try {
            RunSummary runSummary = enterprisePlugin.uploadPackageAndStartSimulation((UUID)UUID.fromString((String)this.simulationId), this.simulationSystemProperties, (File)file).runSummary;
            return runSummary;
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        finally {
            EnterpriseStartMojo.closeSilently((AutoCloseable)enterprisePlugin);
        }
    }

    private RunSummary batchCreateAndStartSimulation(File file, UUID teamIdUuid, UUID packageIdUuid) throws EnterprisePluginException, MojoFailureException {
        SimulationStartResult result;
        this.getLog().info((CharSequence)"Creating and starting simulation (batch mode)...");
        EnterprisePlugin enterprisePlugin = this.initEnterprisePlugin();
        try {
            result = enterprisePlugin.createAndStartSimulation(teamIdUuid, this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.simulationClass(), packageIdUuid, this.simulationSystemProperties, file);
        }
        catch (SeveralTeamsFoundException e) {
            String availableTeams = e.getAvailableTeams().stream().map(t -> String.format("- %s (%s)\n", t.id, t.name)).collect(Collectors.joining());
            String teamExample = ((Team)e.getAvailableTeams().get((int)0)).id.toString();
            String msg = "Several teams were found to create a simulation.\nAvailable teams:\n" + availableTeams + CommonLogMessage.missingConfiguration("team", "teamId", "gatling.enterprise.teamId", null, teamExample);
            throw new MojoFailureException(msg);
        }
        finally {
            EnterpriseStartMojo.closeSilently((AutoCloseable)enterprisePlugin);
        }
        this.logSimulationCreatedOrChosen(result);
        return result.runSummary;
    }

    private RunSummary interactiveCreateAndStartSimulation(File file, UUID teamIdUuid, UUID packageIdUuid) throws EnterprisePluginException, MojoFailureException {
        SimulationStartResult result;
        InteractiveEnterprisePlugin interactiveEnterprisePlugin = this.initInteractiveEnterprisePlugin();
        try {
            result = interactiveEnterprisePlugin.createOrStartSimulation(teamIdUuid, this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.simulationClass, this.allSimulationClasses(), packageIdUuid, this.simulationSystemProperties, file);
        }
        catch (EmptyChoicesException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        finally {
            EnterpriseStartMojo.closeSilently((AutoCloseable)interactiveEnterprisePlugin);
        }
        this.logSimulationCreatedOrChosen(result);
        return result.runSummary;
    }

    private void logSimulationCreatedOrChosen(SimulationStartResult result) {
        if (result.createdSimulation) {
            this.getLog().info((CharSequence)CommonLogMessage.simulationCreated(result.simulation));
        } else {
            this.getLog().info((CharSequence)CommonLogMessage.simulationChosen(result.simulation));
        }
        this.getLog().info((CharSequence)CommonLogMessage.simulationStartSample(result.simulation));
    }

    private String simulationClass() throws MojoFailureException {
        if (this.simulationClass != null) {
            return this.simulationClass;
        }
        List<String> simulations = this.allSimulationClasses();
        if (simulations.size() == 1) {
            return simulations.get(0);
        }
        if (simulations.isEmpty()) {
            throw new MojoFailureException("No simulation class discovered. Your project should contain at least one simulation (https://gatling.io/docs/gatling/reference/current/core/simulation/).");
        }
        String availableSimulations = simulations.stream().map(s -> "- " + s + "\n").collect(Collectors.joining());
        String simulationExample = simulations.get(0);
        String msg = "Several simulation classes were found.\nAvailable simulations:\n" + availableSimulations + CommonLogMessage.missingConfiguration("simulation", "simulationClass", "gatling.simulationClass", null, simulationExample);
        throw new MojoFailureException(msg);
    }

    private List<String> allSimulationClasses() {
        return SimulationClassUtils.resolveSimulations(this.mavenProject, this.compiledClassesFolder, null, this.excludes);
    }
}

