/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractGatlingMojo;
import io.gatling.mojo.MojoConstants;
import io.gatling.plugin.util.Fork;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.toolchain.Toolchain;

@Mojo(name="recorder", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class RecorderMojo
extends AbstractGatlingMojo {
    @Parameter(property="gatling.recorder.localPort", alias="lp")
    private Integer localPort;
    @Parameter(property="gatling.recorder.proxyHost", alias="ph")
    private String proxyHost;
    @Parameter(property="gatling.recorder.proxyPort", alias="pp")
    private Integer proxyPort;
    @Parameter(property="gatling.recorder.proxySslPort", alias="pps")
    private Integer proxySSLPort;
    @Parameter(property="gatling.recorder.simulationsFolder", alias="sf", defaultValue="${project.basedir}/src/test/scala")
    private File simulationsFolder;
    @Parameter(property="gatling.recorder.resourcesFolder", alias="rsf", defaultValue="${project.basedir}/src/test/resources")
    private File resourcesFolder;
    @Parameter(property="gatling.recorder.className", alias="cn")
    private String className;
    @Parameter(property="gatling.recorder.package", alias="pkg", defaultValue="${project.groupId}")
    private String packageName;
    @Parameter(property="gatling.recorder.encoding", alias="enc")
    private String encoding;
    @Parameter(property="gatling.recorder.followRedirect", alias="fr")
    private Boolean followRedirect;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            List<String> testClasspath = this.buildTestClasspath();
            List<String> recorderArgs = this.recorderArgs();
            Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            Fork forkedRecorder = this.newFork("io.gatling.recorder.GatlingRecorder", testClasspath, MojoConstants.GATLING_JVM_ARGS, recorderArgs, toolchain, true, null);
            forkedRecorder.run();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Recorder execution failed", e);
        }
    }

    private List<String> recorderArgs() throws Exception {
        ArrayList<String> arguments = new ArrayList<String>();
        this.addArg(arguments, "lp", this.localPort);
        this.addArg(arguments, "ph", this.proxyHost);
        this.addArg(arguments, "pp", this.proxyPort);
        this.addArg(arguments, "pps", this.proxySSLPort);
        this.addArg(arguments, "sf", this.simulationsFolder.getCanonicalPath());
        this.addArg(arguments, "rf", this.resourcesFolder.getCanonicalPath());
        this.addArg(arguments, "cn", this.className);
        this.addArg(arguments, "pkg", this.packageName);
        this.addArg(arguments, "enc", this.encoding);
        this.addArg(arguments, "fr", this.followRedirect);
        return arguments;
    }
}

