/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterprisePluginMojo;
import io.gatling.mojo.CommonLogMessage;
import io.gatling.plugin.EmptyChoicesException;
import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.exceptions.SeveralSimulationClassNamesFoundException;
import io.gatling.plugin.exceptions.SeveralTeamsFoundException;
import io.gatling.plugin.exceptions.SimulationStartException;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.Simulation;
import io.gatling.plugin.model.SimulationStartResult;
import io.gatling.plugin.model.Team;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Execute(goal="enterprisePackage")
@Mojo(name="enterpriseStart", requiresDependencyResolution=ResolutionScope.TEST)
public class EnterpriseStartMojo
extends AbstractEnterprisePluginMojo {
    @Parameter(property="gatling.excludes")
    private String[] excludes;
    @Parameter(property="gatling.simulationClass")
    private String simulationClass;
    @Parameter(property="gatling.enterprise.teamId")
    private String teamId;
    @Parameter(property="gatling.enterprise.simulationId")
    private String simulationId;
    @Parameter(property="gatling.enterprise.packageId")
    private String packageId;
    @Parameter(property="gatling.enterprise.simulationSystemProperties")
    private Map<String, String> simulationSystemProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        UUID packageIdUuid;
        this.checkPluginPreConditions();
        UUID teamIdUuid = this.teamId != null ? UUID.fromString(this.teamId) : null;
        UUID uUID = packageIdUuid = this.packageId != null ? UUID.fromString(this.packageId) : null;
        if (this.simulationSystemProperties == null) {
            this.simulationSystemProperties = Collections.emptyMap();
        }
        File file = this.shadedArtifactFile();
        try {
            EnterprisePlugin plugin = this.initEnterprisePlugin(this.session.getRequest().isInteractiveMode());
            RunSummary runSummary = this.simulationId != null ? this.startExistingSimulation(plugin, file) : this.createAndStartSimulation(plugin, file, teamIdUuid, packageIdUuid);
            this.getLog().info((CharSequence)CommonLogMessage.simulationStartSuccess(this.enterpriseUrl, runSummary.reportsPath));
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private EnterprisePlugin initEnterprisePlugin(Boolean isInteractive) throws MojoFailureException {
        return isInteractive != false ? this.initInteractiveEnterprisePlugin() : this.initBatchEnterprisePlugin();
    }

    private RunSummary startExistingSimulation(EnterprisePlugin enterprisePlugin, File file) throws MojoFailureException {
        this.getLog().info((CharSequence)"Uploading and starting simulation...");
        try {
            RunSummary runSummary = enterprisePlugin.uploadPackageAndStartSimulation((UUID)UUID.fromString((String)this.simulationId), this.simulationSystemProperties, (String)this.simulationClass, (File)file).runSummary;
            return runSummary;
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        finally {
            EnterpriseStartMojo.closeSilently((AutoCloseable)enterprisePlugin);
        }
    }

    private RunSummary createAndStartSimulation(EnterprisePlugin enterprisePlugin, File file, UUID teamIdUuid, UUID packageIdUuid) throws EnterprisePluginException, MojoFailureException {
        SimulationStartResult result;
        try {
            result = enterprisePlugin.createAndStartSimulation(teamIdUuid, this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.simulationClass, packageIdUuid, this.simulationSystemProperties, file);
        }
        catch (SeveralTeamsFoundException e) {
            String availableTeams = e.getAvailableTeams().stream().map(t -> String.format("- %s (%s)\n", t.id, t.name)).collect(Collectors.joining());
            String teamExample = ((Team)e.getAvailableTeams().get((int)0)).id.toString();
            String msg = "Several teams were found to create a simulation.\nAvailable teams:\n" + availableTeams + CommonLogMessage.missingConfiguration("team", "teamId", "gatling.enterprise.teamId", null, teamExample);
            throw new MojoFailureException(msg);
        }
        catch (SeveralSimulationClassNamesFoundException e) {
            String availableClasses = e.getAvailableSimulationClassNames().stream().map(s -> String.format("- %s\n", s)).collect(Collectors.joining());
            String classExample = (String)e.getAvailableSimulationClassNames().stream().findFirst().get();
            String msg = "Several simulation classes were found.\nAvailable classes:\n" + availableClasses + "\n" + CommonLogMessage.missingConfiguration("class", "simulationClass", "gatling.simulationClass", null, classExample);
            throw new MojoFailureException(msg);
        }
        catch (SimulationStartException e) {
            Simulation simulation = e.getSimulation();
            String msg = "Failed to start simulation.\n" + String.format("Simulation %s with ID %s exists but could not be started: ", simulation.name, simulation.id) + e.getCause().getMessage() + "\n" + CommonLogMessage.simulationStartSample(simulation);
            throw new MojoFailureException(msg, (Throwable)e);
        }
        catch (EmptyChoicesException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        finally {
            EnterpriseStartMojo.closeSilently((AutoCloseable)enterprisePlugin);
        }
        this.logSimulationCreatedOrChosen(result);
        return result.runSummary;
    }

    private void logSimulationCreatedOrChosen(SimulationStartResult result) {
        if (result.createdSimulation) {
            this.getLog().info((CharSequence)CommonLogMessage.simulationCreated(result.simulation));
        } else {
            this.getLog().info((CharSequence)CommonLogMessage.simulationChosen(result.simulation));
        }
        this.getLog().info((CharSequence)CommonLogMessage.simulationStartSample(result.simulation));
    }
}

