/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterpriseMojo;
import io.gatling.mojo.MojoConstants;
import io.gatling.mojo.MojoUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.SelectorUtils;
import org.zeroturnaround.zip.ZipUtil;
import org.zeroturnaround.zip.commons.FileUtilsV2_2;

@Execute(phase=LifecyclePhase.TEST_COMPILE)
@Mojo(name="enterprisePackage", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class EnterprisePackageMojo
extends AbstractEnterpriseMojo {
    private static final String[] ALWAYS_EXCLUDES = new String[]{"module-info.class", "META-INF/LICENSE", "META-INF/MANIFEST.MF", "META-INF/versions/**", "META-INF/maven/**", "*.SF", "*.DSA", "*.RSA"};
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="gatling.excludes")
    private String[] excludes;

    private Set<Artifact> nonGatlingDependencies(Artifact artifact) {
        if (artifact == null) {
            return Collections.emptySet();
        }
        return this.resolveTransitively(artifact).stream().filter(art -> !MojoConstants.GATLING_GROUP_IDS.contains(art.getGroupId())).collect(Collectors.toSet());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Throwable throwable;
        FileWriter fw;
        File workingDir;
        this.checkPluginPreConditions();
        Set allDeps = this.mavenProject.getArtifacts();
        Artifact gatlingApp = MojoUtils.findByGroupIdAndArtifactId(allDeps, "io.gatling", "gatling-app");
        Artifact gatlingChartsHighcharts = MojoUtils.findByGroupIdAndArtifactId(allDeps, "io.gatling.highcharts", "gatling-charts-highcharts");
        Artifact frontlineProbe = MojoUtils.findByGroupIdAndArtifactId(allDeps, "io.gatling.frontline", "frontline-probe");
        if (gatlingApp == null) {
            throw new MojoExecutionException("Couldn't find io.gatling:gatling-app in project dependencies");
        }
        HashSet<Artifact> gatlingDependencies = new HashSet<Artifact>();
        gatlingDependencies.addAll(this.nonGatlingDependencies(gatlingApp));
        gatlingDependencies.addAll(this.nonGatlingDependencies(gatlingChartsHighcharts));
        gatlingDependencies.addAll(this.nonGatlingDependencies(frontlineProbe));
        Set filteredDeps = allDeps.stream().filter(artifact -> !MojoConstants.GATLING_GROUP_IDS.contains(artifact.getGroupId()) && (!artifact.getGroupId().equals("io.netty") || !artifact.getArtifactId().equals("netty-all")) && MojoUtils.artifactNotIn(artifact, gatlingDependencies)).collect(Collectors.toSet());
        try {
            workingDir = Files.createTempDirectory("gatling-maven", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create temp dir", (Exception)e);
        }
        for (Artifact artifact2 : filteredDeps) {
            ZipUtil.unpack((File)artifact2.getFile(), (File)workingDir, name -> this.exclude(name) ? null : name);
        }
        File outputDirectory = new File(this.mavenProject.getBuild().getOutputDirectory());
        Path outputDirectoryPath = outputDirectory.toPath();
        File testOutputDirectory = new File(this.mavenProject.getBuild().getTestOutputDirectory());
        Path testOutputDirectoryPath = testOutputDirectory.toPath();
        try {
            if (outputDirectory.exists()) {
                FileUtilsV2_2.copyDirectory((File)outputDirectory, (File)workingDir, pathname -> !this.exclude(outputDirectoryPath.relativize(pathname.toPath()).toString()), (boolean)false);
            }
            if (testOutputDirectory.exists()) {
                FileUtilsV2_2.copyDirectory((File)testOutputDirectory, (File)workingDir, pathname -> !this.exclude(testOutputDirectoryPath.relativize(pathname.toPath()).toString()), (boolean)false);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy compiled classes", (Exception)e);
        }
        File metaInfDir = new File(workingDir, "META-INF");
        metaInfDir.mkdirs();
        File mavenDir = new File(new File(new File(metaInfDir, "maven"), this.mavenProject.getGroupId()), this.mavenProject.getArtifactId());
        mavenDir.mkdirs();
        try {
            fw = new FileWriter(new File(mavenDir, "pom.properties"));
            throwable = null;
            try {
                fw.write("groupId=" + this.mavenProject.getGroupId() + "\n");
                fw.write("artifactId=" + this.mavenProject.getArtifactId() + "\n");
                fw.write("version=" + this.mavenProject.getVersion() + "\n");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fw != null) {
                    if (throwable != null) {
                        try {
                            fw.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fw.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate pom.properties", (Exception)e);
        }
        try {
            fw = new FileWriter(new File(mavenDir, "pom.xml"));
            throwable = null;
            try {
                fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                fw.write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
                fw.write("    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n");
                fw.write("    <modelVersion>4.0.0</modelVersion>\n");
                fw.write("    <groupId>" + this.mavenProject.getGroupId() + "</groupId>\n");
                fw.write("    <artifactId>" + this.mavenProject.getArtifactId() + "</artifactId>\n");
                fw.write("    <version>" + this.mavenProject.getVersion() + "</version>\n");
                fw.write("</project>");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (fw != null) {
                    if (throwable != null) {
                        try {
                            fw.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        fw.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate pom.properties", (Exception)e);
        }
        File manifest = new File(metaInfDir, "MANIFEST.MF");
        try (FileWriter fw2 = new FileWriter(manifest);){
            fw2.write("Manifest-Version: 1.0\n");
            fw2.write("Implementation-Title: " + this.mavenProject.getArtifactId() + "\n");
            fw2.write("Implementation-Version: " + this.mavenProject.getVersion() + "\n");
            fw2.write("Implementation-Vendor: " + this.mavenProject.getGroupId() + "\n");
            fw2.write("Specification-Vendor: GatlingCorp\n");
            fw2.write("Gatling-Version: " + gatlingApp.getVersion() + "\n");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate manifest", (Exception)e);
        }
        File shaded = this.shadedArtifactFile();
        this.getLog().info((CharSequence)("Generating Gatling Enterprise package " + shaded));
        ZipUtil.pack((File)workingDir, (File)shaded);
        this.projectHelper.attachArtifact(this.mavenProject, "jar", this.shadedClassifier, shaded);
        try {
            FileUtilsV2_2.deleteDirectory((File)workingDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to delete working directory " + workingDir, (Exception)e);
        }
    }

    private boolean exclude(String name) {
        for (String pattern : ALWAYS_EXCLUDES) {
            if (!SelectorUtils.match((String)pattern, (String)name, (boolean)false)) continue;
            this.getLog().info((CharSequence)("Excluding file " + name));
            return true;
        }
        if (this.excludes != null) {
            for (String pattern : this.excludes) {
                if (!SelectorUtils.match((String)pattern, (String)name, (boolean)false)) continue;
                this.getLog().info((CharSequence)("Excluding file " + name));
                return true;
            }
        }
        return false;
    }

    private Set<Artifact> resolveTransitively(Artifact artifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setResolveRoot(true).setResolveTransitively(true).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies()).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        return this.repository.resolve(request).getArtifacts();
    }
}

