/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.GatlingMojo;
import io.gatling.mojo.MojoUtils;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.util.Fork;
import io.gatling.plugin.util.JavaLocator;
import io.gatling.plugin.util.MainWithArgsInFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

public abstract class AbstractGatlingMojo
extends AbstractMojo {
    private static final String FRONTLINE_MAVEN_PLUGIN_GROUP_ID = "io.gatling.frontline";
    private static final String FRONTLINE_MAVEN_PLUGIN_ARTIFACT_ID = "frontline-maven-plugin";
    @Parameter(property="gatling.configFolder", alias="cd", defaultValue="${project.basedir}/src/test/resources")
    protected File configFolder;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", readonly=true)
    protected File compiledClassesFolder;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    protected ToolchainManager toolchainManager;
    @Component
    protected RepositorySystem repository;

    protected void checkPluginPreConditions() throws MojoFailureException {
        boolean obsoletePluginFound = this.mavenProject.getPluginArtifacts().stream().anyMatch(AbstractGatlingMojo::isFrontLinePlugin);
        if (obsoletePluginFound) {
            throw new MojoFailureException("Plugin `frontline-maven-plugin` is no longer needed, its functionality is now included in `gatling-maven-plugin`.\nPlease remove `frontline-maven-plugin` from your pom.xml plugins configuration.\nPlease use gatling:enterprisePackage instead of configuring it on package phase.\nSee https://gatling.io/docs/gatling/reference/current/extensions/maven_plugin/ for more information ");
        }
    }

    private static boolean isFrontLinePlugin(Artifact artifact) {
        return artifact.getGroupId().equals(FRONTLINE_MAVEN_PLUGIN_GROUP_ID) && artifact.getArtifactId().equals(FRONTLINE_MAVEN_PLUGIN_ARTIFACT_ID);
    }

    protected List<String> buildTestClasspath() throws Exception {
        ArrayList<String> testClasspathElements = new ArrayList<String>();
        if (!new File(this.compiledClassesFolder, "gatling.conf").exists()) {
            testClasspathElements.add(this.configFolder.getCanonicalPath());
        }
        testClasspathElements.addAll(this.mavenProject.getTestClasspathElements());
        testClasspathElements.add(MojoUtils.locateJar(GatlingMojo.class));
        testClasspathElements.add(MojoUtils.locateJar(MainWithArgsInFile.class));
        return testClasspathElements;
    }

    protected void addArg(List<String> args, String flag, Object value) {
        if (value != null) {
            args.addAll(Arrays.asList("-" + flag, value.toString()));
        }
    }

    private PluginLogger newPluginLogger() {
        return new PluginLogger(){

            public void info(String message) {
                AbstractGatlingMojo.this.getLog().info((CharSequence)message);
            }

            public void error(String message) {
                AbstractGatlingMojo.this.getLog().error((CharSequence)message);
            }
        };
    }

    protected Fork newFork(String mainClassName, List<String> classpath, List<String> jvmArgs, List<String> args, Toolchain toolchain, boolean propagateSystemProperties, File workingDirectory) {
        String fromToolchain = toolchain != null ? toolchain.findTool("java") : null;
        File javaExec = fromToolchain != null ? new File(fromToolchain) : JavaLocator.getJavaExecutable();
        return new Fork(mainClassName, classpath, jvmArgs, args, javaExec, propagateSystemProperties, this.newPluginLogger(), workingDirectory);
    }
}

