/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.GatlingMojo;
import io.gatling.mojo.MojoUtils;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.util.Fork;
import io.gatling.plugin.util.ForkMain;
import io.gatling.plugin.util.JavaLocator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;

public abstract class AbstractGatlingMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    protected ToolchainManager toolchainManager;
    @Component
    protected RepositorySystem repository;

    protected boolean interactive() {
        return this.session.getRequest().isInteractiveMode() && !Boolean.parseBoolean(System.getenv("CI"));
    }

    protected List<String> buildTestClasspath() throws Exception {
        ArrayList<String> testClasspathElements = new ArrayList<String>();
        testClasspathElements.addAll(this.mavenProject.getTestClasspathElements());
        testClasspathElements.add(MojoUtils.locateJar(GatlingMojo.class));
        testClasspathElements.add(MojoUtils.locateJar(ForkMain.class));
        return testClasspathElements;
    }

    protected void addArg(List<String> args, String flag, Object value) {
        if (value != null) {
            args.add("-" + flag);
            args.add(value.toString());
        }
    }

    protected PluginLogger newPluginLogger() {
        return new PluginLogger(){

            public void info(String message) {
                AbstractGatlingMojo.this.getLog().info((CharSequence)message);
            }

            public void error(String message) {
                AbstractGatlingMojo.this.getLog().error((CharSequence)message);
            }
        };
    }

    protected Fork newFork(String mainClassName, List<String> classpath, List<String> jvmArgs, List<String> args, Toolchain toolchain, boolean propagateSystemProperties, File workingDirectory) {
        String fromToolchain = toolchain != null ? toolchain.findTool("java") : null;
        File javaExec = fromToolchain != null ? new File(fromToolchain) : JavaLocator.getJavaExecutable();
        return new Fork(mainClassName, classpath, jvmArgs, args, javaExec, propagateSystemProperties, this.newPluginLogger(), workingDirectory);
    }
}

