/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterprisePluginMojo;
import io.gatling.mojo.CommonLogMessage;
import io.gatling.mojo.RecoverEnterprisePluginException;
import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.SimulationEndResult;
import io.gatling.plugin.model.SimulationStartResult;
import io.gatling.plugin.util.PropertiesParserUtil;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Execute(goal="enterprisePackage")
@Mojo(name="enterpriseStart", requiresDependencyResolution=ResolutionScope.TEST)
public final class EnterpriseStartMojo
extends AbstractEnterprisePluginMojo {
    @Parameter(property="gatling.excludes")
    private String[] excludes;
    @Parameter(property="gatling.simulationClass")
    private String simulationClass;
    @Parameter(property="gatling.enterprise.teamId")
    private String teamId;
    @Parameter(property="gatling.enterprise.simulationId")
    private String simulationId;
    @Parameter(property="gatling.enterprise.packageId")
    private String packageId;
    @Parameter
    private Map<String, String> simulationSystemProperties;
    @Parameter(property="gatling.enterprise.simulationSystemProperties")
    private String simulationSystemPropertiesString;
    @Parameter
    private Map<String, String> simulationEnvironmentVariables;
    @Parameter(property="gatling.enterprise.simulationEnvironmentVariables")
    private String simulationEnvironmentVariablesString;
    @Parameter(property="gatling.enterprise.waitForRunEnd", defaultValue="false")
    private boolean waitForRunEnd;

    public void execute() throws MojoFailureException {
        UUID packageIdUuid;
        UUID teamIdUuid = this.teamId != null ? UUID.fromString(this.teamId) : null;
        UUID uUID = packageIdUuid = this.packageId != null ? UUID.fromString(this.packageId) : null;
        if (this.simulationSystemProperties == null) {
            this.simulationSystemProperties = Map.of();
        }
        File file = this.enterprisePackage();
        EnterprisePlugin plugin = this.initEnterprisePlugin(this.interactive());
        SimulationStartResult startResult = RecoverEnterprisePluginException.handle(() -> this.simulationId == null ? this.createAndStartSimulation(plugin, file, teamIdUuid, packageIdUuid) : this.startExistingSimulation(plugin, file), this.getLog());
        this.getLog().info((CharSequence)CommonLogMessage.simulationStartSuccess(this.enterpriseUrl, startResult.runSummary.reportsPath));
        if (this.simulationId == null || !this.waitForRunEnd) {
            this.getLog().info((CharSequence)CommonLogMessage.simulationConfiguration(startResult.simulation, this.simulationId, this.waitForRunEnd));
        }
        this.waitForRunEnd(plugin, startResult.runSummary);
    }

    private EnterprisePlugin initEnterprisePlugin(boolean isInteractive) throws MojoFailureException {
        return isInteractive ? this.initInteractiveEnterprisePlugin() : this.initBatchEnterprisePlugin();
    }

    private SimulationStartResult startExistingSimulation(EnterprisePlugin enterprisePlugin, File file) throws EnterprisePluginException {
        this.getLog().info((CharSequence)"Uploading and starting simulation...");
        return enterprisePlugin.uploadPackageAndStartSimulation(UUID.fromString(this.simulationId), this.selectProperties(this.simulationSystemProperties, this.simulationSystemPropertiesString), this.selectProperties(this.simulationEnvironmentVariables, this.simulationEnvironmentVariablesString), this.simulationClass, file);
    }

    private SimulationStartResult createAndStartSimulation(EnterprisePlugin enterprisePlugin, File file, UUID teamIdUuid, UUID packageIdUuid) throws EnterprisePluginException {
        SimulationStartResult result = enterprisePlugin.createAndStartSimulation(teamIdUuid, this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.simulationClass, packageIdUuid, this.selectProperties(this.simulationSystemProperties, this.simulationSystemPropertiesString), this.selectProperties(this.simulationEnvironmentVariables, this.simulationEnvironmentVariablesString), file);
        this.logSimulationCreatedOrChosen(result);
        return result;
    }

    private void logSimulationCreatedOrChosen(SimulationStartResult result) {
        if (result.createdSimulation) {
            this.getLog().info((CharSequence)CommonLogMessage.simulationCreated(result.simulation));
        } else {
            this.getLog().info((CharSequence)CommonLogMessage.simulationChosen(result.simulation));
        }
    }

    private Map<String, String> selectProperties(Map<String, String> propertiesMap, String propertiesString) {
        return propertiesMap == null || propertiesMap.isEmpty() ? PropertiesParserUtil.parseProperties((String)propertiesString) : propertiesMap;
    }

    private void waitForRunEnd(EnterprisePlugin plugin, RunSummary startedRun) throws MojoFailureException {
        if (this.waitForRunEnd) {
            SimulationEndResult finishedRun = RecoverEnterprisePluginException.handle(() -> plugin.waitForRunEnd(startedRun), this.getLog());
            if (!finishedRun.status.successful) {
                throw new MojoFailureException("Simulation failed.");
            }
        }
    }
}

