/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterprisePluginMojo;
import io.gatling.mojo.CommonLogMessage;
import io.gatling.mojo.RecoverEnterprisePluginException;
import io.gatling.plugin.EnterprisePlugin;
import io.gatling.plugin.exceptions.EnterprisePluginException;
import io.gatling.plugin.model.DeploymentInfo;
import io.gatling.plugin.model.RunSummary;
import io.gatling.plugin.model.SimulationEndResult;
import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Execute(goal="enterpriseDeploy")
@Mojo(name="enterpriseStart", requiresDependencyResolution=ResolutionScope.TEST)
public final class EnterpriseStartMojo
extends AbstractEnterprisePluginMojo {
    @Parameter(property="gatling.enterprise.simulationName")
    private String simulationName;
    @Parameter(property="gatling.enterprise.waitForRunEnd", defaultValue="false")
    private boolean waitForRunEnd;

    public void execute() throws MojoFailureException {
        Map context = this.getPluginContext();
        DeploymentInfo deploymentInfo = (DeploymentInfo)context.get("enterprise_deploy_info");
        EnterprisePlugin plugin = this.initEnterprisePlugin(this.requireBatchMode());
        try {
            RunSummary runSummary = plugin.startSimulation(this.simulationName, deploymentInfo);
            this.getLog().info((CharSequence)CommonLogMessage.simulationStartSuccess(this.enterpriseUrl, runSummary.reportsPath));
            this.waitForRunEnd(plugin, runSummary);
        }
        catch (EnterprisePluginException e) {
            throw new MojoFailureException("Unhandled Gatling Enterprise plugin exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private void waitForRunEnd(EnterprisePlugin plugin, RunSummary startedRun) throws MojoFailureException {
        if (this.waitForRunEnd) {
            SimulationEndResult finishedRun = RecoverEnterprisePluginException.handle(() -> plugin.waitForRunEnd(startedRun), this.getLog());
            if (!finishedRun.status.successful) {
                throw new MojoFailureException("Simulation failed.");
            }
        }
    }
}

