/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.mqtt;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.core.protocol.Protocol;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.mqtt.LastWillBuilder;
import io.gatling.javaapi.mqtt.internal.MessageCorrelators;
import java.time.Duration;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;

public final class MqttProtocolBuilder
implements ProtocolBuilder {
    private final io.gatling.mqtt.protocol.MqttProtocolBuilder wrapped;

    MqttProtocolBuilder(io.gatling.mqtt.protocol.MqttProtocolBuilder mqttProtocolBuilder) {
        this.wrapped = mqttProtocolBuilder;
    }

    @NonNull
    public MqttProtocolBuilder mqttVersion_3_1() {
        return new MqttProtocolBuilder(this.wrapped.mqttVersion_3_1());
    }

    @NonNull
    public MqttProtocolBuilder mqttVersion_3_1_1() {
        return new MqttProtocolBuilder(this.wrapped.mqttVersion_3_1_1());
    }

    @NonNull
    public MqttProtocolBuilder broker(@NonNull String string, int n) {
        return new MqttProtocolBuilder(this.wrapped.broker(string, n));
    }

    @NonNull
    public MqttProtocolBuilder useTls(boolean bl) {
        return new MqttProtocolBuilder(this.wrapped.useTls(bl));
    }

    @NonNull
    public MqttProtocolBuilder perUserKeyManagerFactory(@NonNull Function<Long, KeyManagerFactory> function) {
        return new MqttProtocolBuilder(this.wrapped.perUserKeyManagerFactory(object -> (KeyManagerFactory)function.apply((Long)object)));
    }

    @NonNull
    public MqttProtocolBuilder clientId(@NonNull String string) {
        return new MqttProtocolBuilder(this.wrapped.clientId(Expressions.toStringExpression((String)string)));
    }

    @NonNull
    public MqttProtocolBuilder clientId(@NonNull Function<Session, String> function) {
        return new MqttProtocolBuilder(this.wrapped.clientId(Expressions.javaFunctionToExpression(function)));
    }

    @NonNull
    public MqttProtocolBuilder cleanSession(boolean bl) {
        return new MqttProtocolBuilder(this.wrapped.cleanSession(bl));
    }

    @NonNull
    public MqttProtocolBuilder connectTimeout(long l) {
        return this.connectTimeout(Duration.ofSeconds(l));
    }

    @NonNull
    public MqttProtocolBuilder connectTimeout(@NonNull Duration duration) {
        return new MqttProtocolBuilder(this.wrapped.connectTimeout(Converters.toScalaDuration((Duration)duration)));
    }

    @NonNull
    public MqttProtocolBuilder keepAlive(long l) {
        return this.keepAlive(Duration.ofSeconds(l));
    }

    @NonNull
    public MqttProtocolBuilder keepAlive(@NonNull Duration duration) {
        return new MqttProtocolBuilder(this.wrapped.keepAlive(Converters.toScalaDuration((Duration)duration)));
    }

    @NonNull
    public MqttProtocolBuilder qosAtMostOnce() {
        return new MqttProtocolBuilder(this.wrapped.qosAtMostOnce());
    }

    @NonNull
    public MqttProtocolBuilder qosAtLeastOnce() {
        return new MqttProtocolBuilder(this.wrapped.qosAtLeastOnce());
    }

    @NonNull
    public MqttProtocolBuilder qosExactlyOnce() {
        return new MqttProtocolBuilder(this.wrapped.qosExactlyOnce());
    }

    @NonNull
    public MqttProtocolBuilder retain(boolean bl) {
        return new MqttProtocolBuilder(this.wrapped.retain(bl));
    }

    @NonNull
    public MqttProtocolBuilder credentials(@NonNull String string, @NonNull String string2) {
        return new MqttProtocolBuilder(this.wrapped.credentials(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2)));
    }

    @NonNull
    public MqttProtocolBuilder credentials(@NonNull Function<Session, String> function, @NonNull String string) {
        return new MqttProtocolBuilder(this.wrapped.credentials(Expressions.javaFunctionToExpression(function), Expressions.toStringExpression((String)string)));
    }

    @NonNull
    public MqttProtocolBuilder credentials(@NonNull String string, @NonNull Function<Session, String> function) {
        return new MqttProtocolBuilder(this.wrapped.credentials(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression(function)));
    }

    @NonNull
    public MqttProtocolBuilder credentials(@NonNull Function<Session, String> function, @NonNull Function<Session, String> function2) {
        return new MqttProtocolBuilder(this.wrapped.credentials(Expressions.javaFunctionToExpression(function), Expressions.javaFunctionToExpression(function2)));
    }

    @NonNull
    public MqttProtocolBuilder lastWill(@NonNull LastWillBuilder lastWillBuilder) {
        return new MqttProtocolBuilder(this.wrapped.lastWill(lastWillBuilder.asScala()));
    }

    @NonNull
    public MqttProtocolBuilder reconnectAttemptsMax(int n) {
        return new MqttProtocolBuilder(this.wrapped.reconnectAttemptsMax(n));
    }

    @NonNull
    public MqttProtocolBuilder reconnectDelay(long l) {
        return this.reconnectDelay(Duration.ofSeconds(l));
    }

    @NonNull
    public MqttProtocolBuilder reconnectDelay(@NonNull Duration duration) {
        return new MqttProtocolBuilder(this.wrapped.reconnectDelay(Converters.toScalaDuration((Duration)duration)));
    }

    @NonNull
    public MqttProtocolBuilder reconnectBackoffMultiplier(float f) {
        return new MqttProtocolBuilder(this.wrapped.reconnectBackoffMultiplier(f));
    }

    @NonNull
    public MqttProtocolBuilder resendDelay(long l) {
        return this.resendDelay(Duration.ofSeconds(l));
    }

    @NonNull
    public MqttProtocolBuilder resendDelay(@NonNull Duration duration) {
        return new MqttProtocolBuilder(this.wrapped.resendDelay(Converters.toScalaDuration((Duration)duration)));
    }

    @NonNull
    public MqttProtocolBuilder resendBackoffMultiplier(float f) {
        return new MqttProtocolBuilder(this.wrapped.resendBackoffMultiplier(f));
    }

    @NonNull
    public MqttProtocolBuilder correlateBy(@NonNull CheckBuilder checkBuilder) {
        return new MqttProtocolBuilder(this.wrapped.correlateBy(MessageCorrelators.toScalaCorrelator(checkBuilder)));
    }

    @NonNull
    public MqttProtocolBuilder timeoutCheckInterval(long l) {
        return this.timeoutCheckInterval(Duration.ofSeconds(l));
    }

    @NonNull
    public MqttProtocolBuilder timeoutCheckInterval(@NonNull Duration duration) {
        return new MqttProtocolBuilder(this.wrapped.timeoutCheckInterval(Converters.toScalaDuration((Duration)duration)));
    }

    public Protocol protocol() {
        return this.wrapped.build();
    }
}

