/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.mqtt;

import io.gatling.core.protocol.Protocol;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.ProtocolBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.mqtt.LastWillBuilder;
import io.gatling.javaapi.mqtt.internal.MessageCorrelators;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.net.ssl.KeyManagerFactory;

public final class MqttProtocolBuilder
implements ProtocolBuilder {
    private final io.gatling.mqtt.protocol.MqttProtocolBuilder wrapped;

    MqttProtocolBuilder(io.gatling.mqtt.protocol.MqttProtocolBuilder mqttProtocolBuilder) {
        this.wrapped = mqttProtocolBuilder;
    }

    @Nonnull
    public MqttProtocolBuilder mqttVersion_3_1() {
        return new MqttProtocolBuilder(this.wrapped.mqttVersion_3_1());
    }

    @Nonnull
    public MqttProtocolBuilder mqttVersion_3_1_1() {
        return new MqttProtocolBuilder(this.wrapped.mqttVersion_3_1_1());
    }

    @Nonnull
    public MqttProtocolBuilder broker(@Nonnull String string, int n) {
        return new MqttProtocolBuilder(this.wrapped.broker(string, n));
    }

    @Nonnull
    public MqttProtocolBuilder useTls(boolean bl) {
        return new MqttProtocolBuilder(this.wrapped.useTls(bl));
    }

    @Nonnull
    public MqttProtocolBuilder perUserKeyManagerFactory(@Nonnull Function<Long, KeyManagerFactory> function) {
        return new MqttProtocolBuilder(this.wrapped.perUserKeyManagerFactory(object -> (KeyManagerFactory)function.apply((Long)object)));
    }

    @Nonnull
    public MqttProtocolBuilder clientId(@Nonnull String string) {
        return new MqttProtocolBuilder(this.wrapped.clientId(Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public MqttProtocolBuilder clientId(@Nonnull Function<Session, String> function) {
        return new MqttProtocolBuilder(this.wrapped.clientId(Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public MqttProtocolBuilder cleanSession(boolean bl) {
        return new MqttProtocolBuilder(this.wrapped.cleanSession(bl));
    }

    @Nonnull
    public MqttProtocolBuilder connectTimeout(int n) {
        return this.connectTimeout(Duration.ofSeconds(n));
    }

    @Nonnull
    public MqttProtocolBuilder connectTimeout(@Nonnull Duration duration) {
        return new MqttProtocolBuilder(this.wrapped.connectTimeout(Converters.toScalaDuration((Duration)duration)));
    }

    @Nonnull
    public MqttProtocolBuilder keepAlive(int n) {
        return this.keepAlive(Duration.ofSeconds(n));
    }

    @Nonnull
    public MqttProtocolBuilder keepAlive(@Nonnull Duration duration) {
        return new MqttProtocolBuilder(this.wrapped.keepAlive(Converters.toScalaDuration((Duration)duration)));
    }

    @Nonnull
    public MqttProtocolBuilder qosAtMostOnce() {
        return new MqttProtocolBuilder(this.wrapped.qosAtMostOnce());
    }

    @Nonnull
    public MqttProtocolBuilder qosAtLeastOnce() {
        return new MqttProtocolBuilder(this.wrapped.qosAtLeastOnce());
    }

    @Nonnull
    public MqttProtocolBuilder qosExactlyOnce() {
        return new MqttProtocolBuilder(this.wrapped.qosExactlyOnce());
    }

    @Nonnull
    public MqttProtocolBuilder retain(boolean bl) {
        return new MqttProtocolBuilder(this.wrapped.retain(bl));
    }

    @Nonnull
    public MqttProtocolBuilder credentials(@Nonnull String string, @Nonnull String string2) {
        return new MqttProtocolBuilder(this.wrapped.credentials(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2)));
    }

    @Nonnull
    public MqttProtocolBuilder credentials(@Nonnull Function<Session, String> function, @Nonnull String string) {
        return new MqttProtocolBuilder(this.wrapped.credentials(Expressions.javaFunctionToExpression(function), Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public MqttProtocolBuilder credentials(@Nonnull String string, @Nonnull Function<Session, String> function) {
        return new MqttProtocolBuilder(this.wrapped.credentials(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public MqttProtocolBuilder credentials(@Nonnull Function<Session, String> function, @Nonnull Function<Session, String> function2) {
        return new MqttProtocolBuilder(this.wrapped.credentials(Expressions.javaFunctionToExpression(function), Expressions.javaFunctionToExpression(function2)));
    }

    @Nonnull
    public MqttProtocolBuilder lastWill(@Nonnull LastWillBuilder lastWillBuilder) {
        return new MqttProtocolBuilder(this.wrapped.lastWill(lastWillBuilder.asScala()));
    }

    @Nonnull
    public MqttProtocolBuilder reconnectAttemptsMax(int n) {
        return new MqttProtocolBuilder(this.wrapped.reconnectAttemptsMax(n));
    }

    @Nonnull
    public MqttProtocolBuilder reconnectDelay(int n) {
        return this.reconnectDelay(Duration.ofSeconds(n));
    }

    @Nonnull
    public MqttProtocolBuilder reconnectDelay(@Nonnull Duration duration) {
        return new MqttProtocolBuilder(this.wrapped.reconnectDelay(Converters.toScalaDuration((Duration)duration)));
    }

    @Nonnull
    public MqttProtocolBuilder reconnectBackoffMultiplier(float f) {
        return new MqttProtocolBuilder(this.wrapped.reconnectBackoffMultiplier(f));
    }

    @Nonnull
    public MqttProtocolBuilder resendDelay(int n) {
        return this.resendDelay(Duration.ofSeconds(n));
    }

    @Nonnull
    public MqttProtocolBuilder resendDelay(@Nonnull Duration duration) {
        return new MqttProtocolBuilder(this.wrapped.resendDelay(Converters.toScalaDuration((Duration)duration)));
    }

    @Nonnull
    public MqttProtocolBuilder resendBackoffMultiplier(float f) {
        return new MqttProtocolBuilder(this.wrapped.resendBackoffMultiplier(f));
    }

    @Nonnull
    public MqttProtocolBuilder correlateBy(@Nonnull CheckBuilder checkBuilder) {
        return new MqttProtocolBuilder(this.wrapped.correlateBy(MessageCorrelators.toScalaCorrelator(checkBuilder)));
    }

    @Nonnull
    public MqttProtocolBuilder timeoutCheckInterval(int n) {
        return this.timeoutCheckInterval(Duration.ofSeconds(n));
    }

    @Nonnull
    public MqttProtocolBuilder timeoutCheckInterval(@Nonnull Duration duration) {
        return new MqttProtocolBuilder(this.wrapped.timeoutCheckInterval(Converters.toScalaDuration((Duration)duration)));
    }

    public Protocol protocol() {
        return this.wrapped.build();
    }
}

