/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.mqtt;

import io.gatling.javaapi.core.ActionBuilder;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.mqtt.internal.MqttChecks;
import io.gatling.mqtt.action.builder.CheckableSubscribeBuilder;
import io.gatling.mqtt.action.builder.SubscribeBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public final class SubscribeActionBuilder
implements ActionBuilder {
    private final SubscribeBuilder wrapped;

    SubscribeActionBuilder(SubscribeBuilder subscribeBuilder) {
        this.wrapped = subscribeBuilder;
    }

    @Nonnull
    public SubscribeActionBuilder qosAtMostOnce() {
        return new SubscribeActionBuilder(this.wrapped.qosAtMostOnce());
    }

    @Nonnull
    public SubscribeActionBuilder qosAtLeastOnce() {
        return new SubscribeActionBuilder(this.wrapped.qosAtLeastOnce());
    }

    @Nonnull
    public SubscribeActionBuilder qosExactlyOnce() {
        return new SubscribeActionBuilder(this.wrapped.qosExactlyOnce());
    }

    @Nonnull
    public Checkable wait(int n) {
        return this.wait(Duration.ofSeconds(n));
    }

    @Nonnull
    public Checkable wait(@Nonnull Duration duration) {
        return new Checkable(this.wrapped.wait(Converters.toScalaDuration((Duration)duration)));
    }

    @Nonnull
    public Checkable expect(int n) {
        return this.expect(Duration.ofSeconds(n));
    }

    @Nonnull
    public Checkable expect(@Nonnull Duration duration) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)duration)));
    }

    public io.gatling.core.action.builder.ActionBuilder asScala() {
        return this.wrapped;
    }

    public static final class Checkable
    implements ActionBuilder {
        private final SubscribeBuilder wrapped;

        Checkable(SubscribeBuilder subscribeBuilder) {
            this.wrapped = subscribeBuilder;
        }

        @Nonnull
        public SubscribeActionBuilder qosAtMostOnce() {
            return new SubscribeActionBuilder(this.wrapped.qosAtMostOnce());
        }

        @Nonnull
        public SubscribeActionBuilder qosAtLeastOnce() {
            return new SubscribeActionBuilder(this.wrapped.qosAtLeastOnce());
        }

        @Nonnull
        public SubscribeActionBuilder qosExactlyOnce() {
            return new SubscribeActionBuilder(this.wrapped.qosExactlyOnce());
        }

        @Nonnull
        public Checkable check(CheckBuilder ... checkBuilderArray) {
            return this.check(Arrays.asList(checkBuilderArray));
        }

        @Nonnull
        public Checkable check(@Nonnull List<CheckBuilder> list) {
            return new Checkable(((CheckableSubscribeBuilder)this.wrapped).check(MqttChecks.toScalaChecks(list)));
        }

        public io.gatling.core.action.builder.ActionBuilder asScala() {
            return this.wrapped;
        }
    }
}

