/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.mqtt;

import io.gatling.javaapi.core.ActionBuilder;
import io.gatling.javaapi.core.Body;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.mqtt.internal.MqttChecks;
import io.gatling.mqtt.action.builder.CheckablePublishBuilder;
import io.gatling.mqtt.action.builder.MqttActionPublishBase;
import io.gatling.mqtt.action.builder.PublishBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class PublishActionBuilder
implements ActionBuilder {
    private final PublishBuilder wrapped;

    public PublishActionBuilder(PublishBuilder publishBuilder) {
        this.wrapped = publishBuilder;
    }

    @Nonnull
    public PublishActionBuilder qosAtMostOnce() {
        return new PublishActionBuilder(this.wrapped.qosAtMostOnce());
    }

    @Nonnull
    public PublishActionBuilder qosAtLeastOnce() {
        return new PublishActionBuilder(this.wrapped.qosAtLeastOnce());
    }

    @Nonnull
    public PublishActionBuilder qosExactlyOnce() {
        return new PublishActionBuilder(this.wrapped.qosExactlyOnce());
    }

    @Nonnull
    public Checkable await(long l) {
        return this.await(Duration.ofSeconds(l));
    }

    @Nonnull
    public Checkable await(@Nonnull Duration duration) {
        return new Checkable(this.wrapped.await(Converters.toScalaDuration((Duration)duration)));
    }

    @Nonnull
    public Checkable await(long l, @Nonnull String string) {
        return new Checkable(this.wrapped.wait(Converters.toScalaDuration((Duration)Duration.ofSeconds(l)), Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public Checkable await(Duration duration, @Nonnull String string) {
        return new Checkable(this.wrapped.wait(Converters.toScalaDuration((Duration)duration), Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public Checkable wait(long l, @Nonnull Function<Session, String> function) {
        return new Checkable(this.wrapped.wait(Converters.toScalaDuration((Duration)Duration.ofSeconds(l)), Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public Checkable wait(@Nonnull Duration duration, @Nonnull Function<Session, String> function) {
        return new Checkable(this.wrapped.wait(Converters.toScalaDuration((Duration)duration), Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public Checkable expect(long l) {
        return this.expect(Duration.ofSeconds(l));
    }

    @Nonnull
    public Checkable expect(@Nonnull Duration duration) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)duration)));
    }

    @Nonnull
    public Checkable expect(long l, @Nonnull String string) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)Duration.ofSeconds(l)), Expressions.toStringExpression((String)string)));
    }

    @Nonnull
    public Checkable expect(@Nonnull Duration duration, @Nonnull Function<Session, String> function) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)duration), Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public Checkable expect(long l, @Nonnull Function<Session, String> function) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)Duration.ofSeconds(l)), Expressions.javaFunctionToExpression(function)));
    }

    @Nonnull
    public Checkable expect(@Nonnull Duration duration, @Nonnull String string) {
        return new Checkable(this.wrapped.expect(Converters.toScalaDuration((Duration)duration), Expressions.toStringExpression((String)string)));
    }

    public io.gatling.core.action.builder.ActionBuilder asScala() {
        return this.wrapped;
    }

    public static class Checkable
    implements ActionBuilder {
        private final PublishBuilder wrapped;

        private Checkable(PublishBuilder publishBuilder) {
            this.wrapped = publishBuilder;
        }

        @Nonnull
        public PublishActionBuilder qosAtMostOnce() {
            return new PublishActionBuilder(this.wrapped.qosAtMostOnce());
        }

        @Nonnull
        public PublishActionBuilder qosAtLeastOnce() {
            return new PublishActionBuilder(this.wrapped.qosAtLeastOnce());
        }

        @Nonnull
        public PublishActionBuilder qosExactlyOnce() {
            return new PublishActionBuilder(this.wrapped.qosExactlyOnce());
        }

        @Nonnull
        public Checkable check(CheckBuilder ... checkBuilderArray) {
            return this.check(Arrays.asList(checkBuilderArray));
        }

        @Nonnull
        public Checkable check(@Nonnull List<CheckBuilder> list) {
            return new Checkable(((CheckablePublishBuilder)this.wrapped).check(MqttChecks.toScalaChecks(list)));
        }

        public io.gatling.core.action.builder.ActionBuilder asScala() {
            return this.wrapped;
        }
    }

    public static final class Base {
        private final MqttActionPublishBase wrapped;

        Base(MqttActionPublishBase mqttActionPublishBase) {
            this.wrapped = mqttActionPublishBase;
        }

        @Nonnull
        public PublishActionBuilder message(@Nonnull Body body) {
            return new PublishActionBuilder(this.wrapped.message(body.asScala()));
        }
    }
}

