/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.netty.util.ahc;

import io.gatling.netty.util.ahc.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public class Utf8ByteBufCharsetDecoder {
    private static final int INITIAL_CHAR_BUFFER_SIZE = 1024;
    private static final int UTF_8_MAX_BYTES_PER_CHAR = 4;
    private static final char INVALID_CHAR_REPLACEMENT = '\ufffd';
    private static final ThreadLocal<Utf8ByteBufCharsetDecoder> POOL = ThreadLocal.withInitial(Utf8ByteBufCharsetDecoder::new);
    private final CharsetDecoder decoder = Utf8ByteBufCharsetDecoder.configureReplaceCodingErrorActions(StandardCharsets.UTF_8.newDecoder());
    protected CharBuffer charBuffer = this.allocateCharBuffer(1024);
    private ByteBuffer splitCharBuffer = ByteBuffer.allocate(4);
    private int totalSize = 0;
    private int totalNioBuffers = 0;
    private boolean withoutArray = false;

    private static Utf8ByteBufCharsetDecoder pooledDecoder() {
        Utf8ByteBufCharsetDecoder utf8ByteBufCharsetDecoder = POOL.get();
        utf8ByteBufCharsetDecoder.reset();
        return utf8ByteBufCharsetDecoder;
    }

    public static String decodeUtf8(ByteBuf byteBuf) {
        return Utf8ByteBufCharsetDecoder.pooledDecoder().decode(byteBuf);
    }

    public static String decodeUtf8(ByteBuf ... byteBufArray) {
        return Utf8ByteBufCharsetDecoder.pooledDecoder().decode(byteBufArray);
    }

    public static char[] decodeUtf8Chars(ByteBuf byteBuf) {
        return Utf8ByteBufCharsetDecoder.pooledDecoder().decodeChars(byteBuf);
    }

    public static char[] decodeUtf8Chars(ByteBuf ... byteBufArray) {
        return Utf8ByteBufCharsetDecoder.pooledDecoder().decodeChars(byteBufArray);
    }

    private static CharsetDecoder configureReplaceCodingErrorActions(CharsetDecoder charsetDecoder) {
        return charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private static int moreThanOneByteCharSize(byte by) {
        if (by >> 5 == -2 && (by & 0x1E) != 0) {
            return 2;
        }
        if (by >> 4 == -2) {
            return 3;
        }
        if (by >> 3 == -2) {
            return 4;
        }
        return -1;
    }

    private static boolean isContinuation(byte by) {
        return by >> 6 == -2;
    }

    protected CharBuffer allocateCharBuffer(int n) {
        return CharBuffer.allocate(n);
    }

    protected void ensureCapacity(int n) {
        if (this.charBuffer.position() == 0) {
            if (this.charBuffer.capacity() < n) {
                this.charBuffer = this.allocateCharBuffer(n);
            }
        } else if (this.charBuffer.remaining() < n) {
            CharBuffer charBuffer = this.allocateCharBuffer(this.charBuffer.position() + n);
            this.charBuffer.flip();
            charBuffer.put(this.charBuffer);
            this.charBuffer = charBuffer;
        }
    }

    public void reset() {
        Utf8ByteBufCharsetDecoder.configureReplaceCodingErrorActions(this.decoder.reset());
        this.charBuffer.clear();
        this.splitCharBuffer.clear();
        this.totalSize = 0;
        this.totalNioBuffers = 0;
        this.withoutArray = false;
    }

    private boolean stashContinuationBytes(ByteBuffer byteBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            byte by = byteBuffer.get();
            if (!Utf8ByteBufCharsetDecoder.isContinuation(by)) {
                byteBuffer.position(byteBuffer.position() - 1);
                this.charBuffer.append('\ufffd');
                this.splitCharBuffer.clear();
                return false;
            }
            this.splitCharBuffer.put(by);
        }
        return true;
    }

    private void handlePendingSplitCharBuffer(ByteBuffer byteBuffer, boolean bl) {
        int n = Utf8ByteBufCharsetDecoder.moreThanOneByteCharSize(this.splitCharBuffer.get(0));
        if (n > 0) {
            int n2 = n - this.splitCharBuffer.position();
            if (byteBuffer.remaining() < n2) {
                if (bl) {
                    this.charBuffer.append('\ufffd');
                } else {
                    this.stashContinuationBytes(byteBuffer, byteBuffer.remaining());
                }
            } else if (this.stashContinuationBytes(byteBuffer, n2)) {
                this.splitCharBuffer.flip();
                this.decoder.decode(this.splitCharBuffer, this.charBuffer, bl && !byteBuffer.hasRemaining());
                this.splitCharBuffer.clear();
            }
        } else {
            this.charBuffer.append('\ufffd');
            this.splitCharBuffer.clear();
        }
    }

    protected void decodePartial(ByteBuffer byteBuffer, boolean bl) {
        CoderResult coderResult;
        if (this.splitCharBuffer.position() > 0 && byteBuffer.hasRemaining()) {
            this.handlePendingSplitCharBuffer(byteBuffer, bl);
        }
        if (byteBuffer.hasRemaining() && (coderResult = this.decoder.decode(byteBuffer, this.charBuffer, bl)).isUnderflow() && byteBuffer.remaining() > 0) {
            this.splitCharBuffer.put(byteBuffer);
        }
    }

    private void decode(ByteBuffer[] byteBufferArray) {
        int n = byteBufferArray.length;
        for (int i = 0; i < n; ++i) {
            this.decodePartial(byteBufferArray[i].duplicate(), i == n - 1);
        }
    }

    private void decodeSingleNioBuffer(ByteBuffer byteBuffer) {
        this.decoder.decode(byteBuffer, this.charBuffer, true);
    }

    public String decode(ByteBuf byteBuf) {
        if (byteBuf.isDirect()) {
            return ByteBufUtils.decodeString(StandardCharsets.UTF_8, byteBuf);
        }
        this.decodeHeap0(byteBuf);
        return this.charBuffer.toString();
    }

    public char[] decodeChars(ByteBuf byteBuf) {
        if (byteBuf.isDirect()) {
            return ByteBufUtils.decodeChars(StandardCharsets.UTF_8, byteBuf);
        }
        this.decodeHeap0(byteBuf);
        return ByteBufUtils.toCharArray(this.charBuffer);
    }

    public String decode(ByteBuf ... byteBufArray) {
        if (byteBufArray.length == 1) {
            return this.decode(byteBufArray[0]);
        }
        this.inspectByteBufs(byteBufArray);
        if (this.withoutArray) {
            return ByteBufUtils.byteBuf2String0(StandardCharsets.UTF_8, byteBufArray);
        }
        this.decodeHeap0(byteBufArray);
        return this.charBuffer.toString();
    }

    public char[] decodeChars(ByteBuf ... byteBufArray) {
        if (byteBufArray.length == 1) {
            return this.decodeChars(byteBufArray[0]);
        }
        this.inspectByteBufs(byteBufArray);
        if (this.withoutArray) {
            return ByteBufUtils.byteBuf2Chars0(StandardCharsets.UTF_8, byteBufArray);
        }
        this.decodeHeap0(byteBufArray);
        return ByteBufUtils.toCharArray(this.charBuffer);
    }

    private void decodeHeap0(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        this.ensureCapacity(n);
        if (byteBuf.nioBufferCount() == 1) {
            this.decodeSingleNioBuffer(byteBuf.internalNioBuffer(byteBuf.readerIndex(), n).duplicate());
        } else {
            this.decode(byteBuf.nioBuffers());
        }
        this.charBuffer.flip();
    }

    private void decodeHeap0(ByteBuf[] byteBufArray) {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.totalNioBuffers];
        int n = 0;
        for (ByteBuf byteBuf : byteBufArray) {
            for (ByteBuffer byteBuffer : byteBuf.nioBuffers()) {
                byteBufferArray[n++] = byteBuffer;
            }
        }
        this.ensureCapacity(this.totalSize);
        this.decode(byteBufferArray);
        this.charBuffer.flip();
    }

    private void inspectByteBufs(ByteBuf[] byteBufArray) {
        for (ByteBuf byteBuf : byteBufArray) {
            if (!byteBuf.hasArray()) {
                this.withoutArray = true;
                break;
            }
            this.totalSize += byteBuf.readableBytes();
            this.totalNioBuffers += byteBuf.nioBufferCount();
        }
    }
}

