package io.gatling.recorder.internal.bouncycastle.oer.its.ieee1609dot2.basetypes;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Choice;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Encodable;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Object;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1OctetString;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1Primitive;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1TaggedObject;
import io.gatling.recorder.internal.bouncycastle.asn1.DEROctetString;
import io.gatling.recorder.internal.bouncycastle.asn1.DERTaggedObject;


/**
 * IdentifiedRegion ::= CHOICE {
 * countryOnly           CountryOnly,
 * countryAndRegions     CountryAndRegions,
 * countryAndSubregions  CountryAndSubregions,
 * ...
 * }
 */
public class IdentifiedRegion
    extends ASN1Object
    implements ASN1Choice, RegionInterface
{

    public static final int countryOnly = 0;
    public static final int countryAndRegions = 1;
    public static final int countryAndSubregions = 2;

    private final int choice;
    private final ASN1Encodable identifiedRegion;

    public IdentifiedRegion(int choice, ASN1Encodable region)
    {
        this.choice = choice;
        this.identifiedRegion = region;
    }

    private IdentifiedRegion(ASN1TaggedObject ato)
    {
        this.choice = ato.getTagNo();

        switch (choice)
        {
        case countryOnly:
            identifiedRegion = CountryOnly.getInstance(ato.getObject());
            break;
        case countryAndRegions:
            identifiedRegion = CountryAndRegions.getInstance(ato.getObject());
            break;
        case countryAndSubregions:
            identifiedRegion = CountryAndSubregions.getInstance(ato.getObject());
            break;
        default:
            throw new IllegalArgumentException("invalid choice value " + choice);
        }
    }

    public static IdentifiedRegion countryOnly(CountryOnly only)
    {
        return new IdentifiedRegion(countryOnly, only);
    }

    public static IdentifiedRegion countryAndRegions(CountryAndRegions value)
    {
        return new IdentifiedRegion(countryAndRegions, value);
    }

    public static IdentifiedRegion countryAndSubregions(CountryAndSubregions countryAndSubregions)
    {
        return new IdentifiedRegion(IdentifiedRegion.countryAndSubregions, countryAndSubregions);
    }


    public static IdentifiedRegion getInstance(Object o)
    {
        if (o instanceof IdentifiedRegion)
        {
            return (IdentifiedRegion)o;
        }
        if (o != null)
        {
            return new IdentifiedRegion(ASN1TaggedObject.getInstance(o));
        }

        return null;
    }

    public int getChoice()
    {
        return choice;
    }

    public ASN1Encodable getIdentifiedRegion()
    {
        return identifiedRegion;
    }

    public ASN1Primitive toASN1Primitive()
    {
        return new DERTaggedObject(choice, identifiedRegion);
    }
}
