/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.crypto.paddings;

import io.gatling.recorder.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import io.gatling.recorder.internal.bouncycastle.crypto.InvalidCipherTextException;
import io.gatling.recorder.internal.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class ISO10126d2Padding
implements BlockCipherPadding {
    SecureRandom random;

    @Override
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
        this.random = CryptoServicesRegistrar.getSecureRandom(secureRandom);
    }

    @Override
    public String getPaddingName() {
        return "ISO10126-2";
    }

    @Override
    public int addPadding(byte[] byArray, int n) {
        byte by = (byte)(byArray.length - n);
        while (n < byArray.length - 1) {
            byArray[n] = (byte)this.random.nextInt();
            ++n;
        }
        byArray[n] = by;
        return by;
    }

    @Override
    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n = byArray[byArray.length - 1] & 0xFF;
        if (n > byArray.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n;
    }
}

