package io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike;

import java.security.SecureRandom;

import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import io.gatling.recorder.internal.bouncycastle.crypto.CryptoServicePurpose;
import io.gatling.recorder.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import io.gatling.recorder.internal.bouncycastle.crypto.KeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.crypto.constraints.DefaultServiceProperties;

public class SIKEKeyPairGenerator
    implements AsymmetricCipherKeyPairGenerator
{
    private SIKEKeyGenerationParameters sikeParams;

    private SecureRandom random;

    private void initialize(KeyGenerationParameters param)
    {
        this.sikeParams = (SIKEKeyGenerationParameters) param;
        this.random = param.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair()
    {
        // -DM System.err.println
        System.err.println("WARNING: the SIKE algorithm is only for research purposes, insecure");
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("SIKEKeyGen", 0, sikeParams.getParameters(), CryptoServicePurpose.KEYGEN));

        SIKEEngine engine = sikeParams.getParameters().getEngine();
        byte[] sk = new byte[engine.getPrivateKeySize()];
        byte[] pk = new byte[engine.getPublicKeySize()];

        engine.crypto_kem_keypair(pk, sk, random);


        SIKEPublicKeyParameters pubKey = new SIKEPublicKeyParameters(sikeParams.getParameters(), pk);
        SIKEPrivateKeyParameters privKey = new SIKEPrivateKeyParameters(sikeParams.getParameters(), sk);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    public void init(KeyGenerationParameters param)
    {
        this.initialize(param);
    }

    public AsymmetricCipherKeyPair generateKeyPair()
    {
        return genKeyPair();
    }
}
