package io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider;

import io.gatling.recorder.internal.bouncycastle.asn1.bc.BCObjectIdentifiers;
import io.gatling.recorder.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import io.gatling.recorder.internal.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;
import io.gatling.recorder.internal.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.sike.SIKEKeyFactorySpi;

public class SIKE
{
    private static final String PREFIX = "io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider" + ".sike.";

    public static class Mappings
        extends AsymmetricAlgorithmProvider
    {
        public Mappings()
        {
        }

        public void configure(ConfigurableProvider provider)
        {
            provider.addAlgorithm("KeyFactory.SIKE", PREFIX + "SIKEKeyFactorySpi");
            provider.addAlgorithm("KeyPairGenerator.SIKE", PREFIX + "SIKEKeyPairGeneratorSpi");

            provider.addAlgorithm("KeyGenerator.SIKE", PREFIX + "SIKEKeyGeneratorSpi");

            AsymmetricKeyInfoConverter keyFact = new SIKEKeyFactorySpi();

            provider.addAlgorithm("Cipher.SIKE", PREFIX + "SIKECipherSpi$Base");
            provider.addAlgorithm("Alg.Alias.Cipher." + BCObjectIdentifiers.pqc_kem_sike, "SIKE");

            registerOid(provider, BCObjectIdentifiers.pqc_kem_sike, "SIKE", keyFact);
        }
    }
}
